/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.guitools;

import de.uwemock.guitools.AbstractStandardDialogPanel;
import de.uwemock.guitools.StandardDialog;
import de.uwemock.guitools.validators.BlockEmptyInputValidator;
import de.uwemock.guitools.validators.ValidatorHook;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class SingleLineTextInputDialog
extends JDialog {
    private SingleLineTextInputDialog() {
    }

    public static String showInputDialog(Frame parent, String title, String label, String preset, boolean allowEmpty) {
        InputPanel panel = new InputPanel(title, label, preset, allowEmpty);
        StandardDialog dialog = new StandardDialog(parent, title, panel);
        dialog.setVisible(true);
        return panel.getResult();
    }

    static class InputPanel
    extends AbstractStandardDialogPanel {
        private String title;
        private boolean allowEmpty;
        private JTextField textField = new JTextField(35);
        private String result;

        public InputPanel(String title, String label, String preset, boolean allowEmpty) {
            this.title = title;
            this.allowEmpty = allowEmpty;
            this.setBorder(BorderFactory.createTitledBorder(title));
            this.setLayout(new BorderLayout(10, 0));
            this.add("West", new JLabel(label));
            this.add("Center", this.textField);
            if (preset != null) {
                this.textField.setText(preset);
            }
        }

        @Override
        public void saveDialogData() {
            this.result = this.textField.getText();
        }

        @Override
        public Component getComponent() {
            return this;
        }

        @Override
        public String getTitle() {
            return this.title;
        }

        @Override
        public void setOkAction(Action okAction) {
            if (!this.allowEmpty) {
                new ValidatorHook(this.textField, new BlockEmptyInputValidator(okAction));
            }
        }

        public String getResult() {
            return this.result;
        }
    }
}

