/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.guitools;

import de.uwemock.guitools.AbstractSimpleAssistantPanel;
import de.uwemock.guitools.PushUpPanel;
import de.uwemock.guitools.SimpleAssistantPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class SimpleAssistant
extends JDialog {
    private static final String TITLE_START_PANEL = "START";
    private static final String TITLE_NEXT_PANEL = "NEXT";
    private static final String TITLE_FINISH_PANEL = "FINISH";
    private static final String TITLE_OVERVIEW = "\u00dcberblick";
    private Frame parent;
    private List<SimpleAssistantPanel> inputPanels;
    private OverviewPanel overviewPanel;
    private JPanel buttonPanelStart = new JPanel(new FlowLayout(1));
    private JPanel buttonPanelNext = new JPanel(new FlowLayout(1));
    private JPanel buttonPanelFinish = new JPanel(new FlowLayout(1));
    private JPanel assistantPanel;
    private JPanel informationPanel;
    private JPanel assistantButtonPanel;
    private Action startAction;
    private Action nextAction;
    private Action prevAction;
    private Action finishAction;
    private Action cancelAction;
    private int currentlyShowing;
    private boolean showInformation;
    private String informationType = "text/plain";
    private String informationTitle = "Information";
    private String overviewInformationText = null;

    public SimpleAssistant(Frame parent, String title) {
        super(parent, title);
        this.setModal(true);
        this.createActions();
        this.inputPanels = new ArrayList<SimpleAssistantPanel>();
        this.showInformation = false;
        this.parent = parent;
    }

    public SimpleAssistant(JFrame parent) {
        super((Frame)parent, "Assistent");
        this.createActions();
        this.inputPanels = new Vector<SimpleAssistantPanel>();
        this.showInformation = false;
    }

    public SimpleAssistant(JFrame parent, List<SimpleAssistantPanel> panels) {
        super((Frame)parent, "Assistent");
        this.createActions();
        this.inputPanels = panels;
        this.showInformation = false;
    }

    public SimpleAssistant(JFrame parent, String title, List<SimpleAssistantPanel> panels) {
        super((Frame)parent, title);
        this.createActions();
        this.inputPanels = panels;
        this.showInformation = false;
    }

    public SimpleAssistant(JFrame parent, String title, boolean showInformation) {
        this((Frame)parent, title);
        this.showInformation = showInformation;
    }

    public SimpleAssistant(JFrame parent, boolean showInformation) {
        this(parent);
        this.showInformation = showInformation;
    }

    public SimpleAssistant(JFrame parent, List<SimpleAssistantPanel> panels, boolean showInformation) {
        this(parent, panels);
        this.showInformation = showInformation;
    }

    public SimpleAssistant(JFrame parent, String title, Vector<SimpleAssistantPanel> panels, boolean showInformation) {
        this(parent, title, panels);
        this.showInformation = showInformation;
    }

    private void createActions() {
        this.nextAction = new AbstractAction("Weiter >"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SimpleAssistantPanel oldPanel = (SimpleAssistantPanel)SimpleAssistant.this.inputPanels.get(SimpleAssistant.this.currentlyShowing);
                ((SimpleAssistantPanel)SimpleAssistant.this.inputPanels.get(SimpleAssistant.this.currentlyShowing)).setFinished(true);
                SimpleAssistant simpleAssistant = SimpleAssistant.this;
                int n = simpleAssistant.currentlyShowing + 1;
                simpleAssistant.currentlyShowing = n;
                SimpleAssistant.this.showInputPanel(n);
                oldPanel.panelNowShowing(false);
                ((SimpleAssistantPanel)SimpleAssistant.this.inputPanels.get(SimpleAssistant.this.currentlyShowing)).panelNowShowing(true);
            }
        };
        this.prevAction = new AbstractAction("< Zur\u00fcck"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SimpleAssistantPanel oldPanel = (SimpleAssistantPanel)SimpleAssistant.this.inputPanels.get(SimpleAssistant.this.currentlyShowing);
                SimpleAssistant simpleAssistant = SimpleAssistant.this;
                int n = simpleAssistant.currentlyShowing - 1;
                simpleAssistant.currentlyShowing = n;
                SimpleAssistant.this.showInputPanel(n);
                oldPanel.setFinished(false);
                oldPanel.panelNowShowing(false);
                ((SimpleAssistantPanel)SimpleAssistant.this.inputPanels.get(SimpleAssistant.this.currentlyShowing)).panelNowShowing(true);
                SimpleAssistant.this.nextAction.setEnabled(true);
            }
        };
        this.startAction = new AbstractAction("Start"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SimpleAssistantPanel oldPanel = (SimpleAssistantPanel)SimpleAssistant.this.inputPanels.get(SimpleAssistant.this.currentlyShowing);
                SimpleAssistant simpleAssistant = SimpleAssistant.this;
                int n = simpleAssistant.currentlyShowing + 1;
                simpleAssistant.currentlyShowing = n;
                SimpleAssistant.this.showInputPanel(n);
                oldPanel.panelNowShowing(false);
                ((SimpleAssistantPanel)SimpleAssistant.this.inputPanels.get(SimpleAssistant.this.currentlyShowing)).panelNowShowing(true);
            }
        };
        this.finishAction = new AbstractAction("Fertigstellen"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ((SimpleAssistantPanel)SimpleAssistant.this.inputPanels.get(SimpleAssistant.this.currentlyShowing)).setFinished(true);
                ((SimpleAssistantPanel)SimpleAssistant.this.inputPanels.get(SimpleAssistant.this.currentlyShowing)).panelNowShowing(false);
                if (SimpleAssistant.this.allFinished()) {
                    SimpleAssistant.this.saveDialogData();
                }
                SimpleAssistant.this.dispose();
            }
        };
        this.cancelAction = new AbstractAction("Abbrechen"){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SimpleAssistant.this.cancelAssistant();
            }
        };
        this.buttonPanelStart.add(new JButton(this.startAction));
        this.buttonPanelStart.add(new JButton(this.cancelAction));
        this.buttonPanelNext.add(new JButton(this.prevAction));
        this.buttonPanelNext.add(new JButton(this.nextAction));
        this.buttonPanelNext.add(new JButton(this.cancelAction));
        this.buttonPanelFinish.add(new JButton(this.prevAction));
        this.buttonPanelFinish.add(new JButton(this.finishAction));
        this.buttonPanelFinish.add(new JButton(this.cancelAction));
        this.inputPanels = new Vector<SimpleAssistantPanel>();
    }

    public void setInformationType(String type) {
        this.informationType = type;
    }

    public void setInformationTitle(String title) {
        this.informationTitle = title;
    }

    public void setOverviewInformationText(String text) {
        this.overviewInformationText = text;
    }

    public void addAssistantPanel(SimpleAssistantPanel newPanel) {
        this.inputPanels.add(newPanel);
    }

    public void remove(SimpleAssistantPanel panel) {
        this.inputPanels.remove(this.inputPanels.indexOf(panel));
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.setLayout(new BorderLayout());
            this.overviewPanel = new OverviewPanel(this.overviewInformationText);
            this.inputPanels.add(0, this.overviewPanel);
            this.overviewPanel.setLayout(new GridLayout(this.inputPanels.size(), 1, 10, 20));
            this.assistantPanel = new JPanel(new CardLayout());
            this.informationPanel = this.showInformation ? new JPanel(new CardLayout()) : null;
            int i = 0;
            while (i < this.inputPanels.size()) {
                SimpleAssistantPanel inputPanel = this.inputPanels.get(i);
                PushUpPanel componentPanel = new PushUpPanel(inputPanel.getComponent());
                this.assistantPanel.add(inputPanel.getTitle(), componentPanel);
                componentPanel.setBorder(BorderFactory.createTitledBorder(inputPanel.getTitle()));
                this.overviewPanel.add(new JLabel(String.valueOf(i + 1) + ". " + this.inputPanels.get(i).getTitle()));
                if (this.showInformation) {
                    JPanel infoPanel = new JPanel(new BorderLayout());
                    infoPanel.setBorder(BorderFactory.createTitledBorder(this.informationTitle));
                    JEditorPane editor = new JEditorPane(this.informationType, inputPanel.getInformationText());
                    editor.setEditable(false);
                    editor.setBackground(infoPanel.getBackground());
                    JScrollPane scroller = new JScrollPane(editor);
                    scroller.setBorder(null);
                    infoPanel.add("Center", scroller);
                    this.informationPanel.add(inputPanel.getTitle(), infoPanel);
                }
                ++i;
            }
            if (this.informationPanel == null) {
                this.add("Center", this.assistantPanel);
            } else {
                this.assistantPanel.setMinimumSize(new Dimension(10, 10));
                this.informationPanel.setMinimumSize(new Dimension(1, 1));
                JSplitPane splitPane = new JSplitPane(1, this.assistantPanel, this.informationPanel);
                splitPane.setDividerLocation(0.5);
                splitPane.setOneTouchExpandable(true);
                splitPane.setResizeWeight(0.5);
                this.add("Center", splitPane);
            }
            this.assistantButtonPanel = new JPanel(new CardLayout());
            this.assistantButtonPanel.add(TITLE_START_PANEL, this.buttonPanelStart);
            this.assistantButtonPanel.add(TITLE_NEXT_PANEL, this.buttonPanelNext);
            this.assistantButtonPanel.add(TITLE_FINISH_PANEL, this.buttonPanelFinish);
            this.add((Component)this.assistantButtonPanel, "South");
            this.currentlyShowing = 0;
            this.showInputPanel(0);
            this.pack();
            this.setSize(Toolkit.getDefaultToolkit().getScreenSize().width / 2, Toolkit.getDefaultToolkit().getScreenSize().height / 2);
            this.setLocationRelativeTo(this.parent);
            super.setVisible(visible);
        } else {
            if (!this.mayBeCancelled()) {
                return;
            }
            super.setVisible(visible);
            this.inputPanels.remove(this.overviewPanel);
            this.overviewPanel = null;
        }
    }

    public boolean allFinished() {
        boolean res = true;
        int i = 0;
        while (i < this.inputPanels.size() && res) {
            res = res && this.inputPanels.get(i).isFinished();
            ++i;
        }
        return res;
    }

    public void saveDialogData() {
        int i = 0;
        while (i < this.inputPanels.size()) {
            this.inputPanels.get(i).saveDialogData();
            ++i;
        }
    }

    private void showInputPanel(int index) {
        CardLayout cl = (CardLayout)this.assistantPanel.getLayout();
        SimpleAssistantPanel panel = this.inputPanels.get(index);
        panel.setFinished(false);
        cl.show(this.assistantPanel, panel.getTitle());
        if (this.informationPanel != null) {
            cl = (CardLayout)this.informationPanel.getLayout();
            cl.show(this.informationPanel, panel.getTitle());
        }
        cl = (CardLayout)this.assistantButtonPanel.getLayout();
        if (index == 0) {
            cl.show(this.assistantButtonPanel, TITLE_START_PANEL);
            panel.setNextAction(this.startAction);
            return;
        }
        if (index == this.inputPanels.size() - 1) {
            cl.show(this.assistantButtonPanel, TITLE_FINISH_PANEL);
            panel.setNextAction(this.finishAction);
            return;
        }
        cl.show(this.assistantButtonPanel, TITLE_NEXT_PANEL);
        panel.setNextAction(this.nextAction);
    }

    private boolean mayBeCancelled() {
        for (SimpleAssistantPanel sap : this.inputPanels) {
            if (sap.mayBeCancelled()) continue;
            return false;
        }
        return true;
    }

    public void cancelAssistant() {
        if (!this.mayBeCancelled()) {
            return;
        }
        this.inputPanels.get(this.currentlyShowing).panelNowShowing(false);
        this.dispose();
    }

    @Override
    public void dispose() {
        for (SimpleAssistantPanel sap : this.inputPanels) {
            sap.dispose();
        }
        super.dispose();
    }

    private static class OverviewPanel
    extends AbstractSimpleAssistantPanel {
        private String informationText = null;

        public OverviewPanel() {
        }

        public OverviewPanel(String informationText) {
            this.informationText = informationText;
        }

        @Override
        public String getTitle() {
            return SimpleAssistant.TITLE_OVERVIEW;
        }

        @Override
        public boolean isFinished() {
            return true;
        }

        @Override
        public String getInformationText() {
            return this.informationText;
        }
    }
}

