/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.guitools;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

class SelectFromListTableModel<T>
extends AbstractTableModel {
    private List<T> list;
    private boolean[] selected;
    public String[] columnNames;

    public SelectFromListTableModel(List<T> list, String[] columnNames) {
        this.list = list == null ? new ArrayList<T>() : list;
        this.selected = new boolean[this.list.size()];
        this.columnNames = columnNames;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (col == 0) {
            return this.selected[row];
        }
        return this.list.get(row).toString();
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.list.size();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.columnNames[columnIndex];
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Boolean.class;
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 0;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (aValue instanceof Boolean) {
            this.selected[rowIndex] = (Boolean)aValue;
        }
    }

    public List<T> getSelectedItems() {
        ArrayList<T> res = new ArrayList<T>();
        int i = 0;
        while (i < this.selected.length) {
            if (this.selected[i]) {
                res.add(this.list.get(i));
            }
            ++i;
        }
        return res;
    }
}

