/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.guitools;

import de.uwemock.guitools.RunnableResultReceiver;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class ProgressBarForRunnable {
    private Frame parent;
    private JDialog dialog;
    private final JProgressBar progressBar = new JProgressBar();
    private JLabel textLabel = new JLabel();
    private final Runnable runnable;
    private final RunnableResultReceiver resultReceiver;

    public ProgressBarForRunnable(Frame parent, Runnable runnable) {
        this(parent, runnable, null);
    }

    public ProgressBarForRunnable(Frame parent, Runnable runnable, RunnableResultReceiver resultReceiver) {
        this.parent = parent;
        this.runnable = runnable;
        this.resultReceiver = resultReceiver;
        this.progressBar.setIndeterminate(true);
        JPanel panel = new JPanel(new GridLayout(3, 1));
        panel.add(this.textLabel);
        panel.add(Box.createVerticalStrut(10));
        panel.add(this.progressBar);
        this.dialog = new JDialog(this.parent, true);
        this.dialog.setResizable(false);
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.setLayout(new BorderLayout(10, 10));
        this.dialog.add((Component)panel, "Center");
        this.dialog.add(Box.createVerticalStrut(5), "North");
        this.dialog.add(Box.createVerticalStrut(5), "South");
        this.dialog.add(Box.createHorizontalStrut(5), "West");
        this.dialog.add(Box.createHorizontalStrut(5), "East");
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    public Frame getParent() {
        return this.parent;
    }

    public void start() {
        Thread worker = new Thread(){

            @Override
            public void run() {
                try {
                    ProgressBarForRunnable.this.runnable.run();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProgressBarForRunnable.this.finished();
                    }
                });
            }
        };
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(this.parent);
        Thread dialogThread = new Thread(new Runnable(){

            @Override
            public void run() {
                ProgressBarForRunnable.this.dialog.setVisible(true);
            }
        });
        dialogThread.start();
        worker.start();
    }

    public void setText(final String text) {
        if (this.dialog.isVisible()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgressBarForRunnable.this.putText(text);
                }
            });
        } else {
            this.putText(text);
        }
    }

    private void putText(String text) {
        this.textLabel.setText(text);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(this.parent);
    }

    protected void finished() {
        this.dialog.dispose();
        if (this.resultReceiver != null) {
            this.resultReceiver.processResult(this.runnable);
        }
    }
}

