/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.guitools;

import de.uwemock.eur.gui.TextPool;
import de.uwemock.guitools.GuiTools;
import de.uwemock.guitools.StandardDialogPanel;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class PanelStackDialog
extends JDialog {
    public static final int OK_RESULT = 1;
    public static final int CANCEL_RESULT = 2;
    private Frame parent;
    private List<StandardDialogPanel> panels = new ArrayList<StandardDialogPanel>();
    private JButton okButton;
    private JButton cancelButton;
    private int result;

    public PanelStackDialog(Frame parent, String title) {
        super(parent, title);
        this.setModal(true);
        this.parent = parent;
        this.setLayout(new BorderLayout(0, 10));
        JPanel buttonPanel = new JPanel(new FlowLayout(1));
        this.okButton = new JButton(new AbstractAction(TextPool.getString("buttonOk")){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (StandardDialogPanel sdp : PanelStackDialog.this.panels) {
                    sdp.saveDialogData();
                }
                PanelStackDialog.this.result = 1;
                PanelStackDialog.this.dispose();
            }
        });
        this.cancelButton = new JButton(new AbstractAction(TextPool.getString("buttonCancel")){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelStackDialog.this.result = 2;
                PanelStackDialog.this.dispose();
            }
        });
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.cancelButton);
        this.add("South", buttonPanel);
        this.addCancelByEscapeKey();
        this.getRootPane().setDefaultButton(this.okButton);
    }

    public void addPanel(StandardDialogPanel panel) {
        this.panels.add(panel);
        panel.setOkAction(this.okButton.getAction());
    }

    @Override
    public void setVisible(boolean visibility) {
        GridBagLayout gbl = new GridBagLayout();
        JPanel panelStack = new JPanel(gbl);
        int y = 0;
        for (StandardDialogPanel sdp : this.panels) {
            GuiTools.addComponent(panelStack, gbl, sdp.getComponent(), 0, y++, 1, 1, 0.0, 0.0);
        }
        this.add("Center", panelStack);
        this.pack();
        this.setLocationRelativeTo(this.parent);
        super.setVisible(visibility);
    }

    public int getResult() {
        return this.result;
    }

    private void addCancelByEscapeKey() {
        String CANCEL_ACTION_KEY = "CANCEL_ACTION_KEY";
        int noModifiers = 0;
        KeyStroke escapeKey = KeyStroke.getKeyStroke(27, noModifiers, false);
        InputMap inputMap = this.getRootPane().getInputMap(1);
        inputMap.put(escapeKey, CANCEL_ACTION_KEY);
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PanelStackDialog.this.closeDialog();
            }
        };
        this.getRootPane().getActionMap().put(CANCEL_ACTION_KEY, cancelAction);
    }

    private void closeDialog() {
        this.dispose();
    }
}

