/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.guitools;

import de.uwemock.guitools.MutableListModel;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.MutableComboBoxModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MoveListItemAction
extends AbstractAction
implements ListSelectionListener {
    public static int MOVE_UP = -1;
    public static int MOVE_DOWN = 1;
    public static int MOVE_TO_TOP = Integer.MIN_VALUE;
    public static int MOVE_TO_END = Integer.MAX_VALUE;
    private JList list;
    private int direction;

    public MoveListItemAction(JList list, int direction, String title) {
        super(title);
        if (list == null) {
            throw new IllegalArgumentException();
        }
        ListModel model = list.getModel();
        if (!(model instanceof MutableListModel) && !(model instanceof MutableComboBoxModel)) {
            throw new IllegalArgumentException("JList must have a MutableListModel or MutableComboboxModel in order to be used with a MoveListItemAction");
        }
        this.list = list;
        this.direction = direction;
        list.addListSelectionListener(this);
        this.setEnabledState();
    }

    public MoveListItemAction(JList list, int direction, String title, String resourceIcon) {
        this(list, direction, title);
        this.putValue("SmallIcon", resourceIcon);
    }

    private int getNewIndex(int index) {
        int newIndex = index + this.direction;
        if (newIndex < 0) {
            return 0;
        }
        int size = this.list.getModel().getSize();
        if (newIndex >= size) {
            return size - 1;
        }
        return newIndex;
    }

    private void setEnabledState() {
        int index = this.list.getSelectedIndex();
        if (MOVE_TO_TOP == this.direction) {
            this.setEnabled(index > 0);
            return;
        }
        if (MOVE_TO_END == this.direction) {
            this.setEnabled(index >= 0 && index < this.list.getModel().getSize() - 1);
            return;
        }
        int newIndex = this.getNewIndex(index);
        this.setEnabled(index >= 0 && index != newIndex);
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        Object item;
        int index = this.list.getSelectedIndex();
        int newIndex = this.getNewIndex(index);
        ListModel model = this.list.getModel();
        if (model instanceof MutableComboBoxModel) {
            MutableComboBoxModel cbmodel = (MutableComboBoxModel)model;
            item = cbmodel.getElementAt(index);
            cbmodel.removeElementAt(index);
            cbmodel.insertElementAt(item, newIndex);
        }
        if (model instanceof MutableListModel) {
            MutableListModel lmodel = (MutableListModel)model;
            item = lmodel.getElementAt(index);
            lmodel.removeElementAt(index);
            lmodel.insertElementAt(item, newIndex);
        }
        this.list.setSelectedIndex(newIndex);
        this.setEnabledState();
    }

    @Override
    public void valueChanged(ListSelectionEvent arg0) {
        this.setEnabledState();
    }
}

