/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.guitools;

import de.uwemock.tools.LoggingManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class LookAndFeelMenu
extends JMenu {
    private JFrame parent;

    public LookAndFeelMenu(JFrame parent) {
        super("Look & Feel");
        this.parent = parent;
        UIManager.LookAndFeelInfo[] infos = UIManager.getInstalledLookAndFeels();
        int i = 0;
        while (i < infos.length) {
            final String className = infos[i].getClassName();
            String text = infos[i].getName();
            JMenuItem item = new JMenuItem(text);
            this.add(item);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LookAndFeelMenu.this.onChoice(className);
                }
            });
            ++i;
        }
    }

    private void onChoice(String className) {
        try {
            UIManager.setLookAndFeel(className);
            SwingUtilities.updateComponentTreeUI(this.parent.getRootPane());
        }
        catch (Exception e) {
            LoggingManager.logException(this.getClass(), e);
        }
    }
}

