/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.guitools;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class GuiTools {
    private static final Icon CLOSE_TAB_ICON = new ImageIcon(GuiTools.class.getResource("/de/uwemock/guitools/icons/fileclose.png"));
    private static final Icon CLOSE_TAB_ICON_DISABLED = new ImageIcon(GuiTools.class.getResource("/de/uwemock/guitools/icons/fileclose_disabled.png"));

    private GuiTools() {
    }

    public static void addComponent(Container cont, GridBagLayout gbl, Component c, int x, int y, int width, int height, double weightx, double weighty) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = width;
        gbc.gridheight = height;
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        gbc.insets = new Insets(2, 4, 2, 4);
        gbl.setConstraints(c, gbc);
        cont.add(c);
    }

    public static int getAvailableScreenWidth() {
        Rectangle maxBounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        return maxBounds.width;
    }

    public static int getAvailableScreenHeight() {
        Rectangle maxBounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        return maxBounds.height;
    }

    public static void centerWindow(Window window) {
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (d.width - window.getWidth()) / 2;
        int y = (d.height - window.getHeight()) / 2;
        window.setLocation(x, y);
    }

    public static String shortenPathname(String path, int numChars, int numDirs) {
        String fileSeparator = System.getProperty("file.separator");
        boolean shortened = false;
        StringBuilder result = new StringBuilder(path);
        if (numDirs >= 0) {
            int pos = result.length() - fileSeparator.length();
            int count = 0;
            while (pos > 0 && count < numDirs + 1) {
                if (result.substring(pos, pos + fileSeparator.length()).equals(fileSeparator)) {
                    ++count;
                }
                --pos;
            }
            if (pos > 0) {
                result.delete(0, pos + 1);
                shortened = true;
            }
        }
        if (result.length() + (shortened ? 3 : 0) > numChars) {
            while (result.length() + 3 > numChars && result.indexOf(fileSeparator, 1) > 0) {
                result.delete(0, 1);
            }
            result.delete(0, result.indexOf(fileSeparator));
            shortened = true;
        }
        if (shortened) {
            result.insert(0, "...");
        }
        return result.toString();
    }

    public static JButton getBrowseButton(Component parent, JTextField targetField, FileFilter filter, File directory) {
        JButton button = new JButton("Browse...");
        final Component parentComponent = parent;
        final JTextField textField = targetField;
        final JFileChooser chooser = new JFileChooser();
        if (filter != null) {
            chooser.setFileFilter(filter);
        }
        if (directory != null) {
            chooser.setCurrentDirectory(directory);
        }
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int res;
                String fieldContents = textField.getText();
                if (!fieldContents.isEmpty()) {
                    File file = new File(fieldContents);
                    if (file.isDirectory()) {
                        chooser.setCurrentDirectory(file);
                    } else if ((file = file.getParentFile()) != null && file.isDirectory()) {
                        chooser.setCurrentDirectory(file);
                    }
                }
                if ((res = chooser.showOpenDialog(parentComponent)) == 0) {
                    try {
                        textField.setText(chooser.getSelectedFile().getCanonicalPath());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
        return button;
    }

    public static JButton getBrowseButton(Component parent, JTextField targetField, FileFilter filter, File directory, String buttonText) {
        JButton button = GuiTools.getBrowseButton(parent, targetField, filter, directory);
        if (buttonText != null) {
            button.setText(buttonText);
        }
        return button;
    }

    public static void adjustFrameToScreenSize(Frame frame) {
        int screenWidth = Toolkit.getDefaultToolkit().getScreenSize().width;
        int screenHeight = Toolkit.getDefaultToolkit().getScreenSize().height;
        int framePosX = Math.max(0, frame.getX());
        int framePosY = Math.max(0, frame.getY());
        int frameWidth = frame.getWidth();
        int frameHeight = frame.getHeight();
        if (frameWidth > screenWidth) {
            frameWidth = screenWidth;
        }
        if (framePosX + frameWidth > screenWidth) {
            framePosX = screenWidth - frameWidth;
        }
        if (framePosX < 0) {
            framePosX = 0;
        }
        if (frameHeight > screenHeight) {
            frameHeight = screenHeight;
        }
        if (framePosY + frameHeight > screenHeight) {
            framePosY = screenHeight - frameHeight;
        }
        if (framePosY < 0) {
            framePosY = 0;
        }
        frame.setLocation(framePosX, framePosY);
        frame.setSize(frameWidth, frameHeight);
    }

    public static void setJTablePreferredWidth(JTable table) {
        int rowMargin;
        TableCellRenderer headerRenderer = table.getTableHeader().getDefaultRenderer();
        int columnCount = table.getColumnCount();
        int rowCount = table.getRowCount();
        int maxWidth = rowMargin = table.getRowMargin();
        TableColumnModel columnModel = table.getColumnModel();
        int viewCol = 0;
        while (viewCol < columnCount) {
            TableColumn tableColumn = columnModel.getColumn(viewCol);
            maxWidth += headerRenderer.getTableCellRendererComponent((JTable)table, (Object)tableColumn.getHeaderValue(), (boolean)false, (boolean)false, (int)0, (int)viewCol).getPreferredSize().width;
            maxWidth += 30;
            maxWidth += rowMargin;
            ++viewCol;
        }
        int viewRow = 0;
        while (viewRow < rowCount) {
            int rowWidth = rowMargin;
            int viewCol2 = 0;
            while (viewCol2 < columnCount) {
                Component comp = table.getCellRenderer(viewRow, viewCol2).getTableCellRendererComponent(table, table.getValueAt(viewRow, viewCol2), false, false, viewRow, viewCol2);
                rowWidth += comp.getPreferredSize().width;
                rowWidth += 10;
                rowWidth += rowMargin;
                ++viewCol2;
            }
            if (rowWidth > maxWidth) {
                maxWidth = rowWidth;
            }
            ++viewRow;
        }
        table.setPreferredSize(new Dimension(maxWidth, table.getPreferredSize().height));
    }

    public static void setAllComponentsEnabled(Container container, boolean enabled) {
        if (container == null) {
            return;
        }
        int count = container.getComponentCount();
        int i = 0;
        while (i < count) {
            Component c = container.getComponent(i);
            c.setEnabled(enabled);
            if (c instanceof Container) {
                GuiTools.setAllComponentsEnabled((Container)c, enabled);
            }
            ++i;
        }
    }

    public static String getAbsoluteProgramPath() {
        String runFileName = System.getProperty("java.class.path");
        File runFile = new File(runFileName);
        return runFile.getAbsolutePath();
    }

    public static boolean makeWindowsFileAssociation(String extension, String fileTypeName) {
        String startupCommand = GuiTools.getAbsoluteProgramPath();
        if (startupCommand.endsWith(".jar")) {
            startupCommand = "javaw.exe -jar \"" + startupCommand + "\"";
        }
        return GuiTools.makeWindowsFileAssociation(extension, fileTypeName, String.valueOf(startupCommand) + " \"%1\"");
    }

    public static boolean makeWindowsFileAssociation(String extension, String fileTypeName, String command) {
        String osname = System.getProperty("os.name").toLowerCase();
        if (osname.indexOf("window") >= 0) {
            try {
                Runtime.getRuntime().exec("cmd.exe /c assoc " + extension + "=" + fileTypeName);
                Runtime.getRuntime().exec("cmd.exe /c ftype " + fileTypeName + "=" + command);
            }
            catch (IOException e) {
                return false;
            }
        }
        return true;
    }

    public static void addClosableTab(final JTabbedPane tabbedPane, final JComponent c, String title, Icon icon) {
        tabbedPane.addTab(null, c);
        int pos = tabbedPane.indexOfComponent(c);
        FlowLayout f = new FlowLayout(1, 0, 0);
        JPanel pnlTab = new JPanel(f);
        pnlTab.setOpaque(false);
        JLabel lblTitle = new JLabel(title);
        lblTitle.setIcon(icon);
        JButton btnClose = new JButton();
        btnClose.setOpaque(false);
        btnClose.setRolloverIcon(CLOSE_TAB_ICON);
        btnClose.setRolloverEnabled(true);
        btnClose.setIcon(CLOSE_TAB_ICON_DISABLED);
        btnClose.setIcon(CLOSE_TAB_ICON);
        btnClose.setBorder(BorderFactory.createEmptyBorder());
        btnClose.setFocusable(false);
        pnlTab.add(lblTitle);
        pnlTab.add(Box.createHorizontalStrut(10));
        pnlTab.add(btnClose);
        pnlTab.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0));
        tabbedPane.setTabComponentAt(pos, pnlTab);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                tabbedPane.remove(c);
            }
        };
        btnClose.addActionListener(listener);
        tabbedPane.setSelectedComponent(c);
        AbstractAction closeTabAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                tabbedPane.remove(c);
            }
        };
        KeyStroke controlW = KeyStroke.getKeyStroke("control W");
        InputMap inputMap = c.getInputMap(1);
        inputMap.put(controlW, "closeTab");
        c.getActionMap().put("closeTab", closeTabAction);
    }
}

