/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.guitools;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.filechooser.FileSystemView;

public class FileTypeIconProvider {
    private static FileSystemView fileSystemView = FileSystemView.getFileSystemView();
    private static HashMap<String, Icon> iconMap = new HashMap();
    private static Icon standardFileIcon = new ImageIcon(FileTypeIconProvider.class.getResource("/de/uwemock/guitools/icons/ascii.png"));

    static {
        ImageIcon icon = new ImageIcon(FileTypeIconProvider.class.getResource("/de/uwemock/guitools/icons/html.png"));
        iconMap.put("html", icon);
        iconMap.put("htm", icon);
        icon = new ImageIcon(FileTypeIconProvider.class.getResource("/de/uwemock/guitools/icons/image.png"));
        iconMap.put("bmp", icon);
        iconMap.put("gif", icon);
        iconMap.put("jpg", icon);
        iconMap.put("png", icon);
        icon = new ImageIcon(FileTypeIconProvider.class.getResource("/de/uwemock/guitools/icons/pdf.png"));
        iconMap.put("pdf", icon);
        icon = new ImageIcon(FileTypeIconProvider.class.getResource("/de/uwemock/guitools/icons/ps.png"));
        iconMap.put("ps", icon);
        icon = new ImageIcon(FileTypeIconProvider.class.getResource("/de/uwemock/guitools/icons/spreadsheet.png"));
        iconMap.put("csv", icon);
        iconMap.put("xsl", icon);
        iconMap.put("xslx", icon);
        iconMap.put("ods", icon);
        icon = new ImageIcon(FileTypeIconProvider.class.getResource("/de/uwemock/guitools/icons/txt.png"));
        iconMap.put("txt", icon);
        iconMap.put("asc", icon);
        icon = new ImageIcon(FileTypeIconProvider.class.getResource("/de/uwemock/guitools/icons/video.png"));
        iconMap.put("avi", icon);
        iconMap.put("mov", icon);
        iconMap.put("mp4", icon);
        iconMap.put("webm", icon);
        icon = new ImageIcon(FileTypeIconProvider.class.getResource("/de/uwemock/guitools/icons/zip.png"));
        iconMap.put("zip", icon);
    }

    private FileTypeIconProvider() {
    }

    public static Icon getIconForFileType(String filename) {
        if (filename == null) {
            return null;
        }
        int pos = filename.lastIndexOf(".");
        String extension = filename.substring(pos + 1);
        Icon icon = iconMap.get(extension);
        if (icon == null) {
            File file;
            try {
                file = File.createTempFile("icon", extension);
            }
            catch (IOException e) {
                return standardFileIcon;
            }
            if (file != null) {
                icon = fileSystemView.getSystemIcon(file);
                file.delete();
                iconMap.put(extension, icon);
            }
        }
        return icon;
    }
}

