/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.guitools;

import de.uwemock.guitools.ToolbarDockingStateListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public class EnhancedJToolBar
extends JToolBar {
    private static final String[] POSITIONS = new String[]{"North", "South", "West", "East"};
    private static final String LARGE_ICON_KEY_STORED = "SwingLargeIconKeyStored";
    public static final int ICON_SIZE_SMALL = 1;
    public static final int ICON_SIZE_LARGE = 2;
    private boolean isDocked = false;
    private int iconSize = 2;
    private Object lastAncestor;
    private DisableUndockingListener disableUndockingListener;
    private ArrayList<ToolbarDockingStateListener> dockingStateListeners = new ArrayList();

    public EnhancedJToolBar() {
        this.connectListeners();
    }

    public EnhancedJToolBar(int arg0) {
        super(arg0);
        this.connectListeners();
    }

    public EnhancedJToolBar(String arg0, int arg1) {
        super(arg0, arg1);
        this.connectListeners();
    }

    public EnhancedJToolBar(String arg0) {
        super(arg0);
        this.connectListeners();
    }

    private void connectListeners() {
        this.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("ancestor")) {
                    if (evt.getNewValue() == null) {
                        EnhancedJToolBar.this.lastAncestor = evt.getOldValue();
                    }
                    if (evt.getOldValue() == null && evt.getNewValue() != EnhancedJToolBar.this.lastAncestor) {
                        EnhancedJToolBar.this.isDocked = !EnhancedJToolBar.this.isDocked;
                        if (EnhancedJToolBar.this.isDocked) {
                            EnhancedJToolBar.this.notifyDockingListeners();
                        } else {
                            EnhancedJToolBar.this.notifyUndockingListeners();
                        }
                    }
                }
            }
        });
    }

    private void notifyDockingListeners() {
        for (ToolbarDockingStateListener l : this.dockingStateListeners) {
            l.toolbarDocked();
        }
    }

    private void notifyUndockingListeners() {
        for (ToolbarDockingStateListener l : this.dockingStateListeners) {
            l.toolbarUndocked();
        }
    }

    public void addDockingStateListener(ToolbarDockingStateListener l) {
        this.dockingStateListeners.add(l);
    }

    public void removeDockingStateListener(ToolbarDockingStateListener l) {
        this.dockingStateListeners.remove(l);
    }

    @Override
    public JButton add(Action action) {
        Object largeIcon;
        if (this.iconSize == 1 && (largeIcon = action.getValue("SwingLargeIconKey")) != null) {
            action.putValue("SwingLargeIconKey", null);
            action.putValue(LARGE_ICON_KEY_STORED, largeIcon);
        }
        return super.add(action);
    }

    public Object getToolbarPosition() {
        Container topComponent;
        LayoutManager parentLayout = this.getParent().getLayout();
        if (parentLayout instanceof BorderLayout) {
            BorderLayout layout = (BorderLayout)parentLayout;
            String[] stringArray = POSITIONS;
            int n = POSITIONS.length;
            int n2 = 0;
            while (n2 < n) {
                String position = stringArray[n2];
                if (layout.getLayoutComponent(position) == this) {
                    return position;
                }
                ++n2;
            }
        }
        if ((topComponent = this.getRootPane().getParent()) instanceof JDialog) {
            JDialog tbd = (JDialog)topComponent;
            return new Point(tbd.getX(), tbd.getY());
        }
        return null;
    }

    public void setToolbarPosition(Object pos, Container container) {
        Container topComponent;
        if (container != null) {
            String[] stringArray = POSITIONS;
            int n = POSITIONS.length;
            int n2 = 0;
            while (n2 < n) {
                String position = stringArray[n2];
                if (position.equals(pos)) {
                    container.remove(this);
                    if (pos.equals("West") || pos.equals("East")) {
                        this.setOrientation(1);
                    }
                    if (pos.equals("North") || pos.equals("South")) {
                        this.setOrientation(0);
                    }
                    container.add((Component)this, pos);
                    return;
                }
                ++n2;
            }
        }
        if (pos instanceof Point && (topComponent = this.getRootPane().getParent()) instanceof JDialog) {
            JDialog tbd = (JDialog)topComponent;
            tbd.setLocation((Point)pos);
            return;
        }
    }

    public void setUndockingEnabled(boolean enableUndocking) {
        if (enableUndocking && this.disableUndockingListener != null) {
            this.removeDockingStateListener(this.disableUndockingListener);
            this.disableUndockingListener = null;
        }
        if (!enableUndocking && this.disableUndockingListener == null) {
            this.disableUndockingListener = new DisableUndockingListener();
            this.addDockingStateListener(this.disableUndockingListener);
        }
    }

    public void setIconSize(int size) {
        Component[] contents;
        Component[] componentArray = contents = this.getComponents();
        int n = contents.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c instanceof JButton) {
                Object largeIcon;
                JButton b = (JButton)c;
                Action a = b.getAction();
                if (size == 1) {
                    largeIcon = a.getValue("SwingLargeIconKey");
                    if (largeIcon != null) {
                        a.putValue("SwingLargeIconKey", null);
                        a.putValue(LARGE_ICON_KEY_STORED, largeIcon);
                    }
                    this.iconSize = size;
                }
                if (size == 2) {
                    largeIcon = a.getValue(LARGE_ICON_KEY_STORED);
                    if (largeIcon != null) {
                        a.putValue("SwingLargeIconKey", largeIcon);
                        a.putValue(LARGE_ICON_KEY_STORED, null);
                    }
                    this.iconSize = size;
                }
            }
            ++n2;
        }
    }

    public int getIconSize() {
        return this.iconSize;
    }

    private class DisableUndockingListener
    implements ToolbarDockingStateListener {
        private DisableUndockingListener() {
        }

        @Override
        public void toolbarUndocked() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((JDialog)EnhancedJToolBar.this.getRootPane().getParent()).dispose();
                    SwingUtilities.updateComponentTreeUI(EnhancedJToolBar.this.getRootPane());
                }
            });
        }

        @Override
        public void toolbarDocked() {
        }
    }
}

