/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.guitools;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;

public class ComponentEnabler {
    private boolean enabledStateIfChecked;
    private JCheckBox checkBox;
    private JCheckBoxMenuItem checkBoxMenuItem;
    private ArrayList<Component> components = new ArrayList();
    private ArrayList<Action> actions = new ArrayList();

    public ComponentEnabler(JCheckBox checkBox) {
        this(checkBox, true);
    }

    public ComponentEnabler(JCheckBox checkBox, boolean enabledStateIfChecked) {
        this.checkBox = checkBox;
        this.enabledStateIfChecked = enabledStateIfChecked;
        checkBox.addActionListener(new EnablerListener());
    }

    public ComponentEnabler(JCheckBoxMenuItem checkboxMenuItem) {
        this(checkboxMenuItem, true);
    }

    public ComponentEnabler(JCheckBoxMenuItem checkboxMenuItem, boolean enabledStateIfChecked) {
        this.checkBoxMenuItem = checkboxMenuItem;
        this.enabledStateIfChecked = enabledStateIfChecked;
        checkboxMenuItem.addActionListener(new EnablerListener());
    }

    public void addComponent(Component c) {
        this.components.add(c);
    }

    public void removeComponent(Component c) {
        this.components.remove(c);
    }

    public void addAction(Action a) {
        this.actions.add(a);
    }

    public void removeAction(Action a) {
        this.actions.remove(a);
    }

    public void setComponentsEnabled(boolean checked) {
        boolean enable = checked ? this.enabledStateIfChecked : !this.enabledStateIfChecked;
        for (Component c : this.components) {
            c.setEnabled(enable);
        }
        for (Action a : this.actions) {
            a.setEnabled(enable);
        }
    }

    class EnablerListener
    implements ActionListener {
        EnablerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            boolean newState;
            if (ComponentEnabler.this.checkBox != null) {
                newState = ComponentEnabler.this.checkBox.isSelected();
                ComponentEnabler.this.setComponentsEnabled(newState);
            }
            if (ComponentEnabler.this.checkBoxMenuItem != null) {
                newState = ComponentEnabler.this.checkBoxMenuItem.isSelected();
                ComponentEnabler.this.setComponentsEnabled(newState);
            }
        }
    }
}

