/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.guitools;

import de.uwemock.guitools.AutocompleteComboBox;
import javax.swing.ComboBoxModel;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class AutocompleteTextField
extends JTextField {
    private static final long serialVersionUID = -4990261371518775963L;
    private ComboBoxModel dataList;
    private boolean isCaseSensitive = false;
    private boolean isStrict = true;
    private AutocompleteComboBox autoComboBox;

    public AutocompleteTextField(ComboBoxModel list) {
        if (list == null) {
            throw new IllegalArgumentException("values can not be null");
        }
        this.dataList = list;
        this.init();
    }

    public AutocompleteTextField(ComboBoxModel list, boolean caseSensitive, boolean strict) {
        this(list);
        this.setCaseSensitive(caseSensitive);
        this.setStrict(strict);
    }

    AutocompleteTextField(ComboBoxModel list, AutocompleteComboBox b) {
        this.autoComboBox = null;
        if (list == null) {
            throw new IllegalArgumentException("values can not be null");
        }
        this.dataList = list;
        this.autoComboBox = b;
        this.init();
    }

    private void init() {
        int i = 0;
        while (i < this.dataList.getSize()) {
            int cols_high;
            String s = this.dataList.getElementAt(i).toString();
            int cols = s.length();
            if (cols > (cols_high = 0)) {
                super.setColumns(cols + 1);
                cols_high = cols;
            }
            ++i;
        }
        this.setDocument(new AutoDocument());
        if (this.isStrict && this.dataList.getSize() > 0) {
            this.setText(this.dataList.getElementAt(0).toString());
        }
    }

    private String getMatch(String s) {
        if (!this.hasFocus()) {
            return null;
        }
        if (s.length() > 0) {
            int i = 0;
            while (i < this.dataList.getSize()) {
                String s1 = this.dataList.getElementAt(i).toString();
                if (s1 != null) {
                    if (!this.isCaseSensitive && s1.toLowerCase().startsWith(s.toLowerCase())) {
                        return s1;
                    }
                    if (this.isCaseSensitive && s1.startsWith(s)) {
                        return s1;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public void replaceSelection(String s) {
        AutoDocument _lb = (AutoDocument)this.getDocument();
        if (_lb != null) {
            try {
                int i = Math.min(this.getCaret().getDot(), this.getCaret().getMark());
                int j = Math.max(this.getCaret().getDot(), this.getCaret().getMark());
                _lb.replace(i, j - i, s, null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public void setCaseSensitive(boolean flag) {
        this.isCaseSensitive = flag;
    }

    public boolean isStrict() {
        return this.isStrict;
    }

    public void setStrict(boolean flag) {
        this.isStrict = flag;
    }

    public ComboBoxModel getDataList() {
        return this.dataList;
    }

    public void setDataList(ComboBoxModel list) {
        if (list == null) {
            throw new IllegalArgumentException("values can not be null");
        }
        this.dataList = list;
    }

    class AutoDocument
    extends PlainDocument {
        private static final long serialVersionUID = 6876136948661724800L;

        AutoDocument() {
        }

        @Override
        public void replace(int i, int j, String s, AttributeSet attributeset) throws BadLocationException {
            super.remove(i, j);
            this.insertString(i, s, attributeset);
        }

        @Override
        public void insertString(int i, String s, AttributeSet attributeset) throws BadLocationException {
            if (s == null || "".equals(s)) {
                return;
            }
            String s1 = this.getText(0, this.getLength());
            String s2 = AutocompleteTextField.this.getMatch(String.valueOf(s1) + s);
            if (!AutocompleteTextField.this.isStrict && s2 != null) {
                StringBuilder s2buffer = new StringBuilder(s2);
                if (this.getLength() > 0) {
                    s2buffer.replace(0, this.getLength(), s1);
                }
                s2buffer.replace(i, i + s.length(), s);
                s2 = s2buffer.toString();
            }
            int j = i + s.length() - 1;
            if (AutocompleteTextField.this.isStrict && s2 == null) {
                s2 = AutocompleteTextField.this.getMatch(s1);
                --j;
            } else if (!AutocompleteTextField.this.isStrict && s2 == null) {
                super.insertString(i, s, attributeset);
                return;
            }
            super.remove(0, this.getLength());
            super.insertString(0, s2, attributeset);
            AutocompleteTextField.this.setSelectionStart(j + 1);
            AutocompleteTextField.this.setSelectionEnd(this.getLength());
        }

        @Override
        public void remove(int i, int j) throws BadLocationException {
            super.remove(i, j);
        }
    }
}

