/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.guitools;

import de.uwemock.eur.gui.ThinkingComboBoxModel;
import de.uwemock.guitools.AutocompleteTextField;
import java.awt.event.ItemEvent;
import java.util.EventListener;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.MutableComboBoxModel;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;

public class AutocompleteComboBox
extends JComboBox {
    private static final long serialVersionUID = -1278860335367309975L;
    private AutoTextFieldEditor autoTextFieldEditor;
    private boolean isFired = false;

    public AutocompleteComboBox(MutableComboBoxModel list) {
        this.autoTextFieldEditor = new AutoTextFieldEditor(list);
        this.setEditable(true);
        this.setModel(list);
        this.setEditor(this.autoTextFieldEditor);
    }

    public AutocompleteComboBox(MutableComboBoxModel list, boolean caseSensitiv, boolean strict) {
        this(list);
        this.setCaseSensitive(caseSensitiv);
        this.setStrict(strict);
    }

    public boolean isCaseSensitive() {
        return this.autoTextFieldEditor.getAutoTextFieldEditor().isCaseSensitive();
    }

    public void setCaseSensitive(boolean flag) {
        this.autoTextFieldEditor.getAutoTextFieldEditor().setCaseSensitive(flag);
    }

    public boolean isStrict() {
        return this.autoTextFieldEditor.getAutoTextFieldEditor().isStrict();
    }

    public void setStrict(boolean flag) {
        this.autoTextFieldEditor.getAutoTextFieldEditor().setStrict(flag);
    }

    public ComboBoxModel getDataList() {
        return this.autoTextFieldEditor.getAutoTextFieldEditor().getDataList();
    }

    public void setModel(ThinkingComboBoxModel model) {
        ThinkingComboBoxModelAdapter newModel = new ThinkingComboBoxModelAdapter(model);
        if (this.autoTextFieldEditor != null) {
            this.autoTextFieldEditor.getAutoTextFieldEditor().setDataList(newModel);
        }
        super.setModel(newModel);
    }

    void setSelectedValue(Object obj) {
        if (this.isFired) {
            return;
        }
        this.isFired = true;
        this.setSelectedItem(obj);
        this.fireItemStateChanged(new ItemEvent(this, 701, this.selectedItemReminder, 1));
        this.isFired = false;
    }

    @Override
    protected void fireActionEvent() {
        if (!this.isFired) {
            super.fireActionEvent();
        }
    }

    private class AutoTextFieldEditor
    extends BasicComboBoxEditor {
        private AutocompleteTextField getAutoTextFieldEditor() {
            return (AutocompleteTextField)this.editor;
        }

        AutoTextFieldEditor(ComboBoxModel list) {
            this.editor = new AutocompleteTextField(list, AutocompleteComboBox.this);
        }
    }

    private class ThinkingComboBoxModelAdapter
    extends ThinkingComboBoxModel {
        private ThinkingComboBoxModel model;

        public ThinkingComboBoxModelAdapter(ThinkingComboBoxModel model) {
            this.model = model;
        }

        @Override
        public void addElement(Object newElement) {
            this.model.addElement(newElement);
        }

        @Override
        public void addListDataListener(ListDataListener l) {
            this.model.addListDataListener(l);
        }

        @Override
        public void addToList(Object newItem) {
            this.model.addToList(newItem);
        }

        @Override
        public void addToList(Object newItem, boolean fixed) {
            this.model.addToList(newItem, fixed);
        }

        public boolean equals(Object obj) {
            return this.model.equals(obj);
        }

        @Override
        public Object getElementAt(int index) {
            return this.model.getElementAt(index);
        }

        @Override
        public int getIndexOf(Object anObject) {
            return this.model.getIndexOf(anObject);
        }

        @Override
        public ListDataListener[] getListDataListeners() {
            return this.model.getListDataListeners();
        }

        @Override
        public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
            return this.model.getListeners(listenerType);
        }

        @Override
        public Object getSelectedItem() {
            return this.model.getSelectedItem();
        }

        @Override
        public int getSize() {
            return this.model.getSize();
        }

        public int hashCode() {
            return this.model.hashCode();
        }

        @Override
        public void insertElementAt(Object newElement, int index) {
            this.model.insertElementAt(newElement, index);
        }

        @Override
        public boolean isItemFixed(int index) {
            return this.model.isItemFixed(index);
        }

        @Override
        public void removeAllElements() {
            this.model.removeAllElements();
        }

        @Override
        public void removeElement(Object anObject) {
            this.model.removeElement(anObject);
        }

        @Override
        public void removeElementAt(int index) {
            this.model.removeElementAt(index);
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
            this.model.removeListDataListener(l);
        }

        @Override
        public void setItemContents(int index, Object contents) {
            this.model.setItemContents(index, contents);
        }

        @Override
        public void setItemFixed(int index, boolean fixed) {
            this.model.setItemFixed(index, fixed);
        }

        @Override
        public void setMaxItems(int maxItems) {
            this.model.setMaxItems(maxItems);
        }

        @Override
        public void setSelectedItem(Object anObject) {
            this.model.setSelectedItem(anObject);
        }

        public String toString() {
            return this.model.toString();
        }

        @Override
        protected void fireContentsChanged(Object obj, int i, int j) {
            if (!AutocompleteComboBox.this.isFired) {
                super.fireContentsChanged(obj, i, j);
            }
        }
    }
}

