/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.guitools;

import de.uwemock.guitools.GuiTools;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import javax.accessibility.Accessible;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class AutoLengthPopupComboBox
implements PopupMenuListener {
    private JComboBox comboBox;
    private JList listForRenderer = new JList();

    private AutoLengthPopupComboBox(JComboBox comboBox) {
        this.comboBox = comboBox;
        this.comboBox.addPopupMenuListener(this);
    }

    public static void extendComboBoxPopup(JComboBox comboBox) {
        new AutoLengthPopupComboBox(comboBox);
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        Component listCellComponent = this.comboBox.getRenderer().getListCellRendererComponent(this.listForRenderer, this.comboBox.getModel().getElementAt(0), 0, false, false);
        int maxListHeight = listCellComponent.getPreferredSize().height * this.comboBox.getItemCount();
        Accessible popup = this.comboBox.getUI().getAccessibleChild(this.comboBox, 0);
        Component c = ((Container)((Object)popup)).getComponent(0);
        if (c instanceof JScrollPane) {
            int maxScrollpaneHeight;
            int maxListItems;
            JScrollPane scrollPane = (JScrollPane)c;
            Point componentLocation = this.comboBox.getLocationOnScreen();
            int screenHeight = GuiTools.getAvailableScreenHeight();
            int itemHeight = listCellComponent.getPreferredSize().height;
            int availableHeight = screenHeight - componentLocation.y - this.comboBox.getHeight();
            if (maxListHeight < availableHeight) {
                maxListItems = maxListHeight / itemHeight;
                maxScrollpaneHeight = maxListItems * itemHeight;
            } else {
                maxListItems = availableHeight / itemHeight;
                maxScrollpaneHeight = maxListItems * itemHeight;
            }
            if (maxListItems >= 5) {
                this.comboBox.setMaximumRowCount(maxListItems);
                Dimension size = new Dimension(scrollPane.getPreferredSize().width, maxScrollpaneHeight);
                scrollPane.setPreferredSize(size);
                scrollPane.setMaximumSize(size);
                scrollPane.getViewport().setViewSize(size);
                scrollPane.revalidate();
            }
        }
    }
}

