/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.guitools;

import de.uwemock.guitools.GuiTools;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import javax.accessibility.Accessible;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class AutoLengthListBox
implements ListDataListener {
    private JList listBox;
    private JList listForRenderer = new JList();

    private AutoLengthListBox(JList listBox) {
        this.listBox = listBox;
        this.listBox.getModel().addListDataListener(this);
        this.setListLength();
    }

    public static void extendListBoxPopup(JList listBox) {
        new AutoLengthListBox(listBox);
    }

    private void setListLength() {
        Component listComponent = this.listBox.getCellRenderer().getListCellRendererComponent(this.listForRenderer, this.listBox.getModel().getElementAt(0), 0, false, false);
        int maxListHeight = listComponent.getPreferredSize().height * this.listBox.getModel().getSize();
        Accessible popup = this.listBox.getUI().getAccessibleChild(this.listBox, 0);
        Component c = ((Container)((Object)popup)).getComponent(0);
        if (c instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)c;
            Point componentLocation = new Point(this.listBox.getLocation());
            SwingUtilities.convertPointToScreen(componentLocation, this.listBox);
            int screenHeight = GuiTools.getAvailableScreenHeight();
            int maxScrollpaneHeight = Math.min(screenHeight - componentLocation.y, maxListHeight);
            Dimension size = new Dimension(scrollPane.getPreferredSize().width, maxScrollpaneHeight);
            scrollPane.setPreferredSize(size);
            scrollPane.setMaximumSize(size);
            scrollPane.getViewport().setViewSize(size);
            scrollPane.revalidate();
        }
    }

    @Override
    public void contentsChanged(ListDataEvent arg0) {
    }

    @Override
    public void intervalAdded(ListDataEvent arg0) {
        this.setListLength();
    }

    @Override
    public void intervalRemoved(ListDataEvent arg0) {
        this.setListLength();
    }
}

