/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.guitools;

import de.uwemock.guitools.GuiTools;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;

public abstract class AddRemovePanel<T extends Component>
extends JPanel {
    private static final ImageIcon addIcon = new ImageIcon(AddRemovePanel.class.getResource("/de/uwemock/guitools/icons/edit_add.png"));
    private static final ImageIcon removeIcon = new ImageIcon(AddRemovePanel.class.getResource("/de/uwemock/guitools/icons/edit_remove.png"));
    private JPanel addPanel;
    private GridBagLayout layout;
    private List<PanelElement> components = new LinkedList<PanelElement>();

    public AddRemovePanel() {
        this(true);
    }

    public AddRemovePanel(boolean empty) {
        this.createComponentTree();
        if (!empty) {
            this.addPanel();
        }
    }

    private void createComponentTree() {
        this.addPanel = new JPanel(new BorderLayout(10, 0));
        this.addPanel.add("Center", Box.createHorizontalGlue());
        JButton button = new JButton(addIcon);
        this.addPanel.add("East", button);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddRemovePanel.this.addPanel();
            }
        });
        this.layout = new GridBagLayout();
        this.setLayout(this.layout);
        GuiTools.addComponent(this, this.layout, this.addPanel, 0, 0, 1, 1, 1.0, 0.0);
    }

    public void addPanel() {
        T c = this.getNextComponent();
        PanelElement element = new PanelElement(this, c);
        this.remove(this.addPanel);
        GuiTools.addComponent(this, this.layout, element, 0, this.components.size(), 1, 1, 1.0, 0.0);
        this.components.add(element);
        GuiTools.addComponent(this, this.layout, this.addPanel, 0, this.components.size(), 1, 1, 1.0, 0.0);
        this.revalidate();
        this.repaint();
    }

    public void removePanel(PanelElement element) {
        this.remove(element);
        this.components.remove(element);
        this.revalidate();
        this.repaint();
    }

    public List<T> getListComponents() {
        LinkedList result = new LinkedList();
        for (PanelElement e : this.components) {
            result.add(e.getComponent());
        }
        return result;
    }

    protected abstract T getNextComponent();

    static class PanelElement
    extends JPanel
    implements ActionListener {
        private T component;
        final /* synthetic */ AddRemovePanel this$0;

        public PanelElement(T c) {
            this.this$0 = var1_1;
            this.component = c;
            this.createComponentTree();
        }

        private void createComponentTree() {
            this.setLayout(new BorderLayout(10, 0));
            this.add("Center", (Component)this.component);
            JButton button = new JButton(removeIcon);
            this.add("East", button);
            button.addActionListener(this);
        }

        public T getComponent() {
            return this.component;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.this$0.removePanel(this);
        }
    }
}

