/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.receipt.gui;

import com.toedter.calendar.JDateChooser;
import de.uwemock.datetools.Date;
import de.uwemock.eur.accounts.Account;
import de.uwemock.eur.accounts.AccountList;
import de.uwemock.eur.accounts.gui.AccountComboBox;
import de.uwemock.eur.data.Constants;
import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.data.LocalizationManager;
import de.uwemock.eur.data.SettingsManager;
import de.uwemock.eur.data.Tax;
import de.uwemock.eur.data.gui.TaxComboBox;
import de.uwemock.eur.gui.MoneyCellRenderer;
import de.uwemock.eur.gui.PercentCellRenderer;
import de.uwemock.eur.gui.ReceiptDataException;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.gui.ThinkingComboBoxModel;
import de.uwemock.eur.gui.ThinkingComboBoxModelRenderer;
import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.eur.receipt.Payment;
import de.uwemock.eur.receipt.PaymentFactory;
import de.uwemock.eur.receipt.PaymentTemplate;
import de.uwemock.eur.receipt.Receipt;
import de.uwemock.eur.receipt.ReceiptFactory;
import de.uwemock.eur.receipt.ReceiptNumberManager;
import de.uwemock.eur.receipt.SplitReceipt;
import de.uwemock.eur.receipt.gui.AbstractReceiptInput;
import de.uwemock.eur.receipt.gui.PaymentTableModel;
import de.uwemock.eur.receipt.gui.ReceiptInfoPanel;
import de.uwemock.guitools.AutoLengthPopupComboBox;
import de.uwemock.guitools.AutocompleteComboBox;
import de.uwemock.guitools.GuiTools;
import de.uwemock.guitools.MultiListComboBoxModel;
import de.uwemock.guitools.validators.FloatValidator;
import de.uwemock.guitools.validators.ValidatorHook;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;

public class SplitReceiptInput
extends AbstractReceiptInput {
    private JLabel dateLabel = new JLabel(TextPool.getString("labelDate"));
    private JDateChooser dateInput = new JDateChooser();
    private JLabel idLabel = new JLabel(TextPool.getString("labelReceiptId"));
    private JTextField idInput = new JTextField(10);
    private JLabel accountLabel = new JLabel(TextPool.getString("labelAccount"));
    private AccountComboBox accountInput;
    private JLabel paymentDescriptionLabel = new JLabel(TextPool.getString("labelDescription"));
    private JComboBox paymentDescriptionInput = new JComboBox();
    private JLabel descriptionLabel = new JLabel(TextPool.getString("labelDescription"));
    private AutocompleteComboBox descriptionInput;
    private JLabel amountLabel = new JLabel(TextPool.getString("labelAmount"));
    private JTextField amountInput = new JTextField(10);
    private JLabel taxLabel = new JLabel(TextPool.getString("labelTax"));
    private TaxComboBox taxInput;
    private JComboBox incudingExcludingTaxInput = new JComboBox<String>(TextPool.getArray("INCLUDING_EXCLUDING_TAX"));
    private JTextField infoReceiptNoOutput = new JTextField(10);
    private JTextField infoIncludingTaxOutput = new JTextField(10);
    private JTextField infoExcludingTaxOutput = new JTextField(10);
    private JTextField infoTaxAmountOutput = new JTextField(10);
    private JCheckBox unpaidInput = new JCheckBox(TextPool.getString("labelUnpaid"));
    private AccountList accountList = DataCenter.getInstance().getAccountList().getFilteredList();
    private JButton addPaymentButton;
    private List<Payment> payments = new ArrayList<Payment>();
    private JTable paymentsTable;
    private BigDecimal amountIncludingTax;
    private BigDecimal amountExcludingTax;
    private BigDecimal amountTax;

    public SplitReceiptInput() {
        this.createComponentTree();
        this.connectValidators();
    }

    private void createComponentTree() {
        this.initDateInput(this.dateInput);
        this.dateInput.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Calendar calendar = SplitReceiptInput.this.dateInput.getCalendar();
                SplitReceiptInput.this.synchronizeDateInputWithOtherProviders(calendar);
            }
        });
        this.accountInput = new AccountComboBox(this.accountList);
        ThinkingComboBoxModel topListModel = new ThinkingComboBoxModel(DataCenter.getInstance().getReceiptDescriptionList());
        this.descriptionInput = new AutocompleteComboBox(topListModel);
        this.descriptionInput.setEditable(true);
        this.descriptionInput.setStrict(false);
        this.descriptionInput.setRenderer(new ThinkingComboBoxModelRenderer());
        this.descriptionInput.getModel().setSelectedItem(null);
        this.descriptionInput.setToolTipText(TextPool.getString("tooltipInputDesc"));
        AutoLengthPopupComboBox.extendComboBoxPopup(this.descriptionInput);
        MultiListComboBoxModel model = new MultiListComboBoxModel();
        model.addList(DataCenter.getInstance().getPaymentTemplateList());
        model.addList(DataCenter.getInstance().getReceiptDescriptionList());
        this.paymentDescriptionInput.setEditable(true);
        this.paymentDescriptionInput.setModel(model);
        this.paymentDescriptionInput.setRenderer(new ThinkingComboBoxModelRenderer());
        this.paymentDescriptionInput.getModel().setSelectedItem(null);
        this.paymentDescriptionInput.setToolTipText(TextPool.getString("tooltipInputPaymentDesc"));
        AutoLengthPopupComboBox.extendComboBoxPopup(this.paymentDescriptionInput);
        this.paymentDescriptionInput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Object obj = SplitReceiptInput.this.paymentDescriptionInput.getSelectedItem();
                if (obj instanceof PaymentTemplate) {
                    SplitReceiptInput.this.setValuesFromTemplate((PaymentTemplate)obj);
                }
            }
        });
        this.taxInput = new TaxComboBox(DataCenter.getInstance().getTaxList());
        this.incudingExcludingTaxInput.setToolTipText(TextPool.getString("tooltipIncludingExcludingTax"));
        this.amountInput.setToolTipText(TextPool.getString("tooltipInputAmount"));
        this.idInput.setToolTipText(TextPool.getString("tooltipInputId"));
        JPanel paymentsPanel = new JPanel(new BorderLayout());
        paymentsPanel.setBorder(BorderFactory.createTitledBorder(TextPool.getString("titlePayments")));
        this.paymentsTable = new JTable(new PaymentTableModel(this.payments));
        this.paymentsTable.setPreferredScrollableViewportSize(new Dimension(1, 100));
        this.setColumnRenderer(this.paymentsTable, 2, new MoneyCellRenderer());
        this.setColumnRenderer(this.paymentsTable, 3, new MoneyCellRenderer());
        this.setColumnRenderer(this.paymentsTable, 4, new MoneyCellRenderer());
        this.setColumnRenderer(this.paymentsTable, 5, new PercentCellRenderer());
        paymentsPanel.add("Center", new JScrollPane(this.paymentsTable));
        GridBagLayout gb1 = new GridBagLayout();
        JPanel paymentInputPanel = new JPanel(gb1);
        paymentInputPanel.setBorder(BorderFactory.createTitledBorder(TextPool.getString("titleEditPayments")));
        GuiTools.addComponent(paymentInputPanel, gb1, this.accountLabel, 0, 1, 1, 1, 0.0, 0.0);
        GuiTools.addComponent(paymentInputPanel, gb1, this.accountInput, 1, 1, 3, 1, 1.0, 0.0);
        GuiTools.addComponent(paymentInputPanel, gb1, this.paymentDescriptionLabel, 0, 3, 1, 1, 0.0, 0.0);
        GuiTools.addComponent(paymentInputPanel, gb1, this.paymentDescriptionInput, 1, 3, 3, 1, 1.0, 0.0);
        GuiTools.addComponent(paymentInputPanel, gb1, this.amountLabel, 0, 4, 1, 1, 0.0, 0.0);
        GuiTools.addComponent(paymentInputPanel, gb1, this.amountInput, 1, 4, 1, 1, 1.0, 0.0);
        GuiTools.addComponent(paymentInputPanel, gb1, this.taxLabel, 2, 4, 1, 1, 0.0, 0.0);
        GuiTools.addComponent(paymentInputPanel, gb1, this.taxInput, 3, 4, 1, 1, 1.0, 0.0);
        GuiTools.addComponent(paymentInputPanel, gb1, this.incudingExcludingTaxInput, 2, 5, 2, 1, 1.0, 0.0);
        this.addPaymentButton = new JButton(new AbstractAction(TextPool.getString("buttonAddPayment")){

            @Override
            public void actionPerformed(ActionEvent e) {
                SplitReceiptInput.this.addPayment();
            }
        });
        if (SettingsManager.getInstance().useNetbookMode()) {
            GuiTools.addComponent(paymentInputPanel, gb1, this.addPaymentButton, 0, 5, 2, 1, 1.0, 0.0);
        } else {
            GuiTools.addComponent(paymentInputPanel, gb1, this.addPaymentButton, 0, 6, 4, 1, 1.0, 0.0);
        }
        GridBagLayout gb2 = new GridBagLayout();
        JPanel generalInputPanel = new JPanel(gb2);
        generalInputPanel.setBorder(BorderFactory.createTitledBorder(TextPool.getString("titleGeneralReceiptData")));
        GuiTools.addComponent(generalInputPanel, gb2, this.dateLabel, 0, 0, 1, 1, 0.0, 0.0);
        GuiTools.addComponent(generalInputPanel, gb2, this.dateInput, 1, 0, 1, 1, 1.0, 0.0);
        GuiTools.addComponent(generalInputPanel, gb2, this.unpaidInput, 2, 0, 2, 1, 0.0, 0.0);
        GuiTools.addComponent(generalInputPanel, gb2, this.idLabel, 0, 2, 1, 1, 0.0, 0.0);
        GuiTools.addComponent(generalInputPanel, gb2, this.idInput, 1, 2, 3, 1, 1.0, 0.0);
        GuiTools.addComponent(generalInputPanel, gb2, this.descriptionLabel, 0, 3, 1, 1, 0.0, 0.0);
        GuiTools.addComponent(generalInputPanel, gb2, this.descriptionInput, 1, 3, 3, 1, 1.0, 0.0);
        ReceiptInfoPanel infoPanel = new ReceiptInfoPanel();
        this.infoExcludingTaxOutput = infoPanel.getInfoExcludingTaxOutput();
        this.infoIncludingTaxOutput = infoPanel.getInfoIncludingTaxOutput();
        this.infoReceiptNoOutput = infoPanel.getInfoReceiptNoOutput();
        this.infoTaxAmountOutput = infoPanel.getInfoTaxAmountOutput();
        GridBagLayout gb = new GridBagLayout();
        JPanel belegPanel = new JPanel(gb);
        GuiTools.addComponent(belegPanel, gb, generalInputPanel, 0, 0, 1, 1, 1.0, 1.0);
        GuiTools.addComponent(belegPanel, gb, paymentsPanel, 0, 1, 1, 1, 1.0, 1.0);
        GuiTools.addComponent(belegPanel, gb, paymentInputPanel, 0, 2, 1, 1, 1.0, 1.0);
        this.setLayout(new BorderLayout());
        this.add("North", belegPanel);
        this.add("Center", new JPanel());
        this.add("South", infoPanel);
        this.doLayout();
        this.paymentsTable.addMouseListener(new MouseAdapter(){
            private Payment currentPayment = null;

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    JTable tabelle = (JTable)e.getComponent();
                    if (!tabelle.isEnabled()) {
                        return;
                    }
                    int y = tabelle.rowAtPoint(e.getPoint());
                    tabelle.setRowSelectionInterval(y, y);
                    PaymentTableModel model = (PaymentTableModel)tabelle.getModel();
                    Payment p = model.getItemAt(y);
                    SplitReceiptInput.this.editPayment(p);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JTable tabelle = (JTable)e.getComponent();
                    int y = tabelle.rowAtPoint(e.getPoint());
                    tabelle.setRowSelectionInterval(y, y);
                    this.showPopupMenu(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    JTable tabelle = (JTable)e.getComponent();
                    int y = tabelle.rowAtPoint(e.getPoint());
                    tabelle.setRowSelectionInterval(y, y);
                    this.showPopupMenu(e.getComponent(), e.getX(), e.getY());
                }
            }

            private void showPopupMenu(Component c, int x, int y) {
                JTable tabelle = (JTable)c;
                if (!tabelle.isEnabled()) {
                    return;
                }
                int selected = tabelle.getSelectedRow();
                if (selected < 0) {
                    return;
                }
                PaymentTableModel model = (PaymentTableModel)tabelle.getModel();
                this.currentPayment = model.getItemAt(selected);
                JPopupMenu menu = new JPopupMenu();
                menu.add(new AbstractAction(TextPool.getString("menuPopupEditPayment")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SplitReceiptInput.this.editPayment(currentPayment);
                    }
                });
                menu.add(new AbstractAction(TextPool.getString("menuPopupDeletePayment")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SplitReceiptInput.this.removePayment(currentPayment);
                    }
                });
                menu.show(c, x, y);
            }
        });
    }

    private void connectValidators() {
        new ValidatorHook(this.amountInput, new FloatValidator(3, 2));
    }

    private void setValuesFromTemplate(PaymentTemplate template) {
        if (template == null) {
            return;
        }
        if (template.getAccountNumber() != null) {
            this.accountInput.setSelectedAccount(template.getAccountNumber());
        }
        if (template.getAmount() != null) {
            this.amountInput.setText(template.getAmount().toPlainString());
        }
        if (template.getTaxID() != null) {
            this.taxInput.setSelectedTax(template.getTaxID());
        }
        if (template.getIncludingExcludingTax() != null) {
            this.incudingExcludingTaxInput.setSelectedIndex(template.getIncludingExcludingTax());
        }
    }

    private void setColumnRenderer(JTable tabelle, int c, TableCellRenderer r) {
        tabelle.getColumn(tabelle.getModel().getColumnName(c)).setCellRenderer(r);
    }

    @Override
    public void setCurrentReceiptNumber(int number) {
        this.infoReceiptNoOutput.setText(String.valueOf(number));
    }

    public void addPayment() {
        String text = null;
        Payment p = null;
        Account account = null;
        try {
            account = this.accountInput.getSelectedAccount();
            BigDecimal amount = new BigDecimal(this.amountInput.getText().replace(",", "."));
            Tax tax = this.taxInput.getSelectedTax();
            text = this.paymentDescriptionInput.getEditor().getItem().toString();
            switch (this.incudingExcludingTaxInput.getSelectedIndex()) {
                case 0: {
                    p = PaymentFactory.createPaymentFromAmountIncludingTaxAndTaxPercent(account.getAccountNumber(), amount, tax.getPercent(), tax.getTaxKey(), text);
                    break;
                }
                case 1: {
                    p = PaymentFactory.createPaymentFromAmountExcludingTaxAndTaxPercent(account.getAccountNumber(), amount, tax.getPercent(), tax.getTaxKey(), text);
                    break;
                }
                case 2: {
                    p = PaymentFactory.createPaymentFromAmountExcludingTaxAndTaxAmount(account.getAccountNumber(), Constants.ZERO, amount, tax.getPercent(), tax.getTaxKey(), text);
                }
            }
        }
        catch (NumberFormatException e) {
            this.amountInput.requestFocus();
            JOptionPane.showMessageDialog(this, TextPool.getString("msgInvalidAmount"), TextPool.getString("titleErrorMessage"), 0);
            return;
        }
        if (text.isEmpty()) {
            this.paymentDescriptionInput.requestFocus();
            JOptionPane.showMessageDialog(this, TextPool.getString("msgInvalidDescription"), TextPool.getString("titleErrorMessage"), 0);
            return;
        }
        if (this.payments.size() > 0) {
            int firstPaymentAccountNumber = this.payments.get(0).getAccount();
            Account firstPaymentAccount = DataCenter.getInstance().getAccountList().getByAccountNumber(firstPaymentAccountNumber);
            if (firstPaymentAccount != null && firstPaymentAccount.getAccountType() != account.getAccountType()) {
                this.accountInput.requestFocus();
                JOptionPane.showMessageDialog(this, TextPool.getString("msgMultipleAccountTypes"), TextPool.getString("titleErrorMessage"), 0);
                return;
            }
        }
        if (p != null) {
            this.payments.add(p);
            ((PaymentTableModel)this.paymentsTable.getModel()).dataChanged();
            this.updateInfo();
        }
        this.amountInput.setText("");
        Object selectedInDescriptionField = this.paymentDescriptionInput.getSelectedItem();
        if (selectedInDescriptionField != null && !(selectedInDescriptionField instanceof PaymentTemplate)) {
            ThinkingComboBoxModel model = DataCenter.getInstance().getReceiptDescriptionList();
            model.addToList(selectedInDescriptionField.toString());
        }
        DataCenter.getInstance().getReceiptDescriptionList().addToList(text);
        this.paymentDescriptionInput.getEditor().setItem("");
        this.incudingExcludingTaxInput.setSelectedIndex(0);
        this.taxInput.setSelectedIndex(0);
    }

    public void editPayment(Payment p) {
        if (p != null) {
            this.amountInput.setText(LocalizationManager.amountToPlainString(p.getAmountIncludingTax()));
            this.accountInput.setSelectedAccount(p.getAccount());
            this.taxInput.setSelectedTax(p.getTaxKey());
            this.incudingExcludingTaxInput.setSelectedIndex(0);
            this.paymentDescriptionInput.getEditor().setItem(p.getText());
            this.payments.remove(p);
            ((PaymentTableModel)this.paymentsTable.getModel()).dataChanged();
            this.updateInfo();
        }
    }

    public void removePayment(Payment p) {
        if (p != null) {
            this.payments.remove(p);
            ((PaymentTableModel)this.paymentsTable.getModel()).dataChanged();
            this.updateInfo();
        }
    }

    public void updateInfo() {
        this.amountExcludingTax = Constants.ZERO;
        this.amountIncludingTax = Constants.ZERO;
        this.amountTax = Constants.ZERO;
        for (Payment p : this.payments) {
            this.amountExcludingTax = this.amountExcludingTax.add(p.getAmountExcludingTax());
            this.amountIncludingTax = this.amountIncludingTax.add(p.getAmountIncludingTax());
            this.amountTax = this.amountTax.add(p.getAmountTax());
        }
        this.infoExcludingTaxOutput.setText(LocalizationManager.amountToCurrencyString(this.amountExcludingTax));
        this.infoIncludingTaxOutput.setText(LocalizationManager.amountToCurrencyString(this.amountIncludingTax));
        this.infoTaxAmountOutput.setText(LocalizationManager.amountToCurrencyString(this.amountTax));
    }

    @Override
    List<Payment> getPaymentsChain() {
        ArrayList<Payment> result = new ArrayList<Payment>(this.payments.size());
        for (Payment p : this.payments) {
            result.add(PaymentFactory.createPaymentFromPayment(p));
        }
        return result;
    }

    @Override
    void setPaymentsChain(List<Payment> payments) {
        if (payments == null) {
            this.payments.clear();
        } else {
            this.payments.clear();
            this.payments.addAll(payments);
        }
        ((PaymentTableModel)this.paymentsTable.getModel()).dataChanged();
        this.updateInfo();
    }

    @Override
    public AbstractReceipt createYourReceiptNow() throws ReceiptDataException {
        Logger logger = Logger.getLogger(this.getClass().getName());
        Calendar c = this.dateInput.getCalendar();
        if (c == null) {
            this.dateInput.requestFocus();
            throw new ReceiptDataException(TextPool.getString("msgInvalidDate"));
        }
        Date date = Date.getDate(c);
        String description = this.descriptionInput.getEditor().getItem().toString();
        if (description.isEmpty()) {
            this.descriptionInput.requestFocus();
            throw new ReceiptDataException(TextPool.getString("msgInvalidDescription"));
        }
        if (this.payments.size() == 0) {
            this.amountInput.requestFocus();
            throw new ReceiptDataException(TextPool.getString("msgPaymentsListEmpty"));
        }
        ((ThinkingComboBoxModel)this.descriptionInput.getModel()).addToList(description);
        DataCenter.getInstance().getReceiptDescriptionList().addToList(description);
        logger.finer("Create Split Receipt");
        SplitReceipt r = ReceiptFactory.createSplitReceipt(Integer.parseInt(this.infoReceiptNoOutput.getText()), date, this.idInput.getText(), this.payments, description);
        if (this.unpaidInput.isSelected()) {
            r.setPaid(false);
        }
        return r;
    }

    @Override
    public void resetInputs() {
        Component[] allComponents;
        this.unpaidInput.setSelected(false);
        this.amountInput.setText("");
        this.idInput.setText("");
        this.descriptionInput.getEditor().setItem("");
        this.incudingExcludingTaxInput.setSelectedIndex(0);
        this.taxInput.setSelectedIndex(0);
        this.payments.clear();
        ((PaymentTableModel)this.paymentsTable.getModel()).dataChanged();
        this.infoExcludingTaxOutput.setText("");
        this.infoIncludingTaxOutput.setText("");
        this.infoTaxAmountOutput.setText("");
        Component[] componentArray = allComponents = this.dateInput.getComponents();
        int n = allComponents.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c instanceof JTextField) {
                c.requestFocus();
                break;
            }
            ++n2;
        }
        this.updateInfo();
    }

    @Override
    public boolean hasUnsavedInput() {
        return !this.descriptionInput.getEditor().getItem().toString().isEmpty() || !this.idInput.getText().isEmpty() || this.payments.size() > 0;
    }

    @Override
    public void setReceiptContents(Receipt r) {
        assert (r instanceof SplitReceipt) : "SplitReceiptInput editing wrong receipt type";
        SplitReceipt sr = (SplitReceipt)r;
        ReceiptNumberManager.getInstance().removeReceiptNumberListener(this);
        this.infoReceiptNoOutput.setText(Integer.toString(r.getNumber()));
        Calendar c = Calendar.getInstance();
        c.set(r.getDate().getYear(), r.getDate().getMonth() - 1, r.getDate().getDay());
        this.dateInput.setCalendar(c);
        this.unpaidInput.setSelected(!r.isPaid());
        this.idInput.setText(r.getId());
        this.descriptionInput.getEditor().setItem(r.getReceiptDescription());
        this.payments.clear();
        this.payments.addAll(sr.getPayments());
        ((PaymentTableModel)this.paymentsTable.getModel()).dataChanged();
        this.updateInfo();
    }

    @Override
    public void setDateInputValue(Calendar value) {
        this.dateInput.setCalendar(value);
    }

    @Override
    public String toString() {
        return "Aufgeteilter Beleg";
    }

    @Override
    public void dialogOpens() {
    }

    @Override
    public void saveDialogData() {
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public String getTitle() {
        return TextPool.getString("titleEditReceipt");
    }

    @Override
    public void dispose() {
        SplitReceiptInput.setLastDate(this.dateInput.getCalendar());
    }

    @Override
    public AbstractReceiptInput getReceiptInputFor(Receipt r) {
        if (r instanceof SplitReceipt) {
            return this;
        }
        return super.getReceiptInputFor(r);
    }

    @Override
    void setEditMode(boolean canEditDate, boolean canEditText, boolean canEditPayments, boolean canEditPaidState) {
        this.dateInput.setEnabled(canEditDate);
        this.descriptionInput.setEnabled(canEditText);
        this.idInput.setEnabled(canEditText);
        this.amountInput.setEnabled(canEditPayments);
        this.taxInput.setEnabled(canEditPayments);
        this.incudingExcludingTaxInput.setEnabled(canEditPayments);
        this.paymentDescriptionInput.setEnabled(canEditPayments);
        this.paymentsTable.setEnabled(canEditPayments);
        this.accountInput.setEnabled(canEditPayments);
        this.addPaymentButton.setEnabled(canEditPayments);
        this.unpaidInput.setEnabled(canEditPaidState);
    }
}

