/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.receipt.gui;

import com.toedter.calendar.JDateChooser;
import de.uwemock.datetools.Date;
import de.uwemock.eur.accounts.Account;
import de.uwemock.eur.accounts.AccountList;
import de.uwemock.eur.accounts.gui.AccountComboBox;
import de.uwemock.eur.data.Constants;
import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.data.LocalizationManager;
import de.uwemock.eur.data.Tax;
import de.uwemock.eur.data.gui.TaxComboBox;
import de.uwemock.eur.gui.ReceiptDataException;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.gui.ThinkingComboBoxModel;
import de.uwemock.eur.gui.ThinkingComboBoxModelRenderer;
import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.eur.receipt.Payment;
import de.uwemock.eur.receipt.PaymentFactory;
import de.uwemock.eur.receipt.PaymentTemplate;
import de.uwemock.eur.receipt.Receipt;
import de.uwemock.eur.receipt.ReceiptFactory;
import de.uwemock.eur.receipt.ReceiptNumberManager;
import de.uwemock.eur.receipt.SimpleReceipt;
import de.uwemock.eur.receipt.gui.AbstractReceiptInput;
import de.uwemock.eur.receipt.gui.ReceiptInfoPanel;
import de.uwemock.guitools.AutoLengthPopupComboBox;
import de.uwemock.guitools.AutocompleteComboBox;
import de.uwemock.guitools.GuiTools;
import de.uwemock.guitools.MultiListComboBoxModel;
import de.uwemock.guitools.validators.FloatValidator;
import de.uwemock.guitools.validators.ValidatorHook;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class SimpleReceiptInput
extends AbstractReceiptInput {
    private JLabel dateLabel = new JLabel(TextPool.getString("labelDate"));
    private JDateChooser dateInput = new JDateChooser();
    private JLabel idLabel = new JLabel(TextPool.getString("labelReceiptId"));
    private JTextField idInput = new JTextField(10);
    private JLabel accountLabel = new JLabel(TextPool.getString("labelAccount"));
    private AccountComboBox accountInput;
    private JLabel descriptionLabel = new JLabel(TextPool.getString("labelDescription"));
    private AutocompleteComboBox descriptionInput;
    private JLabel amountLabel = new JLabel(TextPool.getString("labelAmount"));
    private JTextField amountInput = new JTextField(10);
    private JLabel taxLabel = new JLabel(TextPool.getString("labelTax"));
    private TaxComboBox taxInput;
    private JComboBox incudingExcludingTaxInput = new JComboBox<String>(TextPool.getArray("INCLUDING_EXCLUDING_TAX"));
    private JTextField infoReceiptNoOutput = new JTextField(10);
    private JTextField infoIncludingTaxOutput = new JTextField(10);
    private JTextField infoExcludingTaxOutput = new JTextField(10);
    private JTextField infoTaxAmountOutput = new JTextField(10);
    private JCheckBox unpaidInput = new JCheckBox(TextPool.getString("labelUnpaid"));
    private AccountList accountList = DataCenter.getInstance().getAccountList().getFilteredList();
    private BigDecimal amountIncludingTax;
    private BigDecimal amountExcludingTax;
    private BigDecimal amountTax;

    public SimpleReceiptInput() {
        this.createComponentTree();
        this.connectValidators();
    }

    private void createComponentTree() {
        this.initDateInput(this.dateInput);
        this.dateInput.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Calendar calendar = SimpleReceiptInput.this.dateInput.getCalendar();
                SimpleReceiptInput.this.synchronizeDateInputWithOtherProviders(calendar);
            }
        });
        GridBagLayout gb1 = new GridBagLayout();
        JPanel belegPanel = new JPanel(gb1);
        belegPanel.setBorder(BorderFactory.createTitledBorder(TextPool.getString("labelReceipt")));
        this.accountInput = new AccountComboBox(this.accountList);
        MultiListComboBoxModel model = new MultiListComboBoxModel();
        model.addList(DataCenter.getInstance().getPaymentTemplateList());
        model.addList(DataCenter.getInstance().getReceiptDescriptionList());
        this.descriptionInput = new AutocompleteComboBox(model);
        this.descriptionInput.setEditable(true);
        this.descriptionInput.setStrict(false);
        this.descriptionInput.setRenderer(new ThinkingComboBoxModelRenderer());
        this.descriptionInput.getModel().setSelectedItem(null);
        this.descriptionInput.setToolTipText(TextPool.getString("tooltipInputDesc"));
        AutoLengthPopupComboBox.extendComboBoxPopup(this.descriptionInput);
        this.descriptionInput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                Object obj = SimpleReceiptInput.this.descriptionInput.getSelectedItem();
                if (obj instanceof PaymentTemplate) {
                    SimpleReceiptInput.this.setValuesFromTemplate((PaymentTemplate)obj);
                }
            }
        });
        this.taxInput = new TaxComboBox(DataCenter.getInstance().getTaxList());
        this.taxInput.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SimpleReceiptInput.this.updateInfo();
            }
        });
        this.incudingExcludingTaxInput.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SimpleReceiptInput.this.updateInfo();
            }
        });
        this.incudingExcludingTaxInput.setToolTipText(TextPool.getString("tooltipIncludingExcludingTax"));
        this.amountInput.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.update();
            }

            public void update() {
                SimpleReceiptInput.this.updateInfo();
            }
        });
        this.amountInput.setToolTipText(TextPool.getString("tooltipInputAmount"));
        this.idInput.setToolTipText(TextPool.getString("tooltipInputId"));
        GuiTools.addComponent(belegPanel, gb1, this.dateLabel, 0, 0, 1, 1, 0.0, 0.0);
        GuiTools.addComponent(belegPanel, gb1, this.dateInput, 1, 0, 2, 1, 1.0, 0.0);
        GuiTools.addComponent(belegPanel, gb1, this.unpaidInput, 3, 0, 1, 1, 0.0, 0.0);
        GuiTools.addComponent(belegPanel, gb1, this.accountLabel, 0, 1, 1, 1, 0.0, 0.0);
        GuiTools.addComponent(belegPanel, gb1, this.accountInput, 1, 1, 3, 1, 1.0, 0.0);
        GuiTools.addComponent(belegPanel, gb1, this.idLabel, 0, 2, 1, 1, 0.0, 0.0);
        GuiTools.addComponent(belegPanel, gb1, this.idInput, 1, 2, 3, 1, 1.0, 0.0);
        GuiTools.addComponent(belegPanel, gb1, this.descriptionLabel, 0, 3, 1, 1, 0.0, 0.0);
        GuiTools.addComponent(belegPanel, gb1, this.descriptionInput, 1, 3, 3, 1, 1.0, 0.0);
        GuiTools.addComponent(belegPanel, gb1, this.amountLabel, 0, 4, 1, 1, 0.0, 0.0);
        GuiTools.addComponent(belegPanel, gb1, this.amountInput, 1, 4, 1, 1, 1.0, 0.0);
        GuiTools.addComponent(belegPanel, gb1, this.taxLabel, 2, 4, 1, 1, 0.0, 0.0);
        GuiTools.addComponent(belegPanel, gb1, this.taxInput, 3, 4, 1, 1, 1.0, 0.0);
        GuiTools.addComponent(belegPanel, gb1, this.incudingExcludingTaxInput, 3, 5, 2, 1, 1.0, 0.0);
        ReceiptInfoPanel infoPanel = new ReceiptInfoPanel();
        this.infoExcludingTaxOutput = infoPanel.getInfoExcludingTaxOutput();
        this.infoIncludingTaxOutput = infoPanel.getInfoIncludingTaxOutput();
        this.infoReceiptNoOutput = infoPanel.getInfoReceiptNoOutput();
        this.infoTaxAmountOutput = infoPanel.getInfoTaxAmountOutput();
        this.setLayout(new BorderLayout());
        this.add("North", belegPanel);
        this.add("Center", new JPanel());
        this.add("South", infoPanel);
        this.doLayout();
    }

    private void connectValidators() {
        new ValidatorHook(this.amountInput, new FloatValidator(3, 2));
    }

    private void setValuesFromTemplate(PaymentTemplate template) {
        if (template == null) {
            return;
        }
        if (template.getAccountNumber() != null && this.accountInput.isEnabled()) {
            this.accountInput.setSelectedAccount(template.getAccountNumber());
        }
        if (template.getAmount() != null && this.amountInput.isEnabled()) {
            this.amountInput.setText(template.getAmount().toPlainString());
        }
        if (template.getTaxID() != null && this.taxInput.isEnabled()) {
            this.taxInput.setSelectedTax(template.getTaxID());
        }
        if (template.getIncludingExcludingTax() != null && this.incudingExcludingTaxInput.isEnabled()) {
            this.incudingExcludingTaxInput.setSelectedIndex(template.getIncludingExcludingTax());
        }
    }

    @Override
    public void setCurrentReceiptNumber(int number) {
        this.infoReceiptNoOutput.setText(String.valueOf(number));
    }

    public void updateInfo() {
        try {
            this.amountTax = ((Tax)this.taxInput.getSelectedItem()).getMultiplier();
            if (this.incudingExcludingTaxInput.getSelectedIndex() == 0) {
                this.amountIncludingTax = new BigDecimal(this.amountInput.getText().replace(",", "."));
                this.amountExcludingTax = this.amountIncludingTax.divide(this.amountTax, 2, RoundingMode.HALF_UP).setScale(2, RoundingMode.HALF_UP);
                this.amountTax = this.amountIncludingTax.subtract(this.amountExcludingTax);
            }
            if (this.incudingExcludingTaxInput.getSelectedIndex() == 1) {
                this.amountExcludingTax = new BigDecimal(this.amountInput.getText().replace(",", "."));
                this.amountIncludingTax = this.amountExcludingTax.multiply(this.amountTax).setScale(2, RoundingMode.HALF_UP);
                this.amountTax = this.amountIncludingTax.subtract(this.amountExcludingTax);
            }
            if (this.incudingExcludingTaxInput.getSelectedIndex() == 2) {
                this.amountIncludingTax = this.amountTax = new BigDecimal(this.amountInput.getText().replace(",", "."));
                this.amountExcludingTax = Constants.ZERO;
            }
            this.infoExcludingTaxOutput.setText(LocalizationManager.amountToCurrencyString(this.amountExcludingTax));
            this.infoIncludingTaxOutput.setText(LocalizationManager.amountToCurrencyString(this.amountIncludingTax));
            this.infoTaxAmountOutput.setText(LocalizationManager.amountToCurrencyString(this.amountTax));
        }
        catch (NumberFormatException e) {
            this.amountExcludingTax = null;
            this.amountIncludingTax = null;
            this.amountTax = null;
        }
    }

    @Override
    public AbstractReceipt createYourReceiptNow() throws ReceiptDataException {
        Logger logger = Logger.getLogger(this.getClass().getName());
        Calendar c = this.dateInput.getCalendar();
        if (c == null) {
            this.dateInput.requestFocus();
            throw new ReceiptDataException(TextPool.getString("msgInvalidDate"));
        }
        Date date = Date.getDate(c);
        String description = this.descriptionInput.getEditor().getItem().toString();
        if (description.isEmpty()) {
            this.descriptionInput.requestFocus();
            throw new ReceiptDataException(TextPool.getString("msgInvalidDescription"));
        }
        if (this.amountExcludingTax == null || this.amountIncludingTax == null || this.amountTax == null) {
            this.amountInput.requestFocus();
            throw new ReceiptDataException(TextPool.getString("msgInvalidAmount"));
        }
        Object selectedInDescriptionField = this.descriptionInput.getSelectedItem();
        if (!(selectedInDescriptionField instanceof PaymentTemplate)) {
            ThinkingComboBoxModel model = DataCenter.getInstance().getReceiptDescriptionList();
            model.addToList(description);
        }
        logger.finer("Create Simple Receipt");
        SimpleReceipt r = ReceiptFactory.createSimpleReceipt(Integer.parseInt(this.infoReceiptNoOutput.getText()), date, this.idInput.getText(), this.accountInput.getSelectedAccountNumber(), this.amountExcludingTax, this.amountTax, this.taxInput.getSelectedTaxPercent(), this.taxInput.getSelectedTaxReadable(), description);
        if (this.unpaidInput.isSelected()) {
            r.setPaid(false);
        }
        return r;
    }

    @Override
    public void resetInputs() {
        Component[] allComponents;
        this.unpaidInput.setSelected(false);
        this.amountInput.setText("");
        this.idInput.setText("");
        this.descriptionInput.getEditor().setItem("");
        this.incudingExcludingTaxInput.setSelectedIndex(0);
        this.taxInput.setSelectedIndex(0);
        this.infoExcludingTaxOutput.setText("");
        this.infoIncludingTaxOutput.setText("");
        this.infoTaxAmountOutput.setText("");
        Component[] componentArray = allComponents = this.dateInput.getComponents();
        int n = allComponents.length;
        int n2 = 0;
        while (n2 < n) {
            Component c = componentArray[n2];
            if (c instanceof JTextField) {
                c.requestFocus();
                break;
            }
            ++n2;
        }
        this.updateInfo();
    }

    @Override
    public boolean hasUnsavedInput() {
        return !this.amountInput.getText().isEmpty() || !this.descriptionInput.getEditor().getItem().toString().isEmpty() || !this.idInput.getText().isEmpty();
    }

    @Override
    public void setReceiptContents(Receipt r) {
        assert (r instanceof SimpleReceipt) : "SimpleReceiptInput editing wrong receipt type";
        SimpleReceipt sr = (SimpleReceipt)r;
        ReceiptNumberManager.getInstance().removeReceiptNumberListener(this);
        this.infoReceiptNoOutput.setText(Integer.toString(r.getNumber()));
        Calendar c = Calendar.getInstance();
        c.set(r.getDate().getYear(), r.getDate().getMonth() - 1, r.getDate().getDay());
        this.dateInput.setCalendar(c);
        this.unpaidInput.setSelected(!r.isPaid());
        this.idInput.setText(r.getId());
        this.descriptionInput.getEditor().setItem(r.getReceiptDescription());
        Account oldAccount = DataCenter.getInstance().getAccountList().getByAccountNumber(sr.getAccount());
        if (oldAccount != null && !oldAccount.isVisible()) {
            this.accountList = DataCenter.getInstance().getAccountList();
            this.accountInput.setAccountList(this.accountList);
        }
        this.accountInput.setSelectedAccount(sr.getAccount());
        this.taxInput.setSelectedTax(sr.getTaxKey());
        if (sr.getAmountIncludingTax().equals(Constants.ZERO) && sr.getAmountExcludingTax().equals(Constants.ZERO)) {
            this.amountInput.setText(LocalizationManager.amountToPlainString(sr.getAmountTax()));
            this.incudingExcludingTaxInput.setSelectedIndex(2);
        } else {
            this.amountInput.setText(LocalizationManager.amountToPlainString(sr.getAmountIncludingTax()));
            this.incudingExcludingTaxInput.setSelectedIndex(0);
        }
    }

    @Override
    List<Payment> getPaymentsChain() {
        String text = null;
        Payment p = null;
        Account account = null;
        try {
            account = this.accountInput.getSelectedAccount();
            BigDecimal amount = new BigDecimal(this.amountInput.getText().replace(",", "."));
            Tax tax = this.taxInput.getSelectedTax();
            text = this.descriptionInput.getEditor().getItem().toString();
            switch (this.incudingExcludingTaxInput.getSelectedIndex()) {
                case 0: {
                    p = PaymentFactory.createPaymentFromAmountIncludingTaxAndTaxPercent(account.getAccountNumber(), amount, tax.getPercent(), tax.getTaxKey(), text);
                    break;
                }
                case 1: {
                    p = PaymentFactory.createPaymentFromAmountExcludingTaxAndTaxPercent(account.getAccountNumber(), amount, tax.getPercent(), tax.getTaxKey(), text);
                    break;
                }
                case 2: {
                    p = PaymentFactory.createPaymentFromAmountExcludingTaxAndTaxAmount(account.getAccountNumber(), Constants.ZERO, amount, tax.getPercent(), tax.getTaxKey(), text);
                }
            }
        }
        catch (NumberFormatException e) {
            return null;
        }
        if (text.isEmpty()) {
            return null;
        }
        if (p != null) {
            ArrayList<Payment> result = new ArrayList<Payment>(1);
            result.add(p);
            return result;
        }
        return null;
    }

    @Override
    void setPaymentsChain(List<Payment> payments) {
        if (payments == null || payments.size() != 1) {
            return;
        }
        Payment p = payments.get(0);
        this.descriptionInput.getEditor().setItem(p.getText());
        this.taxInput.setSelectedTax(p.getTaxKey());
        if (p.getAmountIncludingTax().equals(Constants.ZERO) && p.getAmountExcludingTax().equals(Constants.ZERO)) {
            this.amountInput.setText(LocalizationManager.amountToPlainString(p.getAmountTax()));
            this.incudingExcludingTaxInput.setSelectedIndex(2);
        } else {
            this.amountInput.setText(LocalizationManager.amountToPlainString(p.getAmountIncludingTax()));
            this.incudingExcludingTaxInput.setSelectedIndex(0);
        }
        this.updateInfo();
    }

    @Override
    void setEditMode(boolean canEditDate, boolean canEditText, boolean canEditPayments, boolean canEditPaidState) {
        this.dateInput.setEnabled(canEditDate);
        this.descriptionInput.setEnabled(canEditText);
        this.idInput.setEnabled(canEditText);
        this.amountInput.setEnabled(canEditPayments);
        this.taxInput.setEnabled(canEditPayments);
        this.incudingExcludingTaxInput.setEnabled(canEditPayments);
        this.accountInput.setEnabled(canEditPayments);
        this.unpaidInput.setEnabled(canEditPaidState);
    }

    @Override
    public void setDateInputValue(Calendar value) {
        this.dateInput.setCalendar(value);
    }

    @Override
    public String toString() {
        return "Einfacher Beleg";
    }

    @Override
    public void dialogOpens() {
    }

    @Override
    public void saveDialogData() {
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public String getTitle() {
        return TextPool.getString("titleEditReceipt");
    }

    @Override
    public void dispose() {
        SimpleReceiptInput.setLastDate(this.dateInput.getCalendar());
    }

    @Override
    public AbstractReceiptInput getReceiptInputFor(Receipt r) {
        if (r instanceof SimpleReceipt) {
            return this;
        }
        return super.getReceiptInputFor(r);
    }
}

