/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.receipt.gui;

import de.uwemock.datetools.Date;
import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.data.SettingsManager;
import de.uwemock.eur.depreciation.DepreciationStrategy;
import de.uwemock.eur.depreciation.gui.DepreciationCreationPanel;
import de.uwemock.eur.depreciation.gui.DepreciationFactory;
import de.uwemock.eur.gui.JesFileChooser;
import de.uwemock.eur.gui.ReceiptDataException;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.gui.actions.attachment.AttachmentAdder;
import de.uwemock.eur.gui.undo.AddReceiptEdit;
import de.uwemock.eur.gui.undo.JesUndoManager;
import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.eur.receipt.PoolManager;
import de.uwemock.eur.receipt.Receipt;
import de.uwemock.eur.receipt.ReceiptGroupManager;
import de.uwemock.eur.receipt.ReceiptNumberManager;
import de.uwemock.eur.receipt.gui.AbstractReceiptInput;
import de.uwemock.eur.receipt.gui.SimpleReceiptInput;
import de.uwemock.eur.receipt.gui.SplitReceiptInput;
import de.uwemock.guitools.ComponentEnabler;
import de.uwemock.guitools.FileTypeIconProvider;
import de.uwemock.guitools.StandardDialog;
import de.uwemock.tools.LoggingManager;
import de.uwemock.tools.Numbers;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;

public class ReceiptInputDialog
extends JDialog {
    private AbstractReceiptInput[] inputPanels = new AbstractReceiptInput[]{new SimpleReceiptInput(), new SplitReceiptInput()};
    private JTabbedPane tabs = new JTabbedPane();
    private JButton buttonSaveNext = new JButton(TextPool.getString("buttonSaveNext"));
    private JButton buttonSaveDone = new JButton(TextPool.getString("buttonSaveDone"));
    private JButton buttonCancel = new JButton(TextPool.getString("buttonCancel"));
    private Action actionSaveNext;
    private Action actionSaveDone;
    private JMenu attachmentsMenu = new JMenu(TextPool.getString("menuAttachment"));
    private JMenu depreciationMenu = new JMenu(TextPool.getString("menuDepreciation"));
    private JCheckBoxMenuItem createPoolReceipt;
    private Action editDepreciationDataAction;
    private Action deleteDepreciationDataAction;
    private List<String> filenames = new LinkedList<String>();
    private int depreciationNumYears = -1;
    private int depreciationType = -1;
    private Date depreciationDate;
    private Receipt templateReceipt;
    private List<File> dragAndDropBuffer = new ArrayList<File>();

    public ReceiptInputDialog(Frame parent) {
        super(parent, TextPool.getString("titleReceiptDialog"));
        this.setModal(true);
        this.createComponentTree();
    }

    public ReceiptInputDialog(Frame parent, Receipt templateReceipt) {
        this(parent);
        this.templateReceipt = templateReceipt;
        this.setTemplateReceipt();
    }

    private void createComponentTree() {
        JPanel buttonPanel;
        if (SettingsManager.getInstance().attachmentsAllowed()) {
            this.setTransferHandler(new DndHandler());
        }
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ReceiptInputDialog.this.closeDialog();
            }
        });
        this.getContentPane().add("Center", this.tabs);
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReceiptInputDialog.this.closeDialog();
            }
        });
        String textShortcutSaveNext = null;
        String textShortcutSaveDone = null;
        if (SettingsManager.getInstance().getReceiptInputDefaultButton() == SettingsManager.ReceiptInputDefaultButton.SAVE_NEXT) {
            textShortcutSaveNext = TextPool.getString("buttonSaveShortcutEnter");
            textShortcutSaveDone = TextPool.getString("buttonSaveShortcutStrgEnter");
        }
        if (SettingsManager.getInstance().getReceiptInputDefaultButton() == SettingsManager.ReceiptInputDefaultButton.SAVE_DONE) {
            textShortcutSaveNext = TextPool.getString("buttonSaveShortcutStrgEnter");
            textShortcutSaveDone = TextPool.getString("buttonSaveShortcutEnter");
        }
        String textButtonSaveNext = TextPool.getString("buttonSaveNext");
        if (textShortcutSaveNext != null) {
            textButtonSaveNext = String.format(textButtonSaveNext, "(" + textShortcutSaveNext + ")");
        } else {
            System.out.println(textButtonSaveNext);
            textButtonSaveNext = String.format(textButtonSaveNext, "");
        }
        String textButtonSaveDone = TextPool.getString("buttonSaveDone");
        textButtonSaveDone = textShortcutSaveDone != null ? String.format(textButtonSaveDone, "(" + textShortcutSaveDone + ")") : String.format(textButtonSaveDone, "");
        this.actionSaveNext = new AbstractAction(textButtonSaveNext){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReceiptInputDialog.this.saveInput();
            }
        };
        this.buttonSaveNext.setAction(this.actionSaveNext);
        this.actionSaveDone = new AbstractAction(textButtonSaveDone){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ReceiptInputDialog.this.saveInput()) {
                    ReceiptInputDialog.this.dispose();
                }
            }
        };
        this.buttonSaveDone.setAction(this.actionSaveDone);
        if (SettingsManager.getInstance().useNetbookMode()) {
            buttonPanel = new JPanel(new GridLayout(3, 1, 4, 20));
            buttonPanel.add(this.buttonSaveNext);
            buttonPanel.add(this.buttonSaveDone);
            buttonPanel.add(this.buttonCancel);
            JPanel helperPanel = new JPanel();
            helperPanel.setLayout(new BoxLayout(helperPanel, 1));
            helperPanel.add(Box.createVerticalStrut(20));
            helperPanel.add(buttonPanel);
            helperPanel.setBorder(BorderFactory.createLineBorder(helperPanel.getBackground(), 10));
            JPanel eastPanel = new JPanel(new BorderLayout());
            eastPanel.add("South", helperPanel);
            this.getContentPane().add("East", eastPanel);
        } else {
            buttonPanel = new JPanel(new GridLayout(1, 3, 4, 20));
            buttonPanel.add(this.buttonSaveNext);
            buttonPanel.add(this.buttonSaveDone);
            buttonPanel.add(this.buttonCancel);
            this.getContentPane().add("South", buttonPanel);
        }
        int currentNextReceiptNumber = ReceiptNumberManager.getInstance().getNextReceiptNumber();
        int i = 0;
        while (i < this.inputPanels.length) {
            this.tabs.addTab(this.inputPanels[i].toString(), this.inputPanels[i]);
            ReceiptNumberManager.getInstance().addReceiptNumberListener(this.inputPanels[i]);
            this.inputPanels[i].setCurrentReceiptNumber(currentNextReceiptNumber);
            int j = 0;
            while (j < this.inputPanels.length) {
                if (i != j) {
                    this.inputPanels[i].addSynchronizedDateInputProvider(this.inputPanels[j]);
                }
                ++j;
            }
            ++i;
        }
        this.addKeyboardShortcuts();
        this.createPoolReceipt = new JCheckBoxMenuItem(TextPool.getString("labelCreatePoolReceipt"));
        this.createPoolReceipt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                ReceiptInputDialog.this.makeMenus();
            }
        });
        this.editDepreciationDataAction = new DepreciationDataAction();
        this.deleteDepreciationDataAction = new DeleteDepreciationDataAction((Frame)this.getParent());
        ComponentEnabler enabler = new ComponentEnabler(this.createPoolReceipt, false);
        enabler.addAction(this.editDepreciationDataAction);
        enabler.addAction(this.deleteDepreciationDataAction);
        JMenuBar menuBar = new JMenuBar();
        menuBar.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        menuBar.add(this.depreciationMenu);
        if (SettingsManager.getInstance().attachmentsAllowed()) {
            menuBar.add(this.attachmentsMenu);
        }
        this.setJMenuBar(menuBar);
        this.makeMenus();
        this.pack();
        SettingsManager.ReceiptInputDefaultButton button = SettingsManager.getInstance().getReceiptInputDefaultButton();
        if (SettingsManager.ReceiptInputDefaultButton.SAVE_NEXT.equals((Object)button)) {
            this.getRootPane().setDefaultButton(this.buttonSaveNext);
        }
        if (SettingsManager.ReceiptInputDefaultButton.SAVE_DONE.equals((Object)button)) {
            this.getRootPane().setDefaultButton(this.buttonSaveDone);
        }
    }

    private void setTemplateReceipt() {
        if (this.templateReceipt == null) {
            return;
        }
        Component receiptInput = null;
        int i = 0;
        while (i < this.inputPanels.length) {
            AbstractReceiptInput input = this.inputPanels[i];
            if (input.getReceiptInputFor(this.templateReceipt) == input) {
                receiptInput = input;
                break;
            }
            ++i;
        }
        if (receiptInput == null) {
            return;
        }
        this.tabs.removeAll();
        this.tabs.addTab(receiptInput.toString(), receiptInput);
        receiptInput.setReceiptContents(this.templateReceipt);
        this.buttonSaveNext.setEnabled(false);
        int currentNextReceiptNumber = ReceiptNumberManager.getInstance().getNextReceiptNumber();
        receiptInput.setCurrentReceiptNumber(currentNextReceiptNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAttachmentStack() {
        List<File> list = this.dragAndDropBuffer;
        synchronized (list) {
            File[] files = new File[this.dragAndDropBuffer.size()];
            int i = 0;
            for (File f : this.dragAndDropBuffer) {
                files[i++] = f;
            }
            this.dragAndDropBuffer.clear();
            this.addAttachments(files);
        }
    }

    private void addAttachments(File[] files) {
        if (files != null) {
            ArrayList<File> filesTooLarge = new ArrayList<File>(files.length);
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.exists()) {
                    if (f.length() > (long)SettingsManager.getInstance().getAttachmentWarningSize()) {
                        filesTooLarge.add(f);
                    } else {
                        this.addFilename(f.getAbsolutePath());
                    }
                }
                ++n2;
            }
            if (filesTooLarge.size() > 0) {
                JPanel panel = new JPanel(new GridLayout(filesTooLarge.size(), 1));
                JCheckBox[] checkBoxes = new JCheckBox[filesTooLarge.size()];
                int i = 0;
                while (i < filesTooLarge.size()) {
                    File f = (File)filesTooLarge.get(i);
                    checkBoxes[i] = new JCheckBox(String.valueOf(f.getAbsolutePath()) + " (" + Numbers.getMiBString(f.length(), 1) + ")");
                    panel.add(checkBoxes[i]);
                    ++i;
                }
                JPanel displayPanel = new JPanel(new BorderLayout(0, 10));
                displayPanel.add((Component)new JLabel(TextPool.getString("msgAttachmentsTooLarge")), "North");
                displayPanel.add((Component)panel, "South");
                JOptionPane.showMessageDialog(this, displayPanel, TextPool.getString("titleDeletingDefaultAccountFor"), 3);
                int i2 = 0;
                while (i2 < checkBoxes.length) {
                    if (checkBoxes[i2].isSelected()) {
                        this.addFilename(((File)filesTooLarge.get(i2)).getAbsolutePath());
                    }
                    ++i2;
                }
            }
            this.makeMenus();
        }
    }

    private boolean saveInput() {
        AbstractReceiptInput sel = (AbstractReceiptInput)this.tabs.getSelectedComponent();
        if (sel != null) {
            try {
                AbstractReceipt r = sel.createYourReceiptNow();
                if (!this.createPoolReceipt.isSelected() && this.depreciationNumYears > 0 && this.depreciationType >= 0) {
                    DepreciationStrategy strategy = DepreciationFactory.createDepreciationStrategy((Frame)this.getParent(), r, this.depreciationType, this.depreciationNumYears, this.depreciationDate, DataCenter.getInstance().getBusinessYear());
                    r.setDepreciationStrategy(strategy);
                }
                if (this.filenames.size() > 0) {
                    AttachmentAdder.addAttachments((Frame)this.getParent(), r, this.filenames);
                }
                if (this.createPoolReceipt.isSelected()) {
                    PoolManager.getInstance().add(r);
                    JesUndoManager.getInstance().addEdit(new AddReceiptEdit(DataCenter.getInstance().getFileContext(), r));
                } else {
                    ReceiptGroupManager.getInstance().add(r);
                    JesUndoManager.getInstance().addEdit(new AddReceiptEdit(DataCenter.getInstance().getFileContext(), r));
                }
            }
            catch (ReceiptDataException e) {
                JOptionPane.showMessageDialog(this, e.getMessage(), TextPool.getString("titleReceiptCreationError"), 0);
                return false;
            }
            this.filenames.clear();
            this.depreciationNumYears = -1;
            this.depreciationType = -1;
            this.depreciationDate = null;
            this.createPoolReceipt.setSelected(false);
            this.makeMenus();
            AbstractReceiptInput[] abstractReceiptInputArray = this.inputPanels;
            int n = this.inputPanels.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractReceiptInput input = abstractReceiptInputArray[n2];
                input.resetInputs();
                ++n2;
            }
            return true;
        }
        return false;
    }

    private void makeMenus() {
        this.attachmentsMenu.removeAll();
        this.attachmentsMenu.add(new AddAttachmentAction());
        if (this.filenames.size() > 0) {
            this.attachmentsMenu.addSeparator();
            for (String filename : this.filenames) {
                JMenu menu = new JMenu(filename);
                menu.setIcon(FileTypeIconProvider.getIconForFileType(filename));
                menu.add(new RemoveFileAction(filename));
                this.attachmentsMenu.add(menu);
            }
        }
        this.depreciationMenu.removeAll();
        this.depreciationMenu.add(this.createPoolReceipt);
        this.createPoolReceipt.setEnabled(this.depreciationNumYears <= 0);
        this.depreciationMenu.addSeparator();
        this.depreciationMenu.add(this.editDepreciationDataAction);
        if (this.depreciationNumYears >= 0) {
            this.depreciationMenu.add(this.deleteDepreciationDataAction);
        }
        if (this.depreciationNumYears > 0) {
            this.editDepreciationDataAction.putValue("Name", TextPool.getString("menuPopupEditDepreciation"));
        } else {
            this.editDepreciationDataAction.putValue("Name", TextPool.getString("menuPopupAddDepreciation"));
        }
    }

    private void addFilename(String filename) {
        if (!this.filenames.contains(filename)) {
            this.filenames.add(filename);
        }
    }

    private void closeDialog() {
        int res;
        AbstractReceiptInput sel = (AbstractReceiptInput)this.tabs.getSelectedComponent();
        if (sel.hasUnsavedInput() && (res = JOptionPane.showConfirmDialog(this, TextPool.getString("msgDialogInputNotSaved"), TextPool.getString("titleDialogClosing"), 0, 3)) != 0) {
            return;
        }
        AbstractReceiptInput[] abstractReceiptInputArray = this.inputPanels;
        int n = this.inputPanels.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractReceiptInput inputPanel = abstractReceiptInputArray[n2];
            inputPanel.dispose();
            ++n2;
        }
        this.dispose();
    }

    private void addKeyboardShortcuts() {
        String actionKey = "CANCEL_ACTION_KEY";
        boolean noModifiers = false;
        KeyStroke escapeKey = KeyStroke.getKeyStroke(27, 0, false);
        InputMap inputMap = this.getRootPane().getInputMap(1);
        inputMap.put(escapeKey, actionKey);
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReceiptInputDialog.this.closeDialog();
            }
        };
        this.getRootPane().getActionMap().put(actionKey, cancelAction);
        SettingsManager.ReceiptInputDefaultButton defaultButton = SettingsManager.getInstance().getReceiptInputDefaultButton();
        if (defaultButton != SettingsManager.ReceiptInputDefaultButton.NONE) {
            actionKey = "SAVE_NEXT_KEY";
            KeyStroke strgReturnKey = KeyStroke.getKeyStroke(10, defaultButton == SettingsManager.ReceiptInputDefaultButton.SAVE_NEXT ? 0 : 128, false);
            inputMap.put(strgReturnKey, actionKey);
            this.getRootPane().getActionMap().put(actionKey, this.actionSaveNext);
            actionKey = "SAVE_DONE_KEY";
            KeyStroke returnKey = KeyStroke.getKeyStroke(10, defaultButton == SettingsManager.ReceiptInputDefaultButton.SAVE_DONE ? 0 : 128, false);
            inputMap.put(returnKey, actionKey);
            this.getRootPane().getActionMap().put(actionKey, this.actionSaveDone);
        }
    }

    class AddAttachmentAction
    extends AbstractAction {
        public AddAttachmentAction() {
            super(TextPool.getString("menuAttachmentAdd"));
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            JesFileChooser chooser = new JesFileChooser();
            chooser.setMultiSelectionEnabled(true);
            int res = chooser.showOpenDialog(ReceiptInputDialog.this);
            if (res == 0) {
                File[] files = chooser.getSelectedFiles();
                ReceiptInputDialog.this.addAttachments(files);
            }
        }
    }

    class DeleteDepreciationDataAction
    extends AbstractAction {
        private Frame parent;

        public DeleteDepreciationDataAction(Frame parent) {
            super(TextPool.getString("menuPopupRemoveDepreciation"));
            this.parent = parent;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int res = JOptionPane.showConfirmDialog(this.parent, TextPool.getString("msgConfirmRemovalOfDepreciation"), TextPool.getString("titleRemovingDepreciation"), 0);
            if (res == 0) {
                ReceiptInputDialog.this.depreciationNumYears = -1;
                ReceiptInputDialog.this.depreciationType = -1;
                ReceiptInputDialog.this.depreciationDate = null;
                ReceiptInputDialog.this.makeMenus();
            }
        }
    }

    class DepreciationDataAction
    extends AbstractAction {
        public DepreciationDataAction() {
            super(TextPool.getString("menuPopupEditDepreciation"));
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            DepreciationCreationPanel dcp = new DepreciationCreationPanel(Date.getDate());
            if (ReceiptInputDialog.this.depreciationNumYears >= 0) {
                dcp.setNumYears(ReceiptInputDialog.this.depreciationNumYears);
            }
            if (ReceiptInputDialog.this.depreciationType >= 0) {
                dcp.setDepreciationType(ReceiptInputDialog.this.depreciationType);
            }
            if (ReceiptInputDialog.this.depreciationDate != null) {
                dcp.setDate(ReceiptInputDialog.this.depreciationDate);
            }
            StandardDialog dialog = new StandardDialog((Frame)ReceiptInputDialog.this.getParent(), dcp.getTitle(), dcp);
            dialog.setVisible(true);
            if (dialog.getResult() == 1) {
                ReceiptInputDialog.this.depreciationNumYears = dcp.getNumYears();
                ReceiptInputDialog.this.depreciationType = dcp.getDepreciationType();
                ReceiptInputDialog.this.depreciationDate = dcp.getDate();
                ReceiptInputDialog.this.createPoolReceipt.setSelected(false);
                ReceiptInputDialog.this.makeMenus();
            }
        }
    }

    private class DndHandler
    extends TransferHandler {
        private DndHandler() {
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            return support.isDataFlavorSupported(DataFlavor.stringFlavor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            if (!this.canImport(support)) {
                return false;
            }
            Transferable t = support.getTransferable();
            DataFlavor bestTextFlavor = DataFlavor.selectBestTextFlavor(t.getTransferDataFlavors());
            if (bestTextFlavor.getMimeType().startsWith("text/plain") || bestTextFlavor.getMimeType().startsWith("text/html")) {
                Reader reader = null;
                OutputStreamWriter writer = null;
                File tempFile = null;
                try {
                    try {
                        reader = bestTextFlavor.getReaderForText(t);
                        String extension = ".txt";
                        if (bestTextFlavor.getMimeType().startsWith("text/html")) {
                            extension = ".html";
                        }
                        tempFile = File.createTempFile("jes_import_" + ReceiptNumberManager.getInstance().getNextReceiptNumber() + "_", extension);
                        tempFile.deleteOnExit();
                        writer = new FileWriter(tempFile);
                        int c = -1;
                        while ((c = reader.read()) >= 0) {
                            writer.write(c);
                        }
                    }
                    catch (UnsupportedFlavorException e) {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException e2) {
                                LoggingManager.logException(this.getClass(), e2);
                            }
                        }
                        if (writer == null) return false;
                        try {
                            writer.close();
                            return false;
                        }
                        catch (IOException e3) {
                            LoggingManager.logException(this.getClass(), e3);
                        }
                        return false;
                    }
                    catch (IOException e) {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException e4) {
                                LoggingManager.logException(this.getClass(), e4);
                            }
                        }
                        if (writer == null) return false;
                        try {
                            writer.close();
                            return false;
                        }
                        catch (IOException e5) {
                            LoggingManager.logException(this.getClass(), e5);
                        }
                        return false;
                    }
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            LoggingManager.logException(this.getClass(), e);
                        }
                    }
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException e) {
                            LoggingManager.logException(this.getClass(), e);
                        }
                    }
                }
                List e = ReceiptInputDialog.this.dragAndDropBuffer;
                synchronized (e) {
                    if (tempFile != null) {
                        ReceiptInputDialog.this.dragAndDropBuffer.add(tempFile);
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ReceiptInputDialog.this.processAttachmentStack();
                            }
                        });
                        return true;
                    }
                }
            }
            if (!bestTextFlavor.getMimeType().startsWith("text/uri-list")) return true;
            try {
                String line;
                BufferedReader buffer = new BufferedReader(bestTextFlavor.getReaderForText(t));
                do {
                    if ((line = buffer.readLine()) == null) continue;
                    try {
                        URI uri = new URI(line);
                        File f = new File(uri);
                        if (!f.exists() || !f.isFile() || !f.canRead()) continue;
                        List list = ReceiptInputDialog.this.dragAndDropBuffer;
                        synchronized (list) {
                            ReceiptInputDialog.this.dragAndDropBuffer.add(f);
                        }
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        // empty catch block
                    }
                } while (line != null);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ReceiptInputDialog.this.processAttachmentStack();
                    }
                });
                return true;
            }
            catch (UnsupportedFlavorException e) {
                return false;
            }
            catch (IOException e) {
                return false;
            }
        }
    }

    class RemoveFileAction
    extends AbstractAction {
        private String filename;

        RemoveFileAction(String filename) {
            super(TextPool.getString("menuAttachmentDelete"));
            this.filename = filename;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            int index = ReceiptInputDialog.this.filenames.indexOf(this.filename);
            ReceiptInputDialog.this.filenames.remove(index);
            ReceiptInputDialog.this.makeMenus();
        }
    }
}

