/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.receipt.gui;

import de.uwemock.datetools.Date;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.eur.receipt.ReceiptGroup;
import de.uwemock.eur.receipt.ReceiptGroupListener;
import java.math.BigDecimal;
import javax.swing.ImageIcon;
import javax.swing.table.AbstractTableModel;

public class ReceiptGroupTableModel
extends AbstractTableModel
implements ReceiptGroupListener {
    private final String[] COLUMNS_MAIN = TextPool.getArray("COLUMNS_MAIN");
    private static ImageIcon iconMoneyIn = new ImageIcon(ReceiptGroupTableModel.class.getResource("/icons/money_in.png"));
    private static ImageIcon iconMoneyOut = new ImageIcon(ReceiptGroupTableModel.class.getResource("/icons/money_out.png"));
    private ReceiptGroup group;

    public ReceiptGroupTableModel(ReceiptGroup group) {
        this.group = group;
        group.addReceiptGroupListener(this);
    }

    public void setReceiptGroup(ReceiptGroup group) {
        this.group.removeReceiptGroupListener(this);
        this.group = group;
        this.group.addReceiptGroupListener(this);
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return this.COLUMNS_MAIN.length;
    }

    public AbstractReceipt getItemAt(int index) {
        if (index >= 0 && index < this.group.size()) {
            return this.group.get(index);
        }
        return null;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        AbstractReceipt r = this.getItemAt(rowIndex);
        if (r == null) {
            return null;
        }
        Object res = null;
        switch (columnIndex) {
            case 0: {
                res = r.getReceiptInfo(1);
                break;
            }
            case 1: {
                res = r.getReceiptInfo(2);
                break;
            }
            case 2: {
                res = r.getReceiptInfo(14);
                break;
            }
            case 3: {
                res = r.getReceiptInfo(3);
                break;
            }
            case 4: {
                res = r.getReceiptInfo(13);
                break;
            }
            case 5: {
                if (r.isOutgoingReceipt()) {
                    return iconMoneyOut;
                }
                if (r.isIncomingReceipt()) {
                    return iconMoneyIn;
                }
                return "";
            }
            case 6: {
                return "";
            }
            case 7: {
                res = r.getReceiptInfo(6);
                break;
            }
            case 8: {
                res = r.getReceiptInfo(5);
                break;
            }
            case 9: {
                res = r.getReceiptInfo(7);
                break;
            }
            case 10: {
                res = r.getReceiptInfo(11);
                break;
            }
            default: {
                res = "";
            }
        }
        return res;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.COLUMNS_MAIN[columnIndex];
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: {
                return Integer.class;
            }
            case 1: {
                return Date.class;
            }
            case 3: {
                return String.class;
            }
            case 4: {
                return String.class;
            }
            case 5: {
                return ImageIcon.class;
            }
            case 7: {
                return BigDecimal.class;
            }
            case 8: {
                return BigDecimal.class;
            }
            case 9: {
                return BigDecimal.class;
            }
        }
        return super.getColumnClass(c);
    }

    @Override
    public int getRowCount() {
        return this.group.size();
    }

    @Override
    public void receiptGroupChanged() {
        this.fireTableDataChanged();
    }
}

