/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.receipt.gui;

import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.receipt.Payment;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class PaymentTableModel
extends AbstractTableModel {
    private final String[] COLUMNS_PAYMENT = TextPool.getArray("COLUMNS_PAYMENT");
    private List<Payment> payments;

    PaymentTableModel(List<Payment> payments) {
        this.payments = payments;
    }

    @Override
    public int getColumnCount() {
        return this.COLUMNS_PAYMENT.length;
    }

    @Override
    public int getRowCount() {
        if (this.payments != null) {
            return this.payments.size();
        }
        return 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Payment p = this.payments.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return p.getAccount();
            }
            case 1: {
                return p.getText();
            }
            case 2: {
                return p.getAmountExcludingTax();
            }
            case 3: {
                return p.getAmountIncludingTax();
            }
            case 4: {
                return p.getAmountTax();
            }
            case 5: {
                return p.getPercentTax();
            }
        }
        return "";
    }

    public Payment getItemAt(int rowIndex) {
        return this.payments.get(rowIndex);
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.COLUMNS_PAYMENT[columnIndex];
    }

    public void dataChanged() {
        this.fireTableDataChanged();
    }
}

