/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.receipt.gui;

import com.toedter.calendar.JDateChooser;
import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.data.LocalizationManager;
import de.uwemock.eur.gui.ReceiptDataException;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.eur.receipt.Payment;
import de.uwemock.eur.receipt.PaymentFactory;
import de.uwemock.eur.receipt.ReceiptNumberManager;
import de.uwemock.eur.receipt.gui.AbstractReceiptInput;
import de.uwemock.eur.receipt.gui.ReceiptInputChain;
import de.uwemock.guitools.AbstractStandardDialogPanel;
import de.uwemock.guitools.GuiTools;
import de.uwemock.guitools.validators.FloatValidator;
import de.uwemock.guitools.validators.ValidatorHook;
import de.uwemock.tools.LoggingManager;
import de.uwemock.tools.Numbers;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class PartialPaidReceiptPanel
extends AbstractStandardDialogPanel {
    private final BigDecimal ONE_CENT = new BigDecimal("0.01");
    private AbstractReceiptInput creatorOriginalReceipt;
    private AbstractReceiptInput creatorRemainingPaymentReceipt;
    private JSplitPane partialPaymentPanel;
    private JDateChooser dateInput = new JDateChooser();
    private JTextField inputPartialAmount;
    private JTextField inputDescriptionPartialPayment;
    private JTextField inputDescriptionRemainingPayment;
    private List<Payment> originalPaymentsChain;
    private BigDecimal originalTotalAmount;
    private Action okAction;
    private DocumentListener textFieldListener = new DocumentListener(){

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            PartialPaidReceiptPanel.this.enableActions();
        }

        @Override
        public void insertUpdate(DocumentEvent arg0) {
            PartialPaidReceiptPanel.this.enableActions();
        }

        @Override
        public void changedUpdate(DocumentEvent arg0) {
            PartialPaidReceiptPanel.this.enableActions();
        }
    };

    public PartialPaidReceiptPanel(AbstractReceipt r) {
        this.creatorOriginalReceipt = ReceiptInputChain.getReceiptInputFor(r);
        if (this.creatorOriginalReceipt == null) {
            return;
        }
        try {
            Class<?> c = this.creatorOriginalReceipt.getClass();
            Constructor<?> constructor = c.getConstructor(new Class[0]);
            this.creatorOriginalReceipt = (AbstractReceiptInput)constructor.newInstance(new Object[0]);
            this.creatorRemainingPaymentReceipt = (AbstractReceiptInput)constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            LoggingManager.logException(this.getClass(), e);
            return;
        }
        r.setPaid(true);
        this.creatorOriginalReceipt.setReceiptContents(r);
        r.setPaid(false);
        this.creatorRemainingPaymentReceipt.setReceiptContents(r);
        this.creatorRemainingPaymentReceipt.setCurrentReceiptNumber(ReceiptNumberManager.getInstance().getNextReceiptNumber());
        this.originalPaymentsChain = this.creatorOriginalReceipt.getPaymentsChain();
        this.originalTotalAmount = Numbers.BIG_DECIMAL_ZERO;
        for (Payment p : this.originalPaymentsChain) {
            this.originalTotalAmount = this.originalTotalAmount.add(p.getAmountIncludingTax());
        }
        this.creatorOriginalReceipt.initDateInput(this.dateInput);
        this.inputDescriptionPartialPayment = new JTextField(26);
        this.inputDescriptionPartialPayment.setText(r.getReceiptDescription());
        this.inputDescriptionRemainingPayment = new JTextField(26);
        this.inputDescriptionRemainingPayment.setText(r.getReceiptDescription());
        this.createComponentTree();
        this.connectListeners();
    }

    @Override
    public void dialogOpens() {
        this.inputPartialAmount.requestFocus();
        this.enableActions();
    }

    private void createComponentTree() {
        BigDecimal maxPayment = this.originalTotalAmount.subtract(this.ONE_CENT);
        this.inputPartialAmount = new JTextField(12);
        this.inputPartialAmount.setHorizontalAlignment(4);
        new ValidatorHook(this.inputPartialAmount, new FloatValidator(2, 2, Numbers.BIG_DECIMAL_ZERO, maxPayment));
        StringBuilder sb = new StringBuilder(32);
        sb.append(DataCenter.getInstance().getCurrency());
        sb.append(" (");
        sb.append(LocalizationManager.amountToCurrencyString(this.ONE_CENT));
        sb.append(" - ");
        sb.append(LocalizationManager.amountToCurrencyString(maxPayment));
        sb.append(")");
        GridBagLayout gbl = new GridBagLayout();
        JPanel inputPanel = new JPanel(gbl);
        inputPanel.setBorder(BorderFactory.createTitledBorder(TextPool.getString("labelPartialPayment")));
        GuiTools.addComponent(inputPanel, gbl, new JLabel(String.valueOf(TextPool.getString("labelDate")) + ":"), 0, 0, 1, 1, 0.0, 0.0);
        GuiTools.addComponent(inputPanel, gbl, this.dateInput, 1, 0, 2, 1, 0.0, 0.0);
        GuiTools.addComponent(inputPanel, gbl, new JLabel(String.valueOf(TextPool.getString("labelAmount")) + ":"), 0, 1, 1, 1, 0.0, 0.0);
        GuiTools.addComponent(inputPanel, gbl, this.inputPartialAmount, 1, 1, 1, 1, 1.0, 0.0);
        GuiTools.addComponent(inputPanel, gbl, new JLabel(sb.toString()), 2, 1, 1, 1, 0.0, 0.0);
        GuiTools.addComponent(inputPanel, gbl, new JLabel(TextPool.getString("labelDescriptionPartialPayment")), 0, 2, 1, 1, 0.0, 0.0);
        GuiTools.addComponent(inputPanel, gbl, this.inputDescriptionPartialPayment, 1, 2, 2, 1, 1.0, 0.0);
        GuiTools.addComponent(inputPanel, gbl, new JLabel(TextPool.getString("labelDescriptionRemainingPayment")), 0, 3, 1, 1, 0.0, 0.0);
        GuiTools.addComponent(inputPanel, gbl, this.inputDescriptionRemainingPayment, 1, 3, 2, 1, 1.0, 0.0);
        JPanel informationPanel = new JPanel(new BorderLayout());
        informationPanel.setBorder(BorderFactory.createTitledBorder(TextPool.getString("titleInformation")));
        JEditorPane informationDisplay = new JEditorPane("text/html", TextPool.getString("informationPartialPayment"));
        informationDisplay.setEditable(false);
        informationDisplay.setBackground(this.getBackground());
        informationDisplay.setCaretPosition(0);
        informationDisplay.setPreferredSize(new Dimension(300, informationDisplay.getPreferredSize().height));
        JScrollPane scroller = new JScrollPane(informationDisplay);
        scroller.setBorder(null);
        informationPanel.add("Center", scroller);
        this.partialPaymentPanel = new JSplitPane(1);
        this.partialPaymentPanel.setLeftComponent(inputPanel);
        this.partialPaymentPanel.setRightComponent(informationPanel);
        this.partialPaymentPanel.setOneTouchExpandable(true);
        this.setLayout(new BorderLayout());
        this.add("Center", this.partialPaymentPanel);
    }

    private void connectListeners() {
        this.dateInput.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Calendar calendar = PartialPaidReceiptPanel.this.dateInput.getCalendar();
                PartialPaidReceiptPanel.this.synchronizeDateInputWithOtherProviders(calendar);
            }
        });
        this.inputPartialAmount.getDocument().addDocumentListener(this.textFieldListener);
        this.inputDescriptionPartialPayment.getDocument().addDocumentListener(this.textFieldListener);
        this.inputDescriptionRemainingPayment.getDocument().addDocumentListener(this.textFieldListener);
    }

    private BigDecimal getPartialAmount() {
        BigDecimal partialAmount = null;
        try {
            partialAmount = new BigDecimal(this.inputPartialAmount.getText().replace(",", "."));
        }
        catch (Exception e) {
            partialAmount = Numbers.BIG_DECIMAL_ZERO;
        }
        return partialAmount;
    }

    private void enableActions() {
        BigDecimal partialAmount = this.getPartialAmount();
        this.okAction.setEnabled(partialAmount.compareTo(Numbers.BIG_DECIMAL_ZERO) > 0 && !this.inputDescriptionPartialPayment.getText().isEmpty() && !this.inputDescriptionRemainingPayment.getText().isEmpty());
    }

    private void updateAmounts() {
        BigDecimal partialAmount = this.getPartialAmount();
        ArrayList<Payment> newOriginalPaymentsChain = new ArrayList<Payment>(this.originalPaymentsChain.size());
        ArrayList<Payment> newRemainingPaymentsChain = new ArrayList<Payment>(this.originalPaymentsChain.size());
        for (Payment p : this.originalPaymentsChain) {
            int account = p.getAccount();
            BigDecimal taxPercent = p.getPercentTax();
            String taxKey = p.getTaxKey();
            String text = p.getText();
            BigDecimal paymentAmount = p.getAmountIncludingTax();
            BigDecimal newOriginalPaymentAmount = paymentAmount.multiply(partialAmount).divide(this.originalTotalAmount, 2, RoundingMode.HALF_UP);
            BigDecimal newRemainingPaymentAmount = paymentAmount.subtract(newOriginalPaymentAmount);
            Payment newOriginalPayment = PaymentFactory.createPaymentFromAmountIncludingTaxAndTaxPercent(account, newOriginalPaymentAmount, taxPercent, taxKey, text);
            newOriginalPaymentsChain.add(newOriginalPayment);
            Payment newRemainingPayment = PaymentFactory.createPaymentFromAmountIncludingTaxAndTaxPercent(account, newRemainingPaymentAmount, taxPercent, taxKey, text);
            newRemainingPaymentsChain.add(newRemainingPayment);
        }
        this.creatorOriginalReceipt.setPaymentsChain(newOriginalPaymentsChain);
        this.creatorRemainingPaymentReceipt.setPaymentsChain(newRemainingPaymentsChain);
        this.enableActions();
    }

    @Override
    public void setOkAction(Action okAction) {
        this.okAction = okAction;
    }

    public AbstractReceipt getNewOriginalReceipt() throws ReceiptDataException {
        this.updateAmounts();
        AbstractReceipt result = this.creatorOriginalReceipt.createYourReceiptNow();
        result.setReceiptDescription(this.inputDescriptionPartialPayment.getText());
        return result;
    }

    public AbstractReceipt getNewRemainingReceipt() throws ReceiptDataException {
        this.updateAmounts();
        AbstractReceipt result = this.creatorRemainingPaymentReceipt.createYourReceiptNow();
        result.setReceiptDescription(this.inputDescriptionRemainingPayment.getText());
        return result;
    }

    public void synchronizeDateInputWithOtherProviders(Calendar date) {
        this.creatorOriginalReceipt.setDateInputValue(date);
        this.creatorRemainingPaymentReceipt.setDateInputValue(date);
    }
}

