/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.receipt.gui;

import com.toedter.calendar.JDateChooser;
import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.data.SettingsManager;
import de.uwemock.eur.receipt.Payment;
import de.uwemock.eur.receipt.Receipt;
import de.uwemock.eur.receipt.ReceiptNumberListener;
import de.uwemock.eur.receipt.gui.ReceiptCreator;
import de.uwemock.eur.receipt.gui.ReceiptEditor;
import de.uwemock.eur.receipt.gui.SynchronizedDateInputProvider;
import de.uwemock.guitools.AbstractStandardDialogPanel;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.swing.Action;

public abstract class AbstractReceiptInput
extends AbstractStandardDialogPanel
implements ReceiptCreator,
ReceiptEditor,
ReceiptNumberListener,
SynchronizedDateInputProvider {
    private static Calendar lastDate = null;
    private Frame parentFrame;
    protected Action okAction;
    public AbstractReceiptInput nextReceiptInput;
    private ArrayList<SynchronizedDateInputProvider> dateInputs = new ArrayList();

    public Frame getParentFrame() {
        return this.parentFrame;
    }

    public void setParentFrame(Frame parentFrame) {
        this.parentFrame = parentFrame;
    }

    @Override
    public void setOkAction(Action okAction) {
        this.okAction = okAction;
    }

    public void addSynchronizedDateInputProvider(SynchronizedDateInputProvider provider) {
        if (!this.dateInputs.contains(provider)) {
            this.dateInputs.add(provider);
        }
    }

    public void removeSynchronizedDateInputProvider(SynchronizedDateInputProvider provider) {
        this.dateInputs.remove(provider);
    }

    public void synchronizeDateInputWithOtherProviders(Calendar date) {
        for (SynchronizedDateInputProvider provider : this.dateInputs) {
            if (provider == this) continue;
            provider.setDateInputValue(date);
        }
    }

    public void addReceiptInput(AbstractReceiptInput next) {
        if (this.nextReceiptInput == null) {
            this.nextReceiptInput = next;
        } else {
            this.nextReceiptInput.addReceiptInput(next);
        }
    }

    public AbstractReceiptInput getReceiptInputFor(Receipt r) {
        if (this.nextReceiptInput == null) {
            return null;
        }
        return this.nextReceiptInput.getReceiptInputFor(r);
    }

    public static Calendar getLastDate() {
        return lastDate;
    }

    public static void setLastDate(Calendar lastDate) {
        AbstractReceiptInput.lastDate = lastDate;
    }

    public void initDateInput(JDateChooser dateInput) {
        if (AbstractReceiptInput.getLastDate() == null) {
            Calendar today = Calendar.getInstance();
            today.set(1, DataCenter.getInstance().getBusinessYear());
            dateInput.setDate(today.getTime());
        } else {
            dateInput.setDate(AbstractReceiptInput.getLastDate().getTime());
        }
        Calendar minDate = Calendar.getInstance();
        minDate.set(DataCenter.getInstance().getBusinessYear(), 0, 1);
        Calendar maxDate = Calendar.getInstance();
        maxDate.set(DataCenter.getInstance().getBusinessYear(), 11, 31);
        dateInput.setSelectableDateRange(minDate.getTime(), maxDate.getTime());
        dateInput.setDateFormatString(SettingsManager.getInstance().getDateFormat().getFormatString());
    }

    abstract List<Payment> getPaymentsChain();

    abstract void setPaymentsChain(List<Payment> var1);

    abstract void setEditMode(boolean var1, boolean var2, boolean var3, boolean var4);
}

