/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.receipt.formatter;

import de.uwemock.eur.accounts.Account;
import de.uwemock.eur.data.LocalizationManager;
import de.uwemock.eur.receipt.Receipt;
import de.uwemock.eur.receipt.formatter.AbstractReceiptContentsFormatter;
import de.uwemock.htmltools.HtmlBodyElement;
import de.uwemock.htmltools.HtmlText;
import de.uwemock.tools.Numbers;
import java.math.BigDecimal;

public class ReceiptTextFormatter
extends AbstractReceiptContentsFormatter {
    private BigDecimal totalPaid = Numbers.BIG_DECIMAL_ZERO;
    private BigDecimal totalUnpaid = Numbers.BIG_DECIMAL_ZERO;

    public ReceiptTextFormatter(int id) {
        super(id);
    }

    public ReceiptTextFormatter(int id, Account account) {
        super(id, account);
    }

    @Override
    public String getFormattedReceiptContentsAsText(Receipt r) {
        return this.getFormattedReceiptContents(r, false);
    }

    @Override
    public HtmlBodyElement getFormattedReceiptContentsAsHtml(Receipt r) {
        return new HtmlText(this.getFormattedReceiptContents(r, true));
    }

    public String getFormattedReceiptContents(Receipt r, boolean addCurrency) {
        BigDecimal amount = (BigDecimal)r.getReceiptInfo(this.INFORMATION_ID);
        if (!r.isDeleted()) {
            if (r.isPaid()) {
                this.totalPaid = r.isIncomingReceipt() ? this.totalPaid.add(amount) : this.totalPaid.subtract(amount);
            } else {
                this.totalUnpaid = r.isIncomingReceipt() ? this.totalUnpaid.add(amount) : this.totalUnpaid.subtract(amount);
            }
        }
        StringBuilder buffer = new StringBuilder();
        if (r.isOutgoingReceipt()) {
            buffer.append('-');
        }
        buffer.append(LocalizationManager.amountToCurrencyString(amount, false));
        return buffer.toString();
    }

    public String getTotalPaid() {
        return this.getTotalPaid(false);
    }

    public String getTotalPaid(boolean addCurrency) {
        return LocalizationManager.amountToCurrencyString(this.totalPaid, addCurrency);
    }

    public String getTotalUnpaid() {
        return this.getTotalUnpaid(false);
    }

    public String getTotalUnpaid(boolean addCurrency) {
        return LocalizationManager.amountToCurrencyString(this.totalUnpaid, addCurrency);
    }

    public String getGrandTotal() {
        return this.getGrandTotal(false);
    }

    public String getGrandTotal(boolean addCurrency) {
        return LocalizationManager.amountToCurrencyString(this.totalUnpaid.add(this.totalPaid), addCurrency);
    }
}

