/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.receipt.formatter;

import de.uwemock.eur.data.LocalizationManager;
import de.uwemock.eur.depreciation.AbstractDepreciationStrategy;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.eur.receipt.Payment;
import de.uwemock.eur.receipt.Receipt;
import de.uwemock.eur.receipt.SplitReceipt;
import de.uwemock.eur.receipt.formatter.ReceiptContentsFormatter;
import de.uwemock.htmltools.HtmlBodyElement;
import de.uwemock.htmltools.HtmlContainer;
import de.uwemock.htmltools.HtmlFactory;
import de.uwemock.htmltools.HtmlHorizontalRule;
import de.uwemock.htmltools.HtmlTable;
import de.uwemock.htmltools.HtmlText;
import de.uwemock.htmltools.HtmlTools;
import java.util.Collection;

public class ReceiptDescriptionFormatter
implements ReceiptContentsFormatter {
    private static final String[] COLUMNS_PAYMENT_MINITABLE = TextPool.getArray("COLUMNS_PAYMENT_MINITABLE");

    @Override
    public HtmlBodyElement getFormattedReceiptContentsAsHtml(Receipt r) {
        Collection<Payment> payments;
        HtmlContainer htmlContainer = new HtmlContainer();
        htmlContainer.addHtmlElement(new HtmlText(r.getReceiptDescription()));
        if (r.hasDepreciationStrategy() && AbstractReceipt.showDepreciationStrategyInHtmlDescription) {
            AbstractDepreciationStrategy ds = (AbstractDepreciationStrategy)r.getDepreciationStrategy();
            htmlContainer.addHtmlElement(HtmlFactory.BR);
            htmlContainer.addHtmlElement(new HtmlHorizontalRule());
            htmlContainer.addHtmlElement(ds.getDepreciationTableAsHTML());
        }
        if (SplitReceipt.showAllPaymentsInHtmlDescription && (payments = r.getAllPayments()).size() > 1) {
            htmlContainer.addHtmlElement(HtmlFactory.BR);
            htmlContainer.addHtmlElement(new HtmlHorizontalRule());
            htmlContainer.addHtmlElement(ReceiptDescriptionFormatter.getPaymentsTableAsHTML(payments));
        }
        return htmlContainer;
    }

    @Override
    public String getFormattedReceiptContentsAsText(Receipt r) {
        return r.getReceiptDescription();
    }

    protected Object getReceiptInfo(Receipt r) {
        return null;
    }

    public static HtmlBodyElement getPaymentsTableAsHTML(Collection<Payment> payments) {
        HtmlTable paymentsTable = new HtmlTable();
        paymentsTable.addCssClass("minitable");
        paymentsTable.setCellspacing("0px");
        paymentsTable.setCellpadding("1px");
        paymentsTable.setRowAsHeader(0, true);
        int j = 0;
        while (j < 5) {
            paymentsTable.setContents(j, 0, HtmlTools.bold(COLUMNS_PAYMENT_MINITABLE[j]));
            paymentsTable.setAlign(j, 0, "center");
            switch (j) {
                case 0: {
                    paymentsTable.setCssClass(j, 0, "leftcell");
                    break;
                }
                case 4: {
                    paymentsTable.setCssClass(j, 0, "rightcell");
                    break;
                }
                default: {
                    paymentsTable.setCssClass(j, 0, "midcell");
                }
            }
            ++j;
        }
        int row = 1;
        for (Payment p : payments) {
            int j2 = 0;
            while (j2 < 5) {
                if (j2 > 0) {
                    paymentsTable.setAlign(j2, row, "right");
                }
                switch (j2) {
                    case 0: {
                        paymentsTable.setCssClass(j2, row, "leftcell");
                        break;
                    }
                    case 4: {
                        paymentsTable.setCssClass(j2, row, "rightcell");
                        break;
                    }
                    default: {
                        paymentsTable.setCssClass(j2, row, "midcell amount");
                    }
                }
                ++j2;
            }
            paymentsTable.setContents(0, row, Integer.toString(p.getAccount()));
            paymentsTable.setContents(1, row, "&nbsp;" + LocalizationManager.amountToCurrencyString(p.getAmountExcludingTax()));
            paymentsTable.setContents(2, row, "&nbsp;" + LocalizationManager.amountToCurrencyString(p.getAmountIncludingTax()));
            paymentsTable.setContents(3, row, "&nbsp;" + LocalizationManager.amountToCurrencyString(p.getAmountTax()));
            paymentsTable.setContents(4, row, "&nbsp;" + p.getPercentTax().toPlainString() + "%");
            ++row;
        }
        return paymentsTable;
    }
}

