/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.receipt.formatter;

import de.uwemock.eur.accounts.Account;
import de.uwemock.eur.data.LocalizationManager;
import de.uwemock.eur.receipt.Receipt;
import de.uwemock.eur.receipt.formatter.AbstractReceiptContentsFormatter;
import de.uwemock.htmltools.HtmlBodyElement;
import de.uwemock.htmltools.HtmlFactory;
import java.math.BigDecimal;

public class ReceiptAmountFormatter
extends AbstractReceiptContentsFormatter {
    private String cssClass;

    public ReceiptAmountFormatter(int id) {
        super(id);
    }

    public ReceiptAmountFormatter(int id, Account account) {
        super(id, account);
    }

    public ReceiptAmountFormatter(int id, String htmlClass) {
        this(id);
        this.cssClass = htmlClass;
    }

    public ReceiptAmountFormatter(int id, Account account, String htmlClass) {
        this(id, account);
        this.cssClass = htmlClass;
    }

    @Override
    public String getFormattedReceiptContentsAsText(Receipt r) {
        BigDecimal amount = this.getAmount(r);
        return LocalizationManager.amountToCurrencyString(amount, false);
    }

    @Override
    public HtmlBodyElement getFormattedReceiptContentsAsHtml(Receipt r) {
        BigDecimal amount = this.getAmount(r);
        String amountText = LocalizationManager.amountToCurrencyString(amount, true);
        return HtmlFactory.createHtmlBodyElement(null, null, this.cssClass, null, amountText);
    }

    private BigDecimal getAmount(Receipt r) {
        BigDecimal amount = (BigDecimal)this.getReceiptInfo(r);
        return amount;
    }
}

