/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.receipt.formatter;

import de.uwemock.eur.accounts.Account;
import de.uwemock.eur.receipt.Receipt;
import de.uwemock.eur.receipt.builder.ReceiptElementSummer;
import de.uwemock.eur.receipt.formatter.ReceiptContentsFormatter;
import java.math.BigDecimal;

public abstract class AbstractReceiptContentsFormatter
implements ReceiptContentsFormatter {
    protected final int INFORMATION_ID;
    protected final Account ACCOUNT;

    public AbstractReceiptContentsFormatter(int id) {
        this.INFORMATION_ID = id;
        this.ACCOUNT = null;
    }

    public AbstractReceiptContentsFormatter(int id, Account account) {
        this.INFORMATION_ID = id;
        this.ACCOUNT = account;
    }

    protected Object getReceiptInfo(Receipt r) {
        if (this.INFORMATION_ID == 6 || this.INFORMATION_ID == 5 || this.INFORMATION_ID == 7) {
            BigDecimal result;
            if (this.ACCOUNT != null) {
                ReceiptElementSummer summer = new ReceiptElementSummer(this.INFORMATION_ID);
                summer.setAccountToProcess(this.ACCOUNT);
                summer.processReceipt(r);
                result = summer.getTotal();
            } else {
                result = (BigDecimal)r.getReceiptInfo(this.INFORMATION_ID);
                if (r.isOutgoingReceipt()) {
                    result = result.negate();
                }
            }
            return result;
        }
        return r.getReceiptInfo(this.INFORMATION_ID);
    }
}

