/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.receipt.comparators;

import de.uwemock.eur.receipt.Receipt;
import de.uwemock.eur.receipt.comparators.ReceiptComparatorStrategy;
import de.uwemock.eur.receipt.comparators.ReceiptNumberComparator;
import java.util.Collection;

public class ReceiptComparator
extends ReceiptNumberComparator {
    private static final long serialVersionUID = 2757482699966027388L;
    public static final int COMPARE_NUMBER = 1;
    public static final int COMPARE_DATE = 2;
    public static final int COMPARE_ID = 3;
    public static final int COMPARE_ACCOUNT = 4;
    public static final int COMPARE_TEXT = 5;
    public static final int COMPARE_AMOUNT_INCL_TAX = 6;
    public static final int COMPARE_AMOUNT_EXCL_TAX = 7;
    public static final int COMPARE_AMOUNT_TAX = 8;
    private ReceiptComparatorStrategy strategy;
    private boolean descending = false;

    public ReceiptComparator(int strategyType) {
        if (strategyType <= 0 || strategyType > 8) {
            throw new IllegalArgumentException();
        }
        switch (strategyType) {
            case 1: {
                this.strategy = null;
                break;
            }
            case 2: {
                this.strategy = new ReceiptComparatorStrategy(){
                    private static final long serialVersionUID = -492443683572740033L;

                    @Override
                    public Object getReceiptElementToCompare(Receipt r) {
                        return r.getDate();
                    }
                };
                break;
            }
            case 3: {
                this.strategy = new ReceiptComparatorStrategy(){
                    private static final long serialVersionUID = -7524585641301776467L;

                    @Override
                    public Object getReceiptElementToCompare(Receipt r) {
                        return r.getId();
                    }
                };
                break;
            }
            case 4: {
                this.strategy = new ReceiptComparatorStrategy(){
                    private static final long serialVersionUID = -8445510445155425821L;

                    @Override
                    public Object getReceiptElementToCompare(Receipt r) {
                        Collection accounts = (Collection)r.getReceiptInfo(14);
                        return accounts.iterator().next();
                    }
                };
                break;
            }
            case 5: {
                this.strategy = new ReceiptComparatorStrategy(){
                    private static final long serialVersionUID = 7170924959559237025L;

                    @Override
                    public Object getReceiptElementToCompare(Receipt r) {
                        return r.getReceiptDescription();
                    }
                };
                break;
            }
            case 6: {
                this.strategy = new ReceiptComparatorStrategy(){
                    private static final long serialVersionUID = 4393179539615312969L;

                    @Override
                    public Object getReceiptElementToCompare(Receipt r) {
                        return r.getReceiptInfo(5);
                    }
                };
                break;
            }
            case 7: {
                this.strategy = new ReceiptComparatorStrategy(){
                    private static final long serialVersionUID = -7481098774685443809L;

                    @Override
                    public Object getReceiptElementToCompare(Receipt r) {
                        return r.getReceiptInfo(6);
                    }
                };
                break;
            }
            case 8: {
                this.strategy = new ReceiptComparatorStrategy(){
                    private static final long serialVersionUID = 4215273759005185379L;

                    @Override
                    public Object getReceiptElementToCompare(Receipt r) {
                        return r.getReceiptInfo(7);
                    }
                };
                break;
            }
            default: {
                this.strategy = null;
            }
        }
    }

    public ReceiptComparator(int strategyType, boolean descending) {
        this(strategyType);
        this.descending = descending;
    }

    @Override
    public int compare(Receipt o1, Receipt o2) {
        int res;
        if (this.strategy == null) {
            res = super.compare(o1, o2);
        } else {
            Object object1 = this.strategy.getReceiptElementToCompare(o1);
            Object object2 = this.strategy.getReceiptElementToCompare(o2);
            if (object1 instanceof Comparable && object2 instanceof Comparable) {
                Comparable c = (Comparable)object1;
                res = c.compareTo(object2);
            } else {
                res = object1.toString().compareTo(object2.toString());
            }
        }
        if (this.descending) {
            return -res;
        }
        return res;
    }
}

