/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.receipt.builder;

import de.uwemock.eur.receipt.Receipt;
import de.uwemock.eur.receipt.builder.ReceiptProcessor;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReceiptWalker {
    private final Collection<? extends Receipt> receiptsToProcess;
    private final List<ReceiptProcessor> receiptResultBuilders = new LinkedList<ReceiptProcessor>();

    public ReceiptWalker(Collection<? extends Receipt> receiptsToProcess) {
        this.receiptsToProcess = receiptsToProcess;
    }

    public void addReceiptProcessor(ReceiptProcessor builder) {
        this.receiptResultBuilders.add(builder);
    }

    public void removeReceiptResultBuilder(ReceiptProcessor builder) {
        this.receiptResultBuilders.remove(builder);
    }

    public void run() {
        Logger logger = Logger.getLogger(this.getClass().getName());
        boolean loggerIsLoggingFinest = logger.isLoggable(Level.FINEST);
        for (Receipt receipt : this.receiptsToProcess) {
            if (loggerIsLoggingFinest) {
                logger.finest("Processing receipt no. " + receipt.getNumber());
            }
            for (ReceiptProcessor builder : this.receiptResultBuilders) {
                builder.processReceipt(receipt);
            }
        }
    }
}

