/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.receipt.builder;

import de.uwemock.eur.accounts.Account;
import de.uwemock.eur.data.LocalizationManager;
import de.uwemock.eur.gui.JesIcons;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.receipt.Receipt;
import de.uwemock.eur.receipt.builder.HtmlResultBuilder;
import de.uwemock.eur.receipt.builder.ReceiptElementSummer;
import de.uwemock.eur.receipt.filter.ReceiptFilterNotDeleted;
import de.uwemock.eur.receipt.filter.ReceiptFilterPaid;
import de.uwemock.eur.receipt.formatter.ReceiptAccountNumberFormatter;
import de.uwemock.eur.receipt.formatter.ReceiptAmountFormatter;
import de.uwemock.eur.receipt.formatter.ReceiptContentsFormatter;
import de.uwemock.eur.receipt.formatter.ReceiptDescriptionFormatter;
import de.uwemock.eur.receipt.formatter.ReceiptElementFormatter;
import de.uwemock.eur.receipt.formatter.ReceiptStatusFormatter;
import de.uwemock.eur.receipt.formatter.ReceiptTaxPercentFormatter;
import de.uwemock.htmltools.CssStyleSheet;
import de.uwemock.htmltools.HtmlBodyElement;
import de.uwemock.htmltools.HtmlContainer;
import de.uwemock.htmltools.HtmlContext;
import de.uwemock.htmltools.HtmlImage;
import de.uwemock.htmltools.HtmlSimpleElement;
import de.uwemock.htmltools.HtmlTable;
import de.uwemock.htmltools.HtmlText;
import java.util.Arrays;

public class ReceiptTableBuilder
extends HtmlResultBuilder {
    private static final String ALIGN_LEFT = "left";
    private static final String ALIGN_RIGHT = "right";
    private static final int[] COLUMNS_TO_SHOW;
    private ReceiptContentsFormatter[] column_formatter;
    private final ReceiptElementSummer totalExcludingTaxSummer = new ReceiptElementSummer(6, "amount", new ReceiptFilterNotDeleted());
    private final ReceiptElementSummer totalIncludingTaxSummer = new ReceiptElementSummer(5, "amount", new ReceiptFilterNotDeleted());
    private final ReceiptElementSummer totalTaxSummer = new ReceiptElementSummer(7, "amount", new ReceiptFilterNotDeleted());
    private final ReceiptElementSummer paidExcludingTaxSummer = new ReceiptElementSummer(6, "amount", new ReceiptFilterNotDeleted(), new ReceiptFilterPaid());
    private final ReceiptElementSummer paidIncludingTaxSummer = new ReceiptElementSummer(5, "amount", new ReceiptFilterNotDeleted(), new ReceiptFilterPaid());
    private final ReceiptElementSummer paidTaxSummer = new ReceiptElementSummer(7, "amount", new ReceiptFilterNotDeleted(), new ReceiptFilterPaid());
    private final ReceiptElementSummer[] summers = new ReceiptElementSummer[]{this.totalExcludingTaxSummer, this.totalIncludingTaxSummer, this.totalTaxSummer, this.paidExcludingTaxSummer, this.paidIncludingTaxSummer, this.paidTaxSummer};
    private static final String[] COLUMN_ALIGN;
    private static final boolean[] COLUMN_NOWRAP;
    private HtmlTable htmlTable = new HtmlTable(this.html, true);
    private int row = 1;
    private boolean finalRowAdded = false;

    static {
        int[] nArray = new int[10];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 6;
        nArray[6] = 7;
        nArray[7] = 8;
        nArray[8] = 9;
        nArray[9] = 10;
        COLUMNS_TO_SHOW = nArray;
        COLUMN_ALIGN = new String[]{ALIGN_RIGHT, ALIGN_RIGHT, ALIGN_RIGHT, ALIGN_LEFT, ALIGN_LEFT, ALIGN_LEFT, ALIGN_RIGHT, ALIGN_RIGHT, ALIGN_RIGHT, ALIGN_RIGHT};
        boolean[] blArray = new boolean[10];
        blArray[6] = true;
        blArray[7] = true;
        blArray[8] = true;
        COLUMN_NOWRAP = blArray;
    }

    public ReceiptTableBuilder(HtmlContext html) {
        super(html);
        html.addStyleSheet(new CssStyleSheet("all", ".amount { font-family:monospace; }\n.totalAll { font-weight:bold; }\n.totalPaid { font-weight:bold; }\n.totalUnpaid { font-weight:bold; }\n.iconPaid { width:12px; height:12px; float:left; background-image:url(" + JesIcons.base64iconPaid + "); background-repeat:no-repeat; }\n" + ".iconUnpaid { width:12px; height:12px; float:left; background-image:url(" + JesIcons.base64iconUnpaid + "); background-repeat:no-repeat; }\n" + ".iconDeleted { width:12px; height:12px; float:left; background-image:url(" + JesIcons.base64iconDeleted + "); background-repeat:no-repeat; }\n" + ".iconAttachment { width:12px; height:12px; float:left; background-image:url(" + JesIcons.base64iconAttachment + "); background-repeat:no-repeat; }\n" + ".iconDepreciation { width:12px; height:12px; float:left; background-image:url(" + JesIcons.base64iconDepreciation + "); background-repeat:no-repeat; }\n" + ".iconEmpty { width:12px; height:12px; float:left; }"));
        html.addStyleSheet(new CssStyleSheet("print", ".iconPaid:after { content:url(" + JesIcons.base64iconPaid + "); }\n" + ".iconUnpaid:after { content:url(" + JesIcons.base64iconUnpaid + "); }\n" + ".iconDeleted:after { content:url(" + JesIcons.base64iconDeleted + "); }\n" + ".iconAttachment:after { content:url(" + JesIcons.base64iconAttachment + "); }\n" + ".iconDepreciation:after { content:url(" + JesIcons.base64iconDepreciation + "); }"));
        this.htmlTable.setBorder("1px solid black");
        this.htmlTable.setCellspacing("0px");
        this.htmlTable.setRowAsHeader(0, true);
        this.htmlTable.addCssClass("result");
        String[] COLUMNS_MAIN = TextPool.getArray("COLUMNS_MAIN");
        int i = 0;
        while (i < COLUMNS_TO_SHOW.length) {
            this.htmlTable.setContents(i, 0, COLUMNS_MAIN[COLUMNS_TO_SHOW[i]]);
            if (COLUMNS_TO_SHOW[i] == 6) {
                this.htmlTable.setContents(i, 0, new HtmlImage(JesIcons.base64iconInfo));
            }
            this.htmlTable.setHeadline(i, 0, true);
            ++i;
        }
        this.setupFormatters(null);
    }

    public ReceiptTableBuilder(HtmlContext html, Account accountFilter) {
        this(html);
        ReceiptElementSummer[] receiptElementSummerArray = this.summers;
        int n = this.summers.length;
        int n2 = 0;
        while (n2 < n) {
            ReceiptElementSummer summer = receiptElementSummerArray[n2];
            summer.setAccountToProcess(accountFilter);
            ++n2;
        }
        this.setupFormatters(accountFilter);
    }

    private void setupFormatters(Account accountFilter) {
        this.column_formatter = new ReceiptContentsFormatter[]{new ReceiptElementFormatter(1), new ReceiptElementFormatter(2), new ReceiptAccountNumberFormatter(), new ReceiptElementFormatter(3), new ReceiptDescriptionFormatter(), new ReceiptStatusFormatter(), new ReceiptAmountFormatter(9, accountFilter, "amount"), new ReceiptAmountFormatter(8, accountFilter, "amount"), new ReceiptAmountFormatter(10, accountFilter, "amount"), new ReceiptTaxPercentFormatter(", ")};
    }

    @Override
    public void processReceipt(Receipt r) {
        this.htmlTable.addRowCssClass(this.row, this.row % 2 == 0 ? "row_even" : "row_odd");
        this.htmlTable.addRowCssClass(this.row, r.isPaid() ? "paid" : "unpaid");
        if (r.isDeleted()) {
            this.htmlTable.addRowCssClass(this.row, "deleted");
        }
        int x = 0;
        while (x < COLUMNS_TO_SHOW.length) {
            HtmlBodyElement htmlContents = this.column_formatter[x].getFormattedReceiptContentsAsHtml(r);
            this.htmlTable.setAlign(x, this.row, COLUMN_ALIGN[x]);
            if (COLUMN_NOWRAP[x]) {
                this.htmlTable.setNoWrap(x, this.row, true);
            }
            HtmlContainer div = new HtmlContainer();
            div.addHtmlElement(htmlContents);
            div.addCssClass(r.isPaid() ? "paid" : "unpaid");
            if (r.isDeleted()) {
                div.addCssClass("deleted");
            }
            this.htmlTable.setContents(x, this.row, div);
            this.htmlTable.setVAlign(x, this.row, "top");
            ++x;
        }
        ReceiptElementSummer[] receiptElementSummerArray = this.summers;
        int n = this.summers.length;
        int n2 = 0;
        while (n2 < n) {
            ReceiptElementSummer summer = receiptElementSummerArray[n2];
            summer.processReceipt(r);
            ++n2;
        }
        ++this.row;
    }

    private void addFinalRow() {
        int[] nArray = new int[4];
        nArray[1] = 7;
        nArray[2] = 8;
        nArray[3] = 9;
        int[] TOTALS_COLUMNS = nArray;
        String[] rowClass = new String[]{"totalAll", "totalPaid", "totalUnpaid"};
        HtmlBodyElement[][] rowContents = new HtmlBodyElement[][]{{new HtmlText(TextPool.getString("htmlTextTotalAllReceipts")), this.totalExcludingTaxSummer.getTotalAsHtml(), this.totalIncludingTaxSummer.getTotalAsHtml(), this.totalTaxSummer.getTotalAsHtml()}, {new HtmlText(TextPool.getString("htmlTextTotalPaidReceipts")), this.paidExcludingTaxSummer.getTotalAsHtml(), this.paidIncludingTaxSummer.getTotalAsHtml(), this.paidTaxSummer.getTotalAsHtml()}, {new HtmlText(TextPool.getString("htmlTextTotalUnpaidReceipts")), new HtmlSimpleElement("span", null, "amount", null, LocalizationManager.amountToCurrencyString(this.totalExcludingTaxSummer.getTotal().subtract(this.paidExcludingTaxSummer.getTotal()))), new HtmlSimpleElement("span", null, "amount", null, LocalizationManager.amountToCurrencyString(this.totalIncludingTaxSummer.getTotal().subtract(this.paidIncludingTaxSummer.getTotal()))), new HtmlSimpleElement("span", null, "amount", null, LocalizationManager.amountToCurrencyString(this.totalTaxSummer.getTotal().subtract(this.paidTaxSummer.getTotal())))}};
        int row = 0;
        while (row < 3) {
            this.htmlTable.setRowAsFooter(this.row + row, true);
            this.htmlTable.setColspan(0, this.row + row, Arrays.binarySearch(COLUMNS_TO_SHOW, TOTALS_COLUMNS[1]));
            this.htmlTable.setAlign(0, this.row + row, ALIGN_RIGHT);
            this.htmlTable.setRowCssClass(this.row + row, rowClass[row]);
            int x = 0;
            while (x < TOTALS_COLUMNS.length) {
                this.htmlTable.setContents(x, this.row + row, rowContents[row][x]);
                this.htmlTable.setAlign(x, this.row + row, ALIGN_RIGHT);
                this.htmlTable.setNoWrap(x, this.row + row, true);
                ++x;
            }
            ++row;
        }
        this.finalRowAdded = true;
    }

    public HtmlTable getResult() {
        if (!this.finalRowAdded) {
            this.addFinalRow();
        }
        return this.htmlTable;
    }
}

