/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.receipt.builder;

import de.uwemock.eur.accounts.Account;
import de.uwemock.eur.receipt.Payment;
import de.uwemock.eur.receipt.Receipt;
import de.uwemock.eur.receipt.builder.AmountSummer;
import de.uwemock.eur.receipt.builder.ReceiptProcessor;
import de.uwemock.eur.receipt.filter.ReceiptFilter;
import de.uwemock.htmltools.HtmlBodyElement;
import java.math.BigDecimal;
import java.security.InvalidParameterException;
import java.util.Collection;
import java.util.Iterator;

public class ReceiptElementSummer
implements ReceiptProcessor {
    private final int ID;
    private final AmountSummer summer;
    private ReceiptFilter[] filters;
    private Account account;

    public ReceiptElementSummer(int id) {
        this.ID = id;
        this.summer = new AmountSummer();
    }

    public ReceiptElementSummer(int id, String cssClass) {
        this.ID = id;
        this.summer = new AmountSummer(cssClass);
    }

    public ReceiptElementSummer(int id, String cssClass, ReceiptFilter ... filters) {
        this(id, cssClass);
        this.filters = filters;
    }

    public void setAccountToProcess(Account account) {
        this.account = account;
    }

    @Override
    public void processReceipt(Receipt r) {
        if (this.filters != null) {
            ReceiptFilter[] receiptFilterArray = this.filters;
            int n = this.filters.length;
            int n2 = 0;
            while (n2 < n) {
                ReceiptFilter filter = receiptFilterArray[n2];
                if (!filter.useReceipt(r)) {
                    return;
                }
                ++n2;
            }
        }
        Collection<Payment> payments = r.getAllPayments();
        if (this.account != null) {
            int accountNumber = this.account.getAccountNumber();
            Iterator<Payment> i = payments.iterator();
            while (i.hasNext()) {
                Payment p = i.next();
                if (p.getAccount() == accountNumber) continue;
                i.remove();
            }
        }
        for (Payment p : payments) {
            BigDecimal amount = null;
            switch (this.ID) {
                case 6: {
                    amount = p.getAmountExcludingTax();
                    break;
                }
                case 5: {
                    amount = p.getAmountIncludingTax();
                    break;
                }
                case 7: {
                    amount = p.getAmountTax();
                }
            }
            if (amount == null) {
                throw new InvalidParameterException("Invalid ID passed to ReceiptElementSummer");
            }
            if (r.isIncomingReceipt()) {
                this.summer.add(amount);
            }
            if (!r.isOutgoingReceipt()) continue;
            this.summer.subtract(amount);
        }
    }

    public BigDecimal getTotal() {
        return this.summer.getTotal();
    }

    public String getTotalAsText(boolean addCurrency) {
        return this.summer.getTotalAsText(addCurrency);
    }

    public HtmlBodyElement getTotalAsHtml() {
        return this.summer.getTotalAsHtml();
    }
}

