/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.receipt.builder;

import de.uwemock.csvtools.CsvTable;
import de.uwemock.eur.accounts.Account;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.receipt.Receipt;
import de.uwemock.eur.receipt.builder.CsvResultBuilder;
import de.uwemock.eur.receipt.formatter.AbstractReceiptContentsFormatter;
import de.uwemock.eur.receipt.formatter.ReceiptAccountNumberFormatter;
import de.uwemock.eur.receipt.formatter.ReceiptElementFormatter;
import de.uwemock.eur.receipt.formatter.ReceiptTaxPercentFormatter;
import de.uwemock.eur.receipt.formatter.ReceiptTextFormatter;

public class CsvReceiptListBuilder
extends CsvResultBuilder {
    private static final int[] COLUMNS_TO_SHOW;
    private final AbstractReceiptContentsFormatter[] COLUMN_FORMATTER;
    private boolean showDeletedReceipts = true;
    private int row = 1;

    static {
        int[] nArray = new int[9];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 7;
        nArray[6] = 8;
        nArray[7] = 9;
        nArray[8] = 10;
        COLUMNS_TO_SHOW = nArray;
    }

    public CsvReceiptListBuilder(Account accountFilter) {
        String[] COLUMNS_MAIN = TextPool.getArray("COLUMNS_MAIN");
        int i = 0;
        while (i < COLUMNS_TO_SHOW.length) {
            this.csvTable.setContents(i, 0, COLUMNS_MAIN[COLUMNS_TO_SHOW[i]]);
            ++i;
        }
        this.COLUMN_FORMATTER = new AbstractReceiptContentsFormatter[]{new ReceiptElementFormatter(1), new ReceiptElementFormatter(2), new ReceiptAccountNumberFormatter(), new ReceiptElementFormatter(3), new ReceiptElementFormatter(13), new ReceiptTextFormatter(9, accountFilter), new ReceiptTextFormatter(8, accountFilter), new ReceiptTextFormatter(10, accountFilter), new ReceiptTaxPercentFormatter("; ")};
    }

    public CsvReceiptListBuilder(Account accountFilter, boolean showDeletedReceipts) {
        this(accountFilter);
        this.showDeletedReceipts = showDeletedReceipts;
    }

    @Override
    public void processReceipt(Receipt r) {
        if (!this.showDeletedReceipts && r.isDeleted()) {
            return;
        }
        int x = 0;
        while (x < COLUMNS_TO_SHOW.length) {
            String csvContents = this.COLUMN_FORMATTER[x].getFormattedReceiptContentsAsText(r);
            this.csvTable.setContents(x, this.row, csvContents);
            ++x;
        }
        ++this.row;
    }

    public CsvTable getResult() {
        return this.csvTable;
    }
}

