/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.receipt.builder;

import de.uwemock.eur.data.LocalizationManager;
import de.uwemock.htmltools.HtmlBodyElement;
import de.uwemock.htmltools.HtmlFactory;
import de.uwemock.tools.Numbers;
import java.math.BigDecimal;

public class AmountSummer {
    private BigDecimal total = Numbers.BIG_DECIMAL_ZERO;
    private String cssClass;

    public AmountSummer() {
    }

    public AmountSummer(String cssClass) {
        this.cssClass = cssClass;
    }

    public void add(BigDecimal amount) {
        this.total = this.total.add(amount);
    }

    public void subtract(BigDecimal amount) {
        this.total = this.total.subtract(amount);
    }

    public BigDecimal getTotal() {
        return this.total;
    }

    public String getTotalAsText(boolean addCurrency) {
        return LocalizationManager.amountToCurrencyString(this.total, addCurrency);
    }

    public HtmlBodyElement getTotalAsHtml() {
        return HtmlFactory.createHtmlBodyElement(null, null, this.cssClass, null, this.getTotalAsText(true));
    }
}

