/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.receipt;

import de.uwemock.datetools.Date;
import de.uwemock.eur.accounts.Account;
import de.uwemock.eur.data.Attachment;
import de.uwemock.eur.data.Constants;
import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.depreciation.DepreciationFactory;
import de.uwemock.eur.depreciation.DepreciationStrategy;
import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.eur.receipt.Payment;
import de.uwemock.tools.Numbers;
import de.uwemock.xmltools.XmlTools;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class SplitReceipt
extends AbstractReceipt {
    public static final String XML_RECEIPT_ATT_TYPE = "split";
    public static boolean showAllPaymentsInHtmlDescription = true;
    private ArrayList<Payment> payments = new ArrayList();
    private String text;
    private int accountType;

    protected SplitReceipt(int number, Date date, String id, List<Payment> v, String text) {
        for (Payment p : v) {
            this.addPayment(p);
        }
        this.text = text;
        this.setDate(date);
        this.setId(id);
        this.setNumber(number);
    }

    protected SplitReceipt(int number, Date date, String id, Payment[] a, String text) {
        Payment[] paymentArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            Payment p = paymentArray[n2];
            this.addPayment(p);
            ++n2;
        }
        this.text = text;
        this.setDate(date);
        this.setId(id);
        this.setNumber(number);
    }

    public void addPayment(Payment p) {
        this.payments.add(p);
        this.setChanged();
    }

    @Override
    public boolean addsToTax() {
        for (Payment p : this.payments) {
            if (p.getAmountTax().equals(Constants.ZERO)) continue;
            return true;
        }
        return false;
    }

    @Override
    public BigDecimal amountExcludingTaxAddedToAccount(int account) {
        BigDecimal result = Constants.ZERO;
        for (Payment p : this.payments) {
            if (p.getAccount() != account) continue;
            result = result.add(p.getAmountExcludingTax());
        }
        return result;
    }

    @Override
    public BigDecimal amountTaxAddedToAccount(int account) {
        BigDecimal result = Constants.ZERO;
        for (Payment p : this.payments) {
            if (p.getAccount() != account) continue;
            result = result.add(p.getAmountTax());
        }
        return result;
    }

    @Override
    public String getReceiptDescription() {
        return this.text;
    }

    @Override
    public void setReceiptDescription(String text) {
        this.text = text;
    }

    @Override
    public BigDecimal amountTotalTax() {
        BigDecimal result = Constants.ZERO;
        for (Payment p : this.payments) {
            result = result.add(p.getAmountTax());
        }
        return result;
    }

    @Override
    public BigDecimal amountTotalExcludingTax() {
        BigDecimal result = Constants.ZERO;
        for (Payment p : this.payments) {
            result = result.add(p.getAmountExcludingTax());
        }
        return result;
    }

    @Override
    public Collection<Integer> accountNumbersAddedTo() {
        Collection res = this.getAllAccountNumbers();
        return res;
    }

    @Override
    public BigDecimal amountAddedToTaxKey(String taxKey) {
        BigDecimal result = Constants.ZERO;
        for (Payment p : this.payments) {
            if (!p.getTaxKey().equals(taxKey)) continue;
            result = result.add(p.getAmountExcludingTax());
        }
        return result;
    }

    @Override
    public BigDecimal taxAddedToTaxKey(String taxKey) {
        BigDecimal result = Constants.ZERO;
        for (Payment p : this.payments) {
            if (!p.getTaxKey().equals(taxKey)) continue;
            result = result.add(p.getAmountTax());
        }
        return result;
    }

    @Override
    public Collection<String> taxKeysAddedTo() {
        TreeSet<String> result = new TreeSet<String>();
        for (Payment p : this.payments) {
            result.add(p.getTaxKey());
        }
        return result;
    }

    public Collection<Payment> getPayments() {
        return this.payments;
    }

    @Override
    public Collection<Payment> getAllPayments() {
        LinkedList<Payment> payments = new LinkedList<Payment>();
        payments.addAll(this.payments);
        return super.getAllPayments(payments);
    }

    @Override
    public Set<Integer> getAllAccountNumbers() {
        Collection accountNumbers = super.getAllAccountNumbers();
        for (Payment p : this.payments) {
            accountNumbers.add(p.getAccount());
        }
        return accountNumbers;
    }

    @Override
    public Object getReceiptInfo(int item) {
        switch (item) {
            case 1: {
                return this.getNumber();
            }
            case 2: {
                return this.getDate();
            }
            case 3: {
                return this.getId();
            }
            case 5: {
                return this.amountTotalExcludingTax().add(this.amountTotalTax());
            }
            case 6: {
                return this.amountTotalExcludingTax();
            }
            case 7: {
                return this.amountTotalTax();
            }
            case 8: {
                if (this.hasDepreciationStrategy()) {
                    return this.getSliceIncludingTax();
                }
                return this.amountTotalExcludingTax().add(this.amountTotalTax());
            }
            case 9: {
                if (this.hasDepreciationStrategy()) {
                    return this.getSliceExcludingTax();
                }
                return this.amountTotalExcludingTax();
            }
            case 10: {
                if (this.hasDepreciationStrategy()) {
                    return this.getSliceTax();
                }
                return this.amountTotalTax();
            }
            case 12: {
                TreeSet<String> taxkeys = new TreeSet<String>();
                for (Payment p : this.payments) {
                    taxkeys.add(p.getText());
                }
                return taxkeys;
            }
            case 11: {
                TreeSet<BigDecimal> taxes = new TreeSet<BigDecimal>();
                for (Payment p : this.payments) {
                    taxes.add(p.getPercentTax());
                }
                return taxes;
            }
            case 13: {
                return this.getReceiptDescription();
            }
            case 4: 
            case 14: {
                return this.accountNumbersAddedTo();
            }
            case 15: {
                return this.getAllPayments();
            }
        }
        return null;
    }

    public static boolean doShowAllPaymentsInHtmlDescriptionSet() {
        return showAllPaymentsInHtmlDescription;
    }

    public static void setShowAllPaymentsInHtmlDescription(boolean showAllPaymentsInHtmlDescription) {
        SplitReceipt.showAllPaymentsInHtmlDescription = showAllPaymentsInHtmlDescription;
    }

    @Override
    public void writeToXML(XMLStreamWriter writer) throws XMLStreamException {
        Logger logger = Logger.getLogger("de.uwemock.eur.SplitReceipt");
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Writing No. " + this.getNumber());
        }
        writer.writeStartElement("receipt");
        writer.writeAttribute("type", XML_RECEIPT_ATT_TYPE);
        if (this.isDeleted()) {
            writer.writeAttribute("deleted", "yes");
        }
        writer.writeAttribute("paid", this.isPaid() ? "yes" : "no");
        XmlTools.writeXmlElement(writer, "number", this.getNumber(), null);
        this.getDate().writeToXml(writer);
        XmlTools.writeXmlElement(writer, "id", this.getId(), null);
        XmlTools.writeXmlElement(writer, "description", this.getReceiptDescription(), null);
        for (Payment p : this.payments) {
            p.writeToXML(writer);
        }
        if (this.hasDepreciationStrategy()) {
            this.getDepreciationStrategy().writeToXml(writer);
        }
        this.writeAttachmentsToXml(writer);
        writer.writeEndElement();
    }

    public static SplitReceipt readFromXML(XMLStreamReader reader) throws XMLStreamException {
        Logger logger = Logger.getLogger("de.uwemock.eur.SplitReceipt");
        if (!XmlTools.isStartElement(reader, "receipt") || reader.getAttributeCount() == 0) {
            return null;
        }
        Map<String, String> atts = XmlTools.getAttributes(reader);
        String type = atts.get("type");
        if (type == null || !XML_RECEIPT_ATT_TYPE.equals(type)) {
            return null;
        }
        String deleted = atts.get("deleted");
        String paid = atts.get("paid");
        logger.finest("Split receipt confirmed by attribute");
        String receiptNumber = null;
        Date receiptDate = null;
        String receiptDesc = null;
        String receiptId = "";
        ArrayList<Payment> receiptPayments = new ArrayList<Payment>();
        DepreciationStrategy strategy = null;
        LinkedList<Attachment> attachments = new LinkedList<Attachment>();
        boolean isDeleted = "yes".equals(deleted);
        boolean isPaid = !"no".equals(paid);
        while (reader.hasNext()) {
            Attachment attachment;
            String depreciationType;
            Payment receiptPayment;
            reader.next();
            if (XmlTools.isEndElement(reader, "receipt")) break;
            if (XmlTools.isStartElement(reader, "date")) {
                receiptDate = Date.readFromXml(reader);
            }
            if (XmlTools.isStartElement(reader, "payment") && (receiptPayment = Payment.readFromXML(reader)) != null) {
                receiptPayments.add(receiptPayment);
            }
            if (XmlTools.isStartElement(reader, "number")) {
                receiptNumber = reader.getElementText();
            }
            if (XmlTools.isStartElement(reader, "id")) {
                receiptId = reader.getElementText();
            }
            if (XmlTools.isStartElement(reader, "description")) {
                receiptDesc = reader.getElementText();
            }
            if (XmlTools.isStartElement(reader, "depreciationplan") && (depreciationType = XmlTools.getOneSingleAttributeValue(reader, "type")) != null) {
                strategy = DepreciationFactory.readFromXml(reader, depreciationType);
            }
            if (!XmlTools.isStartElement(reader, "attachment") || (attachment = AbstractReceipt.readAttachmentFromXml(reader)) == null) continue;
            attachments.add(attachment);
        }
        if (receiptDate == null || receiptNumber == null || receiptDesc == null || receiptPayments.size() == 0) {
            String message = "Error reading receipt from XML: missing ";
            if (receiptDate == null) {
                message = String.valueOf(message) + "date ";
            }
            if (receiptNumber == null) {
                message = String.valueOf(message) + "number ";
            }
            if (receiptId == null) {
                message = String.valueOf(message) + "id ";
            }
            if (receiptPayments.size() == 0) {
                message = String.valueOf(message) + "payments";
            }
            logger.fine(message);
            return null;
        }
        SplitReceipt r = new SplitReceipt(Numbers.getIntFromString(receiptNumber, 0), receiptDate, receiptId, receiptPayments, receiptDesc);
        r.setDeleted(isDeleted);
        r.setPaid(isPaid);
        if (strategy != null) {
            r.setDepreciationStrategy(strategy);
            strategy.setReceipt(r);
        }
        for (Attachment attachment : attachments) {
            r.addAttachment(attachment);
        }
        return r;
    }

    public static boolean hasXmlTypeAttribute(String attribute) {
        return XML_RECEIPT_ATT_TYPE.equals(attribute);
    }

    private void putAccountType() {
        if (this.getPayments().size() > 0) {
            Iterator<Payment> i = this.getPayments().iterator();
            int accountNumber = i.next().getAccount();
            Account account = DataCenter.getInstance().getAccountList().getByAccountNumber(accountNumber);
            if (account == null) {
                Logger logger = Logger.getLogger(this.getClass().getName());
                logger.fine("Account number " + accountNumber + " can't be found - but is used by receipt no. " + this.getNumber());
                return;
            }
            this.accountType = account.getAccountType();
        }
    }

    @Override
    public boolean isIncomingReceipt() {
        if (this.accountType == 0) {
            this.putAccountType();
        }
        return (this.accountType & 2) > 0;
    }

    @Override
    public boolean isOutgoingReceipt() {
        if (this.accountType == 0) {
            this.putAccountType();
        }
        return (this.accountType & 1) > 0;
    }

    @Override
    public boolean isEditable() {
        return true;
    }
}

