/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.receipt;

import de.uwemock.datetools.Date;
import de.uwemock.eur.accounts.Account;
import de.uwemock.eur.data.Attachment;
import de.uwemock.eur.data.Constants;
import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.depreciation.DepreciationFactory;
import de.uwemock.eur.depreciation.DepreciationStrategy;
import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.eur.receipt.Payment;
import de.uwemock.eur.receipt.PaymentFactory;
import de.uwemock.tools.Numbers;
import de.uwemock.xmltools.XmlTools;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class SimpleReceipt
extends AbstractReceipt {
    Payment payment;
    private int accountType;
    public static final String XML_RECEIPT_ATT_TYPE = "simple";

    protected SimpleReceipt(int number, Date date, String id, int account, BigDecimal amountExcludingTax, BigDecimal amountTax, BigDecimal taxPercent, String taxKey, String text) {
        this.setNumber(number);
        this.setDate(date);
        this.setId(id);
        this.payment = PaymentFactory.createPaymentFromAmountExcludingTaxAndTaxAmount(account, amountExcludingTax, amountTax, taxPercent, taxKey, text);
    }

    protected SimpleReceipt(int number, Date date, String id, Payment payment) {
        this.setNumber(number);
        this.setDate(date);
        this.setId(id);
        this.payment = payment;
    }

    @Override
    public boolean addsToTax() {
        return !this.payment.getAmountTax().equals(Constants.ZERO);
    }

    @Override
    public Collection<Integer> accountNumbersAddedTo() {
        Collection result = this.getAllAccountNumbers();
        result.add(this.payment.getAccount());
        return result;
    }

    @Override
    public Collection<String> taxKeysAddedTo() {
        ArrayList<String> result = new ArrayList<String>(1);
        result.add(this.payment.getTaxKey());
        return result;
    }

    @Override
    public BigDecimal amountExcludingTaxAddedToAccount(int account) {
        if (this.getAccount() == account) {
            return this.getAmountExcludingTax();
        }
        return Constants.ZERO;
    }

    @Override
    public BigDecimal amountTaxAddedToAccount(int account) {
        if (this.getAccount() == account) {
            return this.getAmountTax();
        }
        return Constants.ZERO;
    }

    @Override
    public BigDecimal amountAddedToTaxKey(String taxKey) {
        if (this.payment.getTaxKey().equals(taxKey)) {
            return this.payment.getAmountExcludingTax();
        }
        return Constants.ZERO;
    }

    @Override
    public BigDecimal taxAddedToTaxKey(String taxKey) {
        if (this.payment.getTaxKey().equals(taxKey)) {
            return this.payment.getAmountTax();
        }
        return Constants.ZERO;
    }

    public BigDecimal getAmountExcludingTax() {
        return this.payment.getAmountExcludingTax();
    }

    public void setAmountExcludingTax(BigDecimal amountWithoutTax) {
        this.payment.setAmountExcludingTax(amountWithoutTax);
        this.setChanged();
    }

    public BigDecimal getAmountIncludingTax() {
        return this.payment.getAmountIncludingTax();
    }

    public int getAccount() {
        return this.payment.getAccount();
    }

    public void setAccount(int account) {
        this.payment.setAccount(account);
        this.setChanged();
    }

    public BigDecimal getAmountTax() {
        return this.payment.getAmountTax();
    }

    public BigDecimal getPercentTax() {
        return this.payment.getPercentTax();
    }

    public void setPercentTax(BigDecimal percentTax) {
        this.payment.setPercentTax(percentTax);
        this.setChanged();
    }

    @Override
    public String getReceiptDescription() {
        return this.payment.getText();
    }

    @Override
    public void setReceiptDescription(String text) {
        this.payment.setText(text);
        this.setChanged();
    }

    public void setTaxKey(String taxKey) {
        this.payment.setTaxKey(taxKey);
        this.setChanged();
    }

    protected Payment getPayment() {
        return this.payment;
    }

    protected void setPayment(Payment payment) {
        this.payment = payment;
        this.setChanged();
    }

    public String getTaxKey() {
        return this.payment.getTaxKey();
    }

    public String getTaxKey(int account) {
        if (this.payment.getAccount() == account) {
            return this.getTaxKey();
        }
        return null;
    }

    @Override
    public BigDecimal amountTotalTax() {
        return this.getAmountTax();
    }

    @Override
    public BigDecimal amountTotalExcludingTax() {
        return this.payment.getAmountExcludingTax();
    }

    @Override
    public Collection<Payment> getAllPayments() {
        LinkedList<Payment> payments = new LinkedList<Payment>();
        payments.add(this.getPayment());
        return super.getAllPayments(payments);
    }

    @Override
    public Set<Integer> getAllAccountNumbers() {
        Collection accountNumbers = super.getAllAccountNumbers();
        accountNumbers.add(this.payment.getAccount());
        return accountNumbers;
    }

    @Override
    public Object getReceiptInfo(int item) {
        switch (item) {
            case 1: {
                return this.getNumber();
            }
            case 2: {
                return this.getDate();
            }
            case 3: {
                return this.getId();
            }
            case 5: {
                return this.getAmountIncludingTax();
            }
            case 6: {
                return this.getAmountExcludingTax();
            }
            case 7: {
                return this.getAmountTax();
            }
            case 8: {
                if (this.hasDepreciationStrategy()) {
                    return this.getSliceIncludingTax();
                }
                return this.getAmountIncludingTax();
            }
            case 9: {
                if (this.hasDepreciationStrategy()) {
                    return this.getSliceExcludingTax();
                }
                return this.getAmountExcludingTax();
            }
            case 10: {
                if (this.hasDepreciationStrategy()) {
                    return this.getSliceTax();
                }
                return this.getAmountTax();
            }
            case 12: {
                return this.getTaxKey();
            }
            case 11: {
                TreeSet<BigDecimal> taxes = new TreeSet<BigDecimal>();
                taxes.add(this.getPercentTax());
                return taxes;
            }
            case 13: {
                return this.getReceiptDescription();
            }
            case 4: 
            case 14: {
                return this.accountNumbersAddedTo();
            }
            case 15: {
                Vector<Payment> v = new Vector<Payment>();
                v.add(this.getPayment());
                return v;
            }
        }
        return null;
    }

    @Override
    public void writeToXML(XMLStreamWriter writer) throws XMLStreamException {
        Logger logger = Logger.getLogger(this.getClass().getName());
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Writing No. " + this.getNumber());
        }
        writer.writeStartElement("receipt");
        writer.writeAttribute("type", XML_RECEIPT_ATT_TYPE);
        if (this.isDeleted()) {
            writer.writeAttribute("deleted", "yes");
        }
        writer.writeAttribute("paid", this.isPaid() ? "yes" : "no");
        XmlTools.writeXmlElement(writer, "number", this.getNumber(), null);
        this.getDate().writeToXml(writer);
        XmlTools.writeXmlElement(writer, "id", this.getId(), null);
        this.payment.writeToXML(writer);
        if (this.hasDepreciationStrategy()) {
            this.getDepreciationStrategy().writeToXml(writer);
        }
        this.writeAttachmentsToXml(writer);
        writer.writeEndElement();
    }

    public static SimpleReceipt readFromXML(XMLStreamReader reader) throws XMLStreamException {
        Logger logger = Logger.getLogger(SimpleReceipt.class.getName());
        if (!XmlTools.isStartElement(reader, "receipt") || reader.getAttributeCount() == 0) {
            return null;
        }
        Map<String, String> atts = XmlTools.getAttributes(reader);
        String type = atts.get("type");
        if (type == null || !XML_RECEIPT_ATT_TYPE.equals(type)) {
            return null;
        }
        String deleted = atts.get("deleted");
        String paid = atts.get("paid");
        logger.finest("Simple receipt confirmed by attribute");
        String receiptNumber = null;
        Date receiptDate = null;
        String receiptId = "";
        Payment receiptPayment = null;
        DepreciationStrategy strategy = null;
        LinkedList<Attachment> attachments = new LinkedList<Attachment>();
        boolean isDeleted = "yes".equals(deleted);
        boolean isPaid = !"no".equals(paid);
        while (reader.hasNext()) {
            Attachment attachment;
            String depreciationType;
            reader.next();
            if (XmlTools.isEndElement(reader, "receipt")) break;
            if (XmlTools.isStartElement(reader, "date")) {
                receiptDate = Date.readFromXml(reader);
            }
            if (XmlTools.isStartElement(reader, "payment")) {
                receiptPayment = Payment.readFromXML(reader);
            }
            if (XmlTools.isStartElement(reader, "number")) {
                receiptNumber = reader.getElementText();
            }
            if (XmlTools.isStartElement(reader, "id")) {
                receiptId = reader.getElementText();
            }
            if (XmlTools.isStartElement(reader, "depreciationplan") && (depreciationType = XmlTools.getOneSingleAttributeValue(reader, "type")) != null) {
                strategy = DepreciationFactory.readFromXml(reader, depreciationType);
            }
            if (!XmlTools.isStartElement(reader, "attachment") || (attachment = AbstractReceipt.readAttachmentFromXml(reader)) == null) continue;
            attachments.add(attachment);
        }
        if (receiptDate == null || receiptNumber == null || receiptId == null || receiptPayment == null) {
            String message = "Error reading receipt from XML: missing ";
            if (receiptDate == null) {
                message = String.valueOf(message) + "date ";
            }
            if (receiptNumber == null) {
                message = String.valueOf(message) + "number ";
            }
            if (receiptId == null) {
                message = String.valueOf(message) + "id ";
            }
            if (receiptPayment == null) {
                message = String.valueOf(message) + "payment";
            }
            logger.fine(message);
            return null;
        }
        SimpleReceipt r = new SimpleReceipt(Numbers.getIntFromString(receiptNumber, 0), receiptDate, receiptId, receiptPayment);
        r.setDeleted(isDeleted);
        r.setPaid(isPaid);
        if (strategy != null) {
            r.setDepreciationStrategy(strategy);
            strategy.setReceipt(r);
        }
        for (Attachment attachment : attachments) {
            r.addAttachment(attachment);
        }
        return r;
    }

    public static boolean hasXmlTypeAttribute(String attribute) {
        return XML_RECEIPT_ATT_TYPE.equals(attribute);
    }

    private void putAccountType() {
        Account account = DataCenter.getInstance().getAccountList().getByAccountNumber(this.getAccount());
        if (account == null) {
            Logger logger = Logger.getLogger(this.getClass().getName());
            logger.fine("Account number " + this.getAccount() + " can't be found - but is used by receipt no. " + this.getNumber());
            return;
        }
        this.accountType = account.getAccountType();
    }

    @Override
    public boolean isIncomingReceipt() {
        if (this.accountType == 0) {
            this.putAccountType();
        }
        return (this.accountType & 2) > 0;
    }

    @Override
    public boolean isOutgoingReceipt() {
        if (this.accountType == 0) {
            this.putAccountType();
        }
        return (this.accountType & 1) > 0;
    }

    @Override
    public boolean isEditable() {
        return true;
    }
}

