/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.receipt;

import de.uwemock.eur.receipt.ReceiptNumberListener;
import java.util.ArrayList;

public class ReceiptNumberManager {
    private static ReceiptNumberManager instance;
    private int currentNumber;
    private ArrayList<ReceiptNumberListener> receiptNumberListener = new ArrayList();

    private ReceiptNumberManager() {
    }

    public static ReceiptNumberManager getInstance() {
        if (instance == null) {
            instance = new ReceiptNumberManager();
        }
        return instance;
    }

    public int getNextReceiptNumber() {
        return this.currentNumber + 1;
    }

    public void setReceiptNumberUsed(int number) {
        if (number > this.currentNumber) {
            this.currentNumber = number;
        }
        this.fireReceiptNumberChanged(this.currentNumber + 1);
    }

    public void reset() {
        this.currentNumber = 0;
    }

    public void addReceiptNumberListener(ReceiptNumberListener l) {
        this.receiptNumberListener.add(l);
    }

    public void removeReceiptNumberListener(ReceiptNumberListener l) {
        this.receiptNumberListener.remove(l);
    }

    public void fireReceiptNumberChanged(int newNumber) {
        for (ReceiptNumberListener l : this.receiptNumberListener) {
            l.setCurrentReceiptNumber(newNumber);
        }
    }
}

