/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.receipt;

import de.uwemock.eur.data.Attachment;
import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.eur.receipt.DataChangeListener;
import de.uwemock.eur.receipt.DepreciationPool;
import de.uwemock.eur.receipt.PoolManager;
import de.uwemock.eur.receipt.ReceiptContainer;
import de.uwemock.eur.receipt.ReceiptFactory;
import de.uwemock.eur.receipt.ReceiptGroup;
import de.uwemock.eur.receipt.ReceiptGroupListener;
import de.uwemock.eur.receipt.ReceiptNumberManager;
import de.uwemock.xmltools.XmlTools;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class ReceiptGroupManager
implements ReceiptGroupListener {
    public static final String XML_RECEIPTGROUPS_GROUPS = "receiptgroups";
    private static volatile ReceiptGroupManager instance;
    private Map<Integer, ReceiptGroup> groupsByMonth = new HashMap<Integer, ReceiptGroup>();
    private Map<String, ReceiptGroup> groupsByName = new HashMap<String, ReceiptGroup>();
    private ReceiptGroup allReceipts;
    private ArrayList<DataChangeListener> dataChangeListener = new ArrayList();

    private ReceiptGroupManager() {
        int i = 1;
        while (i < 13) {
            ReceiptContainer month = new ReceiptContainer();
            month.addReceiptGroupListener(this);
            this.groupsByMonth.put(i, month);
            ++i;
        }
        this.allReceipts = new ReceiptContainer();
        this.allReceipts.addReceiptGroupListener(this);
    }

    public void resetCollections() {
        int i = 1;
        while (i < 13) {
            this.groupsByMonth.get(i).clear();
            ++i;
        }
        this.allReceipts.clear();
        ReceiptNumberManager.getInstance().reset();
    }

    public static ReceiptGroupManager getInstance() {
        if (instance == null) {
            instance = new ReceiptGroupManager();
        }
        return instance;
    }

    public ReceiptGroup getReceiptGroup(int month) {
        return this.groupsByMonth.get(month);
    }

    public ReceiptGroup getReceiptGroup(String name) {
        return this.groupsByName.get(name);
    }

    public ReceiptGroup getAllReceiptsGroup() {
        return this.allReceipts;
    }

    @Override
    public void receiptGroupChanged() {
        this.fireDataChanged();
    }

    public void add(AbstractReceipt r) {
        ReceiptGroup monthGroup = this.groupsByMonth.get(r.getDate().getMonth());
        if (!monthGroup.contains(r)) {
            monthGroup.add(r);
        }
        if (!this.allReceipts.contains(r)) {
            this.allReceipts.add(r);
        }
        this.fireDataChanged();
    }

    public void insert(AbstractReceipt r) {
        ReceiptGroup monthGroup = this.groupsByMonth.get(r.getDate().getMonth());
        if (!monthGroup.contains(r)) {
            monthGroup.insert(r);
        }
        if (!this.allReceipts.contains(r)) {
            this.allReceipts.insert(r);
        }
        this.fireDataChanged();
    }

    public void add(AbstractReceipt r, String groupName) {
        ReceiptGroup group;
        this.add(r);
        if (this.groupsByName.containsKey(groupName)) {
            group = this.groupsByName.get(groupName);
        } else {
            group = new ReceiptContainer();
            this.groupsByName.put(groupName, group);
        }
        group.add(r);
    }

    public void add(Integer receiptNumber, String groupName) {
        AbstractReceipt r = this.allReceipts.getByNumber(receiptNumber);
        this.add(r, groupName);
    }

    public void remove(AbstractReceipt r) {
        ReceiptGroup monthGroup = this.groupsByMonth.get(r.getDate().getMonth());
        if (monthGroup.contains(r)) {
            monthGroup.remove(r);
        }
        if (this.allReceipts.contains(r)) {
            this.allReceipts.remove(r);
        }
        for (ReceiptGroup group : this.groupsByName.values()) {
            if (!group.contains(r)) continue;
            group.remove(r);
        }
        this.fireDataChanged();
    }

    void remove(AbstractReceipt r, String groupName) {
        if (this.groupsByName.containsKey(groupName)) {
            ReceiptGroup group = this.groupsByName.get(groupName);
            group.remove(r);
        }
    }

    public AbstractReceipt getReceiptByReceiptNumber(int receiptNumber) {
        return this.allReceipts.getByNumber(receiptNumber);
    }

    public void removeFromGroup(AbstractReceipt r, String groupName) {
        ReceiptGroup group = this.groupsByName.get(groupName);
        if (group != null) {
            group.remove(r);
        }
        this.fireDataChanged();
    }

    public List<ReceiptGroup> getGroups(AbstractReceipt r) {
        ArrayList<ReceiptGroup> result = new ArrayList<ReceiptGroup>();
        for (ReceiptGroup group : this.groupsByName.values()) {
            if (!group.contains(r)) continue;
            result.add(group);
        }
        return result;
    }

    public List<String> getGroupNames(AbstractReceipt r) {
        ArrayList<String> result = new ArrayList<String>();
        for (String group : this.groupsByName.keySet()) {
            if (!this.groupsByName.get(group).contains(r)) continue;
            result.add(group);
        }
        return result;
    }

    public void replace(AbstractReceipt oldReceipt, AbstractReceipt newReceipt) {
        Logger logger = Logger.getLogger(this.getClass().getName());
        boolean loggerIsLoggingFinest = logger.isLoggable(Level.FINEST);
        logger.fine("Replacing a receipt");
        if (loggerIsLoggingFinest) {
            logger.finest("Old reference is " + oldReceipt);
        }
        if (oldReceipt == null) {
            return;
        }
        if (loggerIsLoggingFinest) {
            logger.finest("About to replace receipt no. " + oldReceipt.getNumber());
        }
        if (oldReceipt.hasDepreciationStrategy()) {
            newReceipt.setDepreciationStrategy(oldReceipt.getDepreciationStrategy());
        }
        if (oldReceipt.hasAttachments()) {
            List<Attachment> attachments = oldReceipt.getAttachments();
            for (Attachment a : attachments) {
                newReceipt.addAttachment(a);
            }
            oldReceipt.deleteAllAttachments();
        }
        if (this.allReceipts.contains(oldReceipt)) {
            logger.finest("Receipt is in non-pool area.");
            int oldMonth = oldReceipt.getDate().getMonth();
            if (loggerIsLoggingFinest) {
                logger.finest("Removing from month no. " + oldMonth);
            }
            this.groupsByMonth.get(oldMonth).remove(oldReceipt);
            logger.finest("Remove receipt in year group...");
            this.allReceipts.remove(oldReceipt);
            this.insert(newReceipt);
        } else {
            logger.finest("Receipt is in pool area.");
            int year = oldReceipt.getDate().getYear();
            DepreciationPool pool = PoolManager.getInstance().getDepreciationPoolForYear(year);
            if (pool != null && pool.contains(oldReceipt)) {
                if (loggerIsLoggingFinest) {
                    logger.finest("Old receipt found, removing." + oldReceipt.getReceiptDescription());
                }
                pool.remove(oldReceipt);
                logger.finest("Inserting new receipt.");
                PoolManager.getInstance().insert(newReceipt);
            }
        }
        for (ReceiptGroup group : this.groupsByName.values()) {
            if (!group.contains(oldReceipt)) continue;
            group.remove(oldReceipt);
            group.insert(newReceipt);
        }
        this.fireDataChanged();
    }

    public void moveReceiptToPool(AbstractReceipt r) {
        if (r == null || PoolManager.getInstance().contains(r)) {
            return;
        }
        int month = r.getDate().getMonth();
        this.groupsByMonth.get(month).remove(r);
        this.allReceipts.remove(r);
        PoolManager.getInstance().getCurrentDepreciationPool().insert(r);
        this.fireDataChanged();
    }

    public void removeReceiptFromPool(AbstractReceipt r) {
        if (r == null || !PoolManager.getInstance().getCurrentDepreciationPool().contains(r)) {
            return;
        }
        PoolManager.getInstance().getCurrentDepreciationPool().remove(r);
        int month = r.getDate().getMonth();
        this.groupsByMonth.get(month).insert(r);
        this.allReceipts.add(r);
        this.fireDataChanged();
    }

    public void startBulkInsert() {
        Logger logger = Logger.getLogger(this.getClass().getName());
        logger.fine("Starting bulk inserting process.");
        int month = 1;
        while (month <= 12) {
            this.groupsByMonth.get(month).setReceiptGroupListenerNotification(false);
            ++month;
        }
        this.allReceipts.setReceiptGroupListenerNotification(false);
        for (String groupName : this.groupsByName.keySet()) {
            this.groupsByName.get(groupName).setReceiptGroupListenerNotification(false);
        }
    }

    public void endBulkInsert() {
        Logger logger = Logger.getLogger(this.getClass().getName());
        logger.fine("Ending bulk inserting process.");
        int month = 1;
        while (month <= 12) {
            ReceiptGroup group = this.groupsByMonth.get(month);
            group.setReceiptGroupListenerNotification(true);
            group.update(null, null);
            ++month;
        }
        this.allReceipts.setReceiptGroupListenerNotification(true);
        this.allReceipts.update(null, null);
        for (String groupName : this.groupsByName.keySet()) {
            ReceiptGroup group = this.groupsByName.get(groupName);
            group.setReceiptGroupListenerNotification(true);
            group.update(null, null);
        }
    }

    public void recountReceiptNumber() {
        ReceiptNumberManager receiptNumberManager = ReceiptNumberManager.getInstance();
        receiptNumberManager.reset();
        for (AbstractReceipt r : this.allReceipts.getReceiptList()) {
            receiptNumberManager.setReceiptNumberUsed(r.getNumber());
        }
        for (ReceiptGroup group : PoolManager.getInstance().getReceiptGroupList()) {
            for (AbstractReceipt r : group.getReceiptList()) {
                receiptNumberManager.setReceiptNumberUsed(r.getNumber());
            }
        }
    }

    public int getReceiptCount() {
        return this.allReceipts.size();
    }

    public int getReceiptCount(int month) {
        return this.groupsByMonth.get(month - 1).size();
    }

    public List<AbstractReceipt> getReceiptCollectionByTimeFrame(int timeFrame) {
        if (timeFrame >= 1 && timeFrame <= 12) {
            List<AbstractReceipt> result = this.groupsByMonth.get(timeFrame).getReceiptList();
            return result;
        }
        if (timeFrame == 41) {
            List<AbstractReceipt> result = this.groupsByMonth.get(1).getReceiptList();
            result.addAll(this.groupsByMonth.get(2).getReceiptList());
            result.addAll(this.groupsByMonth.get(3).getReceiptList());
            return result;
        }
        if (timeFrame == 42) {
            List<AbstractReceipt> result = this.groupsByMonth.get(4).getReceiptList();
            result.addAll(this.groupsByMonth.get(5).getReceiptList());
            result.addAll(this.groupsByMonth.get(6).getReceiptList());
            return result;
        }
        if (timeFrame == 43) {
            List<AbstractReceipt> result = this.groupsByMonth.get(7).getReceiptList();
            result.addAll(this.groupsByMonth.get(8).getReceiptList());
            result.addAll(this.groupsByMonth.get(9).getReceiptList());
            return result;
        }
        if (timeFrame == 44) {
            List<AbstractReceipt> result = this.groupsByMonth.get(10).getReceiptList();
            result.addAll(this.groupsByMonth.get(11).getReceiptList());
            result.addAll(this.groupsByMonth.get(12).getReceiptList());
            return result;
        }
        if (timeFrame == 100) {
            return this.allReceipts.getReceiptList();
        }
        return null;
    }

    public void addDataChangeListener(DataChangeListener l) {
        this.dataChangeListener.add(l);
    }

    public void removeDataChangeListener(DataChangeListener l) {
        this.dataChangeListener.remove(l);
    }

    public void fireDataChanged() {
        for (DataChangeListener l : this.dataChangeListener) {
            l.dataChanged();
        }
    }

    public void writeToXML(XMLStreamWriter writer) throws XMLStreamException {
        this.allReceipts.writeToXML(writer);
        writer.writeStartElement(XML_RECEIPTGROUPS_GROUPS);
        for (String groupName : this.groupsByName.keySet()) {
            ReceiptGroup group = this.groupsByName.get(groupName);
            group.writeGroupToXML(writer, groupName);
        }
        writer.writeEndElement();
    }

    public static LinkedList<AbstractReceipt> readFromXML(XMLStreamReader reader) throws XMLStreamException {
        Logger logger = Logger.getLogger("de.uwemock.eur.receipt.ReceiptGroupManager");
        LinkedList<AbstractReceipt> result = new LinkedList<AbstractReceipt>();
        while (!reader.isEndElement() || !reader.getName().toString().equals("receipts")) {
            if (reader.isStartElement() && reader.hasName() && reader.getName().toString().equals("receipt")) {
                AbstractReceipt r;
                logger.finer("-> Found a receipt");
                String type = XmlTools.getOneSingleAttributeValue(reader, "type");
                if (type != null && (r = ReceiptFactory.readFromXml(reader, type)) != null) {
                    result.add(r);
                }
            }
            reader.next();
        }
        return result;
    }

    public static Map<String, LinkedList<Integer>> readGroupsFromXML(XMLStreamReader reader) throws XMLStreamException {
        Logger logger = Logger.getLogger("de.uwemock.eur.receipt.ReceiptGroupManager");
        HashMap<String, LinkedList<Integer>> result = new HashMap<String, LinkedList<Integer>>();
        while (!reader.isEndElement() || !reader.getName().toString().equals(XML_RECEIPTGROUPS_GROUPS)) {
            if (reader.isStartElement() && reader.hasName() && reader.getName().toString().equals("group")) {
                LinkedList<Integer> itemsList;
                logger.finer("-> Found a receipt group");
                String groupName = XmlTools.getOneSingleAttributeValue(reader, "name");
                if (groupName != null && (itemsList = ReceiptContainer.readGroupItemsFromXML(reader)) != null) {
                    result.put(groupName, itemsList);
                }
            }
            reader.next();
        }
        return result;
    }

    public Collection<Integer> getAllAccounts() {
        return this.allReceipts.getAllAccounts();
    }
}

