/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.receipt;

import de.uwemock.datetools.Date;
import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.eur.receipt.OldDepreciationPool;
import de.uwemock.eur.receipt.Payment;
import de.uwemock.eur.receipt.ReceiptCreationException;
import de.uwemock.eur.receipt.SimpleReceipt;
import de.uwemock.eur.receipt.SplitReceipt;
import de.uwemock.tools.LoggingManager;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class ReceiptFactory {
    private static Class[] knownReceiptTypes = new Class[]{SimpleReceipt.class, SplitReceipt.class, OldDepreciationPool.class};

    private ReceiptFactory() {
    }

    public static SimpleReceipt createSimpleReceipt(int number, Date date, String id, int account, BigDecimal amountWithoutTax, BigDecimal amountTax, BigDecimal percentTax, String keyTax, String text) {
        SimpleReceipt r = new SimpleReceipt(number, date, id, account, amountWithoutTax, amountTax, percentTax, keyTax, text);
        r.addObserver(DataCenter.getInstance());
        return r;
    }

    public static SimpleReceipt createSimpleReceipt(String number, Date date, String id, String account, String amountWithoutTax, String amountTax, String percentTax, String keyTax, String text) throws ReceiptCreationException {
        try {
            SimpleReceipt r = new SimpleReceipt(Integer.parseInt(number), date, id, Integer.parseInt(account), new BigDecimal(amountWithoutTax).setScale(2, RoundingMode.HALF_EVEN), new BigDecimal(amountTax).setScale(2, RoundingMode.HALF_EVEN), new BigDecimal(percentTax).setScale(2, RoundingMode.HALF_EVEN), keyTax, text);
            r.addObserver(DataCenter.getInstance());
            return r;
        }
        catch (NumberFormatException e) {
            throw new ReceiptCreationException(TextPool.getString("msgInvalidAmount"));
        }
    }

    public static SplitReceipt createSplitReceipt(int number, Date date, String id, List<Payment> payments, String text) {
        SplitReceipt r = new SplitReceipt(number, date, id, payments, text);
        r.addObserver(DataCenter.getInstance());
        return r;
    }

    public static SplitReceipt createSplitReceipt(int number, Date date, String id, Payment[] payments, String text) {
        SplitReceipt r = new SplitReceipt(number, date, id, payments, text);
        r.addObserver(DataCenter.getInstance());
        return r;
    }

    public static SplitReceipt createSplitReceipt(String number, Date date, String id, List<Payment> payments, String text) throws ReceiptCreationException {
        try {
            SplitReceipt r = new SplitReceipt(Integer.parseInt(number), date, id, payments, text);
            r.addObserver(DataCenter.getInstance());
            return r;
        }
        catch (NumberFormatException e) {
            throw new ReceiptCreationException(TextPool.getString("msgInvalidAmount"));
        }
    }

    public static SplitReceipt createSplitReceipt(String number, Date date, String id, Payment[] payments, String text) throws ReceiptCreationException {
        try {
            SplitReceipt r = new SplitReceipt(Integer.parseInt(number), date, id, payments, text);
            r.addObserver(DataCenter.getInstance());
            return r;
        }
        catch (NumberFormatException e) {
            throw new ReceiptCreationException(TextPool.getString("msgInvalidAmount"));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AbstractReceipt readFromXml(XMLStreamReader reader, String type) throws XMLStreamException {
        Logger logger = Logger.getLogger(ReceiptFactory.class.getName());
        Class[] classArray = knownReceiptTypes;
        int n = knownReceiptTypes.length;
        int n2 = 0;
        while (n2 < n) {
            block13: {
                Class receiptClass = classArray[n2];
                Method hasXmlTypeAttribute = null;
                try {
                    hasXmlTypeAttribute = receiptClass.getMethod("hasXmlTypeAttribute", String.class);
                }
                catch (SecurityException e) {
                    LoggingManager.logException(ReceiptFactory.class, e);
                }
                catch (NoSuchMethodException e) {
                    logger.severe("Class " + receiptClass.getName() + " has no hasXmlTypeAttribute() method!");
                }
                if (hasXmlTypeAttribute != null) {
                    try {
                        Boolean isRightClass = (Boolean)hasXmlTypeAttribute.invoke(null, type);
                        if (!isRightClass.booleanValue()) break block13;
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer("-> -> a receipt of class " + receiptClass.getName());
                        }
                        Method readFromXML = null;
                        try {
                            readFromXML = receiptClass.getMethod("readFromXML", XMLStreamReader.class);
                            return (AbstractReceipt)readFromXML.invoke(null, reader);
                        }
                        catch (SecurityException e) {
                            LoggingManager.logException(ReceiptFactory.class, e);
                            return null;
                        }
                        catch (NoSuchMethodException e) {
                            logger.severe("Class " + receiptClass.getName() + " has no suitable readFromXML() method!");
                            return null;
                        }
                    }
                    catch (InvocationTargetException e) {
                        Throwable eTarget = e.getTargetException();
                        eTarget.printStackTrace();
                        LoggingManager.logException(ReceiptFactory.class, eTarget);
                        if (eTarget instanceof XMLStreamException) {
                            throw (XMLStreamException)eTarget;
                        }
                    }
                    catch (Exception e) {
                        LoggingManager.logException(ReceiptFactory.class, e);
                    }
                }
            }
            ++n2;
        }
        return null;
    }
}

