/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.receipt;

import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.eur.receipt.Receipt;
import de.uwemock.eur.receipt.ReceiptFactory;
import de.uwemock.eur.receipt.ReceiptGroup;
import de.uwemock.eur.receipt.ReceiptGroupListener;
import de.uwemock.eur.receipt.ReceiptNumberManager;
import de.uwemock.xmltools.XmlTools;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class ReceiptContainer
implements ReceiptGroup,
Observer {
    public static final String XML_RECEIPTS_RECEIPTS = "receipts";
    public static final String XML_GROUP_GROUP = "group";
    public static final String XML_GROUP_NAME = "name";
    public static final String XML_GROUP_ITEM = "item";
    private static final int INITIAL_LIST_SIZE = 1024;
    private String name;
    private ArrayList<AbstractReceipt> receipts = new ArrayList(1024);
    private Map<Integer, AbstractReceipt> receiptsByNumber = new HashMap<Integer, AbstractReceipt>(1024);
    private ArrayList<ReceiptGroupListener> receiptGroupListener = new ArrayList();
    private boolean listenerNotificationAllowed = true;

    @Override
    public void setDisplayName(String name) {
        this.name = name;
    }

    @Override
    public void add(AbstractReceipt r) {
        this.receipts.add(r);
        this.receiptsByNumber.put(r.getNumber(), r);
        ReceiptNumberManager.getInstance().setReceiptNumberUsed(r.getNumber());
        r.addObserver(this);
        this.notifyListeners();
    }

    @Override
    public void insert(AbstractReceipt r) {
        int newReceiptNumber = r.getNumber();
        int i = 0;
        while (i < this.receipts.size() && newReceiptNumber >= this.receipts.get(i).getNumber()) {
            ++i;
        }
        this.receipts.add(i, r);
        this.receiptsByNumber.put(r.getNumber(), r);
        ReceiptNumberManager.getInstance().setReceiptNumberUsed(r.getNumber());
        r.addObserver(this);
        this.notifyListeners();
    }

    @Override
    public void remove(AbstractReceipt r) {
        this.receipts.remove(r);
        this.receiptsByNumber.remove(r.getNumber());
        r.deleteObserver(this);
        this.notifyListeners();
    }

    public void removeAll() {
        for (AbstractReceipt r : this.receipts) {
            r.deleteObserver(this);
        }
        this.receipts.clear();
        this.receiptsByNumber.clear();
        this.notifyListeners();
    }

    @Override
    public List<AbstractReceipt> getReceiptList() {
        return new ArrayList<AbstractReceipt>(this.receipts);
    }

    @Override
    public int size() {
        return this.receipts.size();
    }

    @Override
    public AbstractReceipt get(int index) {
        return this.receipts.get(index);
    }

    @Override
    public AbstractReceipt getByNumber(int number) {
        return this.receiptsByNumber.get(number);
    }

    @Override
    public boolean contains(Receipt r) {
        return this.receipts.contains(r);
    }

    @Override
    public void clear() {
        this.receipts.clear();
        this.receiptsByNumber.clear();
    }

    @Override
    public void removeReceiptGroupListener(ReceiptGroupListener l) {
        this.receiptGroupListener.remove(l);
    }

    @Override
    public void addReceiptGroupListener(ReceiptGroupListener l) {
        this.receiptGroupListener.add(l);
    }

    public void notifyListeners() {
        if (this.listenerNotificationAllowed) {
            for (ReceiptGroupListener l : this.receiptGroupListener) {
                l.receiptGroupChanged();
            }
        }
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        if (this.listenerNotificationAllowed) {
            this.notifyListeners();
        }
    }

    @Override
    public void setReceiptGroupListenerNotification(boolean notificationAllowed) {
        this.listenerNotificationAllowed = notificationAllowed;
    }

    @Override
    public void writeToXML(XMLStreamWriter writer) throws XMLStreamException {
        Logger logger = Logger.getLogger(this.getClass().getName());
        writer.writeStartElement(XML_RECEIPTS_RECEIPTS);
        for (Receipt receipt : this.getReceiptList()) {
            logger.fine("Calling write");
            receipt.writeToXML(writer);
        }
        writer.writeEndElement();
    }

    @Override
    public void writeGroupToXML(XMLStreamWriter writer, String groupName) throws XMLStreamException {
        writer.writeStartElement(XML_GROUP_GROUP);
        writer.writeAttribute(XML_GROUP_NAME, groupName);
        for (Receipt receipt : this.receipts) {
            XmlTools.writeXmlElement(writer, XML_GROUP_ITEM, receipt.getNumber(), null);
        }
        writer.writeEndElement();
    }

    public static LinkedList<AbstractReceipt> readFromXML(XMLStreamReader reader) throws XMLStreamException {
        Logger logger = Logger.getLogger(ReceiptContainer.class.getName());
        LinkedList<AbstractReceipt> result = new LinkedList<AbstractReceipt>();
        while (!reader.isEndElement() || !reader.getName().toString().equals(XML_RECEIPTS_RECEIPTS)) {
            if (reader.isStartElement() && reader.hasName() && reader.getName().toString().equals("receipt")) {
                AbstractReceipt r;
                logger.finer("-> Found a receipt");
                String type = XmlTools.getOneSingleAttributeValue(reader, "type");
                if (type != null && (r = ReceiptFactory.readFromXml(reader, type)) != null) {
                    result.add(r);
                }
            }
            reader.next();
        }
        return result;
    }

    public static LinkedList<Integer> readGroupItemsFromXML(XMLStreamReader reader) throws XMLStreamException {
        Logger logger = Logger.getLogger(ReceiptContainer.class.getName());
        LinkedList<Integer> result = new LinkedList<Integer>();
        while (!reader.isEndElement() || !reader.getName().toString().equals(XML_GROUP_GROUP)) {
            if (reader.isStartElement() && reader.hasName() && reader.getName().toString().equals(XML_GROUP_ITEM)) {
                logger.finer("-> Found a group item");
                Integer item = Integer.valueOf(reader.getElementText());
                result.add(item);
            }
            reader.next();
        }
        return result;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public Collection<Integer> getAllAccounts() {
        TreeSet<Integer> result = new TreeSet<Integer>();
        for (AbstractReceipt receipt : this.receipts) {
            result.addAll(receipt.getAllAccountNumbers());
        }
        return result;
    }
}

