/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.receipt;

import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.depreciation.PoolDepreciationStrategy;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.gui.TimeFrame;
import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.eur.receipt.DataChangeListener;
import de.uwemock.eur.receipt.DepreciationPool;
import de.uwemock.eur.receipt.Receipt;
import de.uwemock.eur.receipt.ReceiptGroup;
import de.uwemock.eur.receipt.ReceiptGroupListListener;
import de.uwemock.eur.receipt.ReceiptGroupListProvider;
import de.uwemock.eur.receipt.ReceiptGroupListener;
import de.uwemock.eur.receipt.ReceiptNumberManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.TreeSet;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class PoolManager
implements Observer,
ReceiptGroupListProvider,
ReceiptGroupListener {
    public static final String XML_POOLS = "depreciationpools";
    private static volatile PoolManager instance = null;
    private Map<Integer, DepreciationPool> poolsByYear = new HashMap<Integer, DepreciationPool>();
    private ArrayList<Integer> yearsLinear = new ArrayList();
    private ArrayList<DataChangeListener> dataChangeListener = new ArrayList();
    private ArrayList<ReceiptGroupListListener> receiptGroupListListener = new ArrayList();

    private PoolManager() {
        this.removeAllPools();
    }

    public static PoolManager getInstance() {
        if (instance == null) {
            instance = new PoolManager();
        }
        return instance;
    }

    public DepreciationPool getCurrentDepreciationPool() {
        return this.getDepreciationPoolForYear(DataCenter.getInstance().getBusinessYear());
    }

    public void add(AbstractReceipt r) {
        int year = r.getDate().getYear();
        DepreciationPool dp = this.getDepreciationPoolForYear(year);
        dp.add(r);
        ReceiptNumberManager.getInstance().setReceiptNumberUsed(r.getNumber());
        dp.setChanged();
        dp.notifyObservers();
        this.fireDataChanged();
    }

    public void insert(AbstractReceipt r) {
        int year = r.getDate().getYear();
        DepreciationPool dp = this.getDepreciationPoolForYear(year);
        dp.insert(r);
        ReceiptNumberManager.getInstance().setReceiptNumberUsed(r.getNumber());
        dp.setChanged();
        dp.notifyObservers();
        this.fireDataChanged();
    }

    public void remove(AbstractReceipt r) {
        int year = r.getDate().getYear();
        DepreciationPool dp = this.getDepreciationPoolForYear(year);
        dp.remove(r);
        dp.setChanged();
        dp.notifyObservers();
        this.fireDataChanged();
    }

    public DepreciationPool getDepreciationPoolForYear(int year) {
        DepreciationPool dp = this.poolsByYear.get(year);
        if (dp == null) {
            int defaultAccount = (Integer)PoolDepreciationStrategy.getSettingsCluster().getSettingValue("defaultAccount");
            dp = new DepreciationPool(year, defaultAccount);
            dp.addReceiptGroupListener(this);
            dp.addObserver(this);
            dp.setDisplayName(String.format(TextPool.getString("labelDepreciationPool"), year));
            this.poolsByYear.put(year, dp);
            int pos = 0;
            while (pos < this.yearsLinear.size() && this.yearsLinear.get(pos) < year) {
                ++pos;
            }
            this.yearsLinear.add(pos, year);
            this.fireReceiptGroupsListChanged();
        }
        return dp;
    }

    public void writeToXML(XMLStreamWriter writer) throws XMLStreamException {
        Collection<DepreciationPool> pools = this.poolsByYear.values();
        writer.writeStartElement(XML_POOLS);
        for (DepreciationPool dp : pools) {
            dp.writeToXML(writer);
        }
        writer.writeEndElement();
    }

    public void removeAllPools() {
        for (DepreciationPool dp : this.poolsByYear.values()) {
            dp.removeReceiptGroupListener(this);
        }
        this.poolsByYear.clear();
        this.yearsLinear.clear();
        this.getCurrentDepreciationPool();
        this.fireReceiptGroupsListChanged();
        this.fireDataChanged();
    }

    public List<Integer> getContainedYears() {
        return this.yearsLinear;
    }

    public boolean contains(Receipt r) {
        for (DepreciationPool pool : this.poolsByYear.values()) {
            if (!pool.contains(r)) continue;
            return true;
        }
        return false;
    }

    public void addDataChangeListener(DataChangeListener l) {
        this.dataChangeListener.add(l);
    }

    public void removeDataChangeListener(DataChangeListener l) {
        this.dataChangeListener.remove(l);
    }

    public void fireDataChanged() {
        for (DataChangeListener l : this.dataChangeListener) {
            l.dataChanged();
        }
    }

    @Override
    public List<ReceiptGroup> getReceiptGroupList() {
        ArrayList<ReceiptGroup> groupList = new ArrayList<ReceiptGroup>(this.yearsLinear.size());
        for (Integer year : this.yearsLinear) {
            groupList.add(0, this.poolsByYear.get(year));
        }
        return groupList;
    }

    @Override
    public void addReceiptGroupListListener(ReceiptGroupListListener l) {
        this.receiptGroupListListener.add(l);
    }

    @Override
    public void removeReceiptGroupListListener(ReceiptGroupListListener l) {
        this.receiptGroupListListener.remove(l);
    }

    public void fireReceiptGroupsListChanged() {
        for (ReceiptGroupListListener l : this.receiptGroupListListener) {
            l.receiptGroupListChanged();
        }
    }

    @Override
    public void receiptGroupChanged() {
        this.fireDataChanged();
    }

    public List<AbstractReceipt> getReceiptCollectionByTimeFrame(int timeFrame) {
        ArrayList<AbstractReceipt> result = new ArrayList<AbstractReceipt>();
        for (AbstractReceipt r : this.getCurrentDepreciationPool().getReceiptList()) {
            if (!TimeFrame.isInTimeFrame(timeFrame, r.getDate())) continue;
            result.add(r);
        }
        return result;
    }

    public Collection<Integer> getAllAccounts() {
        TreeSet<Integer> result = new TreeSet<Integer>();
        for (DepreciationPool pool : this.poolsByYear.values()) {
            if (pool.size() <= 0) continue;
            result.addAll(pool.getAllAccounts());
        }
        return result;
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        this.fireDataChanged();
    }
}

