/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.receipt;

import de.uwemock.tools.Numbers;
import de.uwemock.xmltools.XmlTools;
import java.math.BigDecimal;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class PaymentTemplate {
    public static final String XML_PAYMENT_TEMPLATE = "paymenttemplate";
    private static final String XML_PAYMENT_TEMPLATE_ACCOUNT = "account";
    private static final String XML_PAYMENT_TEMPLATE_DESCRIPTION = "description";
    private static final String XML_PAYMENT_TEMPLATE_AMOUNT = "amount";
    private static final String XML_PAYMENT_TEMPLATE_TAXID = "taxID";
    private static final String XML_PAYMENT_TEMPLATE_INCL_EXCL_TAX = "taxtype";
    private Integer accountNumber;
    private String description;
    private BigDecimal amount;
    private Integer taxID;
    private Integer includingExcludingTax;

    private PaymentTemplate() {
    }

    public PaymentTemplate(String description) {
        if (description == null || description.trim().isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.description = description.trim();
    }

    public Integer getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(Integer accountNumber) {
        this.accountNumber = accountNumber;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        if (description == null || description.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.description = description;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public Integer getTaxID() {
        return this.taxID;
    }

    public void setTaxID(Integer taxID) {
        this.taxID = taxID;
    }

    public Integer getIncludingExcludingTax() {
        return this.includingExcludingTax;
    }

    public void setIncludingExcludingTax(Integer includingExcludingTax) {
        this.includingExcludingTax = includingExcludingTax;
    }

    public boolean isRealTemplate() {
        return this.accountNumber != null || this.amount != null || this.taxID != null || this.includingExcludingTax != null;
    }

    public void writeToXML(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement(XML_PAYMENT_TEMPLATE);
        XmlTools.writeXmlElement(writer, XML_PAYMENT_TEMPLATE_DESCRIPTION, this.description, null);
        if (this.accountNumber != null) {
            XmlTools.writeXmlElement(writer, XML_PAYMENT_TEMPLATE_ACCOUNT, this.accountNumber.toString(), null);
        }
        if (this.amount != null) {
            XmlTools.writeXmlElement(writer, XML_PAYMENT_TEMPLATE_AMOUNT, this.amount.toPlainString(), null);
        }
        if (this.taxID != null) {
            XmlTools.writeXmlElement(writer, XML_PAYMENT_TEMPLATE_TAXID, this.taxID.toString(), null);
        }
        if (this.includingExcludingTax != null) {
            XmlTools.writeXmlElement(writer, XML_PAYMENT_TEMPLATE_INCL_EXCL_TAX, this.includingExcludingTax.toString(), null);
        }
        writer.writeEndElement();
    }

    public static PaymentTemplate readFromXML(XMLStreamReader reader) throws XMLStreamException {
        if (!XmlTools.isStartElement(reader, XML_PAYMENT_TEMPLATE)) {
            return null;
        }
        PaymentTemplate res = new PaymentTemplate();
        while (reader.hasNext()) {
            reader.next();
            if (XmlTools.isEndElement(reader, XML_PAYMENT_TEMPLATE)) break;
            if (XmlTools.isStartElement(reader, XML_PAYMENT_TEMPLATE_DESCRIPTION)) {
                res.setDescription(reader.getElementText());
            }
            if (XmlTools.isStartElement(reader, XML_PAYMENT_TEMPLATE_ACCOUNT)) {
                res.setAccountNumber(Integer.parseInt(reader.getElementText()));
            }
            if (XmlTools.isStartElement(reader, XML_PAYMENT_TEMPLATE_AMOUNT)) {
                res.setAmount(Numbers.getBigDecimalFromString(reader.getElementText(), Numbers.BIG_DECIMAL_ZERO));
            }
            if (XmlTools.isStartElement(reader, XML_PAYMENT_TEMPLATE_TAXID)) {
                res.setTaxID(Integer.parseInt(reader.getElementText()));
            }
            if (!XmlTools.isStartElement(reader, XML_PAYMENT_TEMPLATE_INCL_EXCL_TAX)) continue;
            res.setIncludingExcludingTax(Integer.parseInt(reader.getElementText()));
        }
        if (res.description == null || res.description.isEmpty()) {
            return null;
        }
        return res;
    }

    public String toString() {
        return this.description;
    }
}

