/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.receipt;

import de.uwemock.eur.receipt.Payment;
import java.math.BigDecimal;

public class PaymentFactory {
    private PaymentFactory() {
    }

    public static Payment createPaymentFromAmountExcludingTaxAndTaxPercent(int account, BigDecimal amountExcludingTax, BigDecimal taxPercent, String taxKey, String text) {
        BigDecimal amountTax = Payment.taxAmountFromAmountExcludingTax(amountExcludingTax, taxPercent);
        return new Payment(account, amountExcludingTax, amountTax, taxPercent, taxKey, text);
    }

    public static Payment createPaymentFromAmountIncludingTaxAndTaxPercent(int account, BigDecimal amountIncludingTax, BigDecimal taxPercent, String taxKey, String text) {
        BigDecimal amountTax = Payment.taxAmountFromAmountIncludingTax(amountIncludingTax, taxPercent);
        BigDecimal amountExcludingTax = amountIncludingTax.subtract(amountTax);
        return new Payment(account, amountExcludingTax, amountTax, taxPercent, taxKey, text);
    }

    public static Payment createPaymentFromAmountExcludingTaxAndTaxAmount(int account, BigDecimal amountExcludingTax, BigDecimal amountTax, BigDecimal taxPercent, String taxKey, String text) {
        return new Payment(account, amountExcludingTax, amountTax, taxPercent, taxKey, text);
    }

    public static Payment createPaymentFromPayment(Payment p) {
        return new Payment(p.getAccount(), p.getAmountExcludingTax(), p.getAmountTax(), p.getPercentTax(), p.getTaxKey(), p.getText());
    }
}

