/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.receipt;

import de.uwemock.eur.data.Constants;
import de.uwemock.eur.data.Tax;
import de.uwemock.tools.Numbers;
import de.uwemock.xmltools.Attribute;
import de.uwemock.xmltools.XmlTools;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class Payment {
    public static final String XML_PAYMENT_PAYMENT = "payment";
    private static final String XML_PAYMENT_AMOUNT = "amount";
    private static final String XML_PAYMENT_ATT_TAX_INCL = "incl";
    private static final String XML_PAYMENT_ATT_TAX_EXCL = "excl";
    private static final String XML_PAYMENT_ATT_TAX_ONLY = "tax";
    private static final String XML_PAYMENT_TAX = "tax";
    private static final String XML_PAYMENT_TAX_PERCENT = "percent";
    private static final String XML_PAYMENT_TAX_KEY = "key";
    private static final String XML_PAYMENT_ACCOUNT = "account";
    private static final String XML_PAYMENT_DESC = "description";
    private BigDecimal amountExcludingTax;
    private BigDecimal amountIncudingTax;
    private BigDecimal amountTax;
    private BigDecimal percentTax;
    private String taxKey;
    private int account;
    private String text;

    Payment(int account, BigDecimal amountExcludingTax, BigDecimal amountTax, BigDecimal percentTax, String taxKey, String text) {
        this.setAccount(account);
        this.setAmountExcludingTax(amountExcludingTax);
        this.setAmountIncludingTax(amountExcludingTax.add(amountTax));
        this.setAmountTax(amountTax);
        this.setPercentTax(percentTax);
        this.setTaxKey(taxKey);
        this.setText(text);
    }

    public BigDecimal getAmountExcludingTax() {
        return this.amountExcludingTax;
    }

    void setAmountExcludingTax(BigDecimal amountWithoutTax) {
        this.amountExcludingTax = amountWithoutTax;
    }

    public BigDecimal getAmountIncludingTax() {
        return this.amountIncudingTax;
    }

    void setAmountIncludingTax(BigDecimal amountWithTax) {
        this.amountIncudingTax = amountWithTax;
    }

    public BigDecimal getAmountTax() {
        return this.amountTax;
    }

    void setAmountTax(BigDecimal amountTax) {
        this.amountTax = amountTax;
    }

    public BigDecimal getPercentTax() {
        return this.percentTax;
    }

    void setPercentTax(BigDecimal percentTax) {
        this.percentTax = percentTax;
    }

    public String getTaxKey() {
        return this.taxKey;
    }

    void setTaxKey(String taxKey) {
        this.taxKey = taxKey;
    }

    void setTax(Tax tax) {
        this.setPercentTax(tax.getPercent());
        this.setTaxKey(tax.getText());
    }

    public int getAccount() {
        return this.account;
    }

    public void setAccount(int account) {
        this.account = account;
    }

    public String getText() {
        return this.text;
    }

    void setText(String text) {
        this.text = text;
    }

    public static BigDecimal taxAmountFromAmountIncludingTax(BigDecimal amountIncludingTax, BigDecimal taxPercent) {
        return amountIncludingTax.subtract(amountIncludingTax.multiply(Constants.ONEHUNDRED).divide(Constants.ONE.add(taxPercent.scaleByPowerOfTen(-2)), RoundingMode.HALF_EVEN).scaleByPowerOfTen(-2)).setScale(2, RoundingMode.HALF_UP);
    }

    public static BigDecimal taxAmountFromAmountExcludingTax(BigDecimal amountExcludingTax, BigDecimal taxPercent) {
        return amountExcludingTax.multiply(taxPercent).scaleByPowerOfTen(-2).setScale(2, RoundingMode.HALF_UP);
    }

    public void writeToXML(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement(XML_PAYMENT_PAYMENT);
        XmlTools.writeXmlElement(writer, XML_PAYMENT_ACCOUNT, this.getAccount(), null);
        XmlTools.writeXmlElement(writer, XML_PAYMENT_DESC, this.getText(), null);
        XmlTools.writeXmlElement(writer, XML_PAYMENT_AMOUNT, this.getAmountExcludingTax().toString(), new Attribute("tax", XML_PAYMENT_ATT_TAX_EXCL));
        XmlTools.writeXmlElement(writer, XML_PAYMENT_AMOUNT, this.getAmountIncludingTax().toString(), new Attribute("tax", XML_PAYMENT_ATT_TAX_INCL));
        XmlTools.writeXmlElement(writer, XML_PAYMENT_AMOUNT, this.getAmountTax().toString(), new Attribute("tax", "tax"));
        writer.writeStartElement("tax");
        XmlTools.writeXmlElement(writer, XML_PAYMENT_TAX_PERCENT, this.getPercentTax().toString(), null);
        XmlTools.writeXmlElement(writer, XML_PAYMENT_TAX_KEY, this.getTaxKey(), null);
        writer.writeEndElement();
        writer.writeEndElement();
    }

    public static Payment readFromXML(XMLStreamReader reader) throws XMLStreamException {
        if (!(reader.isStartElement() && reader.hasName() && reader.getName().toString().equals(XML_PAYMENT_PAYMENT))) {
            return null;
        }
        int account = -1;
        BigDecimal amountExcludingTax = null;
        BigDecimal amountIncludingTax = null;
        BigDecimal amountTax = null;
        BigDecimal percentTax = null;
        String taxKey = null;
        String text = null;
        while (reader.hasNext()) {
            Map<String, String> attr;
            reader.next();
            if (XmlTools.isEndElement(reader, XML_PAYMENT_PAYMENT)) break;
            if (XmlTools.isStartElement(reader, XML_PAYMENT_ACCOUNT)) {
                account = Numbers.getIntFromString(reader.getElementText(), 0);
            }
            if (XmlTools.isStartElement(reader, XML_PAYMENT_AMOUNT) && (attr = XmlTools.getAttributes(reader)).containsKey("tax")) {
                String value = attr.get("tax");
                if (value.equals(XML_PAYMENT_ATT_TAX_EXCL)) {
                    amountExcludingTax = Numbers.getBigDecimalFromString(reader.getElementText(), null);
                }
                if (value.equals(XML_PAYMENT_ATT_TAX_INCL)) {
                    amountIncludingTax = Numbers.getBigDecimalFromString(reader.getElementText(), null);
                }
                if (value.equals("tax")) {
                    amountTax = Numbers.getBigDecimalFromString(reader.getElementText(), null);
                }
            }
            if (XmlTools.isStartElement(reader, XML_PAYMENT_TAX_PERCENT)) {
                percentTax = Numbers.getBigDecimalFromString(reader.getElementText(), null);
            }
            if (XmlTools.isStartElement(reader, XML_PAYMENT_TAX_KEY)) {
                taxKey = reader.getElementText();
            }
            if (!XmlTools.isStartElement(reader, XML_PAYMENT_DESC)) continue;
            text = reader.getElementText();
        }
        if (amountExcludingTax == null && amountIncludingTax != null && amountTax != null) {
            amountExcludingTax = amountIncludingTax.subtract(amountTax);
        }
        if (amountTax == null && amountIncludingTax != null && amountExcludingTax != null) {
            amountTax = amountIncludingTax.subtract(amountExcludingTax);
        }
        if (account < 0 || amountExcludingTax == null || amountTax == null || percentTax == null || taxKey == null || text == null) {
            return null;
        }
        return new Payment(account, amountExcludingTax, amountTax, percentTax, taxKey, text);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.account;
        result = 31 * result + (this.amountExcludingTax == null ? 0 : this.amountExcludingTax.hashCode());
        result = 31 * result + (this.amountIncudingTax == null ? 0 : this.amountIncudingTax.hashCode());
        result = 31 * result + (this.amountTax == null ? 0 : this.amountTax.hashCode());
        result = 31 * result + (this.percentTax == null ? 0 : this.percentTax.hashCode());
        result = 31 * result + (this.taxKey == null ? 0 : this.taxKey.hashCode());
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Payment other = (Payment)obj;
        if (this.account != other.account) {
            return false;
        }
        if (this.amountExcludingTax == null ? other.amountExcludingTax != null : !this.amountExcludingTax.equals(other.amountExcludingTax)) {
            return false;
        }
        if (this.amountIncudingTax == null ? other.amountIncudingTax != null : !this.amountIncudingTax.equals(other.amountIncudingTax)) {
            return false;
        }
        if (this.amountTax == null ? other.amountTax != null : !this.amountTax.equals(other.amountTax)) {
            return false;
        }
        if (this.percentTax == null ? other.percentTax != null : !this.percentTax.equals(other.percentTax)) {
            return false;
        }
        if (this.taxKey == null ? other.taxKey != null : !this.taxKey.equals(other.taxKey)) {
            return false;
        }
        return !(this.text == null ? other.text != null : !this.text.equals(other.text));
    }

    public String toString() {
        return String.valueOf(this.account) + ": " + this.amountExcludingTax.toPlainString() + "/" + this.amountIncudingTax.toPlainString() + "/" + this.amountTax.toPlainString();
    }
}

