/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.receipt;

import de.uwemock.datetools.Date;
import de.uwemock.eur.data.AbstractReceiptOwner;
import de.uwemock.eur.data.Constants;
import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.depreciation.DepreciationFactory;
import de.uwemock.eur.depreciation.DepreciationStrategy;
import de.uwemock.eur.depreciation.PoolDepreciationStrategy;
import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.eur.receipt.Payment;
import de.uwemock.eur.receipt.Receipt;
import de.uwemock.eur.receipt.ReceiptNumberManager;
import de.uwemock.eur.receipt.ReceiptOwner;
import de.uwemock.tools.Numbers;
import de.uwemock.xmltools.XmlTools;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class OldDepreciationPool
extends AbstractReceipt
implements ReceiptOwner,
Observer {
    public static final String XML_RECEIPT_ATT_TYPE = "pool";
    private static final String XML_RECEIPT_POOL_ACCOUNT = "account";
    private int account;
    private ArrayList<AbstractReceipt> receipts;
    private BigDecimal totalAmount = null;
    private BigDecimal totalTax = null;

    public OldDepreciationPool(int startYear, int account, int numYears) {
        this(startYear, account);
        this.setDepreciationStrategy(new PoolDepreciationStrategy(startYear, numYears, this));
    }

    public OldDepreciationPool(int startYear, int account) {
        this.setDate(Date.getDate(startYear, 12, 31));
        this.account = account;
        this.receipts = new ArrayList();
        this.setDepreciationStrategy(new PoolDepreciationStrategy(startYear, this));
    }

    @Override
    public void add(AbstractReceipt r) {
        Iterator<Integer> i;
        Collection<Integer> receiptAccounts;
        this.totalAmount = null;
        this.totalTax = null;
        ReceiptNumberManager.getInstance().setReceiptNumberUsed(r.getNumber());
        r.addObserver(this);
        this.receipts.add(r);
        if (this.account == 0 && (receiptAccounts = r.accountNumbersAddedTo()) != null && (i = receiptAccounts.iterator()).hasNext()) {
            this.account = i.next();
        }
        this.setChanged();
        this.notifyObservers();
    }

    public void addAll(Collection<AbstractReceipt> receipts) {
        for (AbstractReceipt r : receipts) {
            this.add(r);
        }
    }

    @Override
    public void replace(AbstractReceipt oldReceipt, AbstractReceipt newReceipt) {
        if (oldReceipt != null && newReceipt != null) {
            this.totalAmount = null;
            this.totalTax = null;
            this.receipts.set(oldReceipt.getNumber() - 1, newReceipt);
            oldReceipt.deleteObserver(this);
            this.hasChanged();
            this.notifyObservers();
        }
    }

    public int getPoolReceiptCount() {
        return this.receipts.size();
    }

    public AbstractReceipt getPoolReceiptByIndex(int index) {
        return this.receipts.get(index);
    }

    @Override
    public List<AbstractReceipt> getReceiptList() {
        return Collections.unmodifiableList(this.receipts);
    }

    @Override
    public void setDeleted(boolean deleted) {
        this.totalAmount = null;
        this.totalTax = null;
        super.setDeleted(deleted);
    }

    @Override
    public Collection<Integer> accountNumbersAddedTo() {
        LinkedList<Integer> res = new LinkedList<Integer>();
        res.add(this.account);
        return res;
    }

    @Override
    public boolean addsToAccount(int account) {
        return this.account == account;
    }

    @Override
    public boolean addsToTax() {
        for (Receipt receipt : this.receipts) {
            if (!receipt.addsToTax()) continue;
            return true;
        }
        return false;
    }

    @Override
    public BigDecimal amountAddedToTaxKey(String taxKey) {
        BigDecimal res = Constants.ZERO;
        for (Receipt receipt : this.receipts) {
            if (receipt.isDeleted() || !receipt.isPaid()) continue;
            res = res.add(receipt.amountAddedToTaxKey(taxKey));
        }
        return res;
    }

    @Override
    public BigDecimal amountExcludingTaxAddedToAccount(int account) {
        if (this.account == account) {
            if (this.totalAmount == null) {
                this.calculateTotalAmount();
            }
            return this.totalAmount;
        }
        return Constants.ZERO;
    }

    @Override
    public BigDecimal amountTaxAddedToAccount(int account) {
        BigDecimal res = Constants.ZERO;
        for (Receipt receipt : this.receipts) {
            if (receipt.isDeleted() || !receipt.isPaid()) continue;
            res = res.add(receipt.amountTaxAddedToAccount(account));
        }
        return res;
    }

    @Override
    public BigDecimal amountTotalExcludingTax() {
        if (this.totalAmount == null) {
            this.calculateTotalAmount();
        }
        return this.totalAmount;
    }

    @Override
    public BigDecimal amountTotalTax() {
        if (this.totalTax == null) {
            this.calculateTotalAmount();
        }
        return this.totalTax;
    }

    @Override
    public int getNumber() {
        return this.getDepreciationStrategy().getStartYear() - DataCenter.getInstance().getBusinessYear();
    }

    @Override
    public String getReceiptDescription() {
        return "Abschreibungs-Pool " + this.getDate().getYear();
    }

    @Override
    public void setReceiptDescription(String text) {
    }

    @Override
    public String getId() {
        return "";
    }

    @Override
    public Object getReceiptInfo(int item) {
        switch (item) {
            case 1: {
                return this.getNumber();
            }
            case 2: {
                return this.getDate();
            }
            case 3: {
                return this.getId();
            }
            case 4: {
                return this.account;
            }
            case 5: {
                if (this.totalAmount == null) {
                    this.calculateTotalAmount();
                }
                return this.totalAmount.add(this.totalTax);
            }
            case 6: {
                if (this.totalAmount == null) {
                    this.calculateTotalAmount();
                }
                return this.totalAmount;
            }
            case 7: {
                if (this.totalTax == null) {
                    this.calculateTotalAmount();
                }
                return this.totalTax;
            }
            case 12: {
                TreeSet taxkeys = new TreeSet();
                for (Receipt receipt : this.receipts) {
                    taxkeys.addAll((Collection)receipt.getReceiptInfo(12));
                }
                return taxkeys;
            }
            case 11: {
                TreeSet treeSet = new TreeSet();
                for (Receipt receipt : this.receipts) {
                    treeSet.addAll((Collection)receipt.getReceiptInfo(11));
                }
                return treeSet;
            }
            case 13: {
                return this.getReceiptDescription();
            }
            case 14: {
                return this.accountNumbersAddedTo();
            }
            case 15: {
                LinkedList linkedList = new LinkedList();
                for (Receipt receipt : this.receipts) {
                    linkedList.addAll((Collection)receipt.getReceiptInfo(15));
                }
                for (Payment payment : linkedList) {
                    payment.setAccount(this.account);
                }
                return linkedList;
            }
        }
        return null;
    }

    public int getAccount() {
        return this.account;
    }

    public void setAccount(int account) {
        this.account = account;
    }

    @Override
    public BigDecimal taxAddedToTaxKey(String taxKey) {
        BigDecimal res = Constants.ZERO;
        for (Receipt receipt : this.receipts) {
            res = res.add(receipt.taxAddedToTaxKey(taxKey));
        }
        return res;
    }

    @Override
    public Collection<String> taxKeysAddedTo() {
        TreeSet<String> res = new TreeSet<String>();
        for (Receipt receipt : this.receipts) {
            res.addAll(receipt.taxKeysAddedTo());
        }
        return res;
    }

    @Override
    public Collection<Payment> getAllPayments() {
        LinkedList<Payment> payments = new LinkedList<Payment>();
        for (Receipt receipt : this.receipts) {
            payments.addAll(receipt.getAllPayments());
        }
        for (Payment payment : payments) {
            payment.setAccount(this.account);
        }
        return super.getAllPayments(payments);
    }

    @Override
    public Set<Integer> getAllAccountNumbers() {
        TreeSet<Integer> accounts = new TreeSet<Integer>();
        accounts.add(this.account);
        return accounts;
    }

    @Override
    public void writeToXML(XMLStreamWriter writer) throws XMLStreamException {
        Logger logger = Logger.getLogger(this.getClass().getName());
        logger.finer("Writing depreciation pool  for year " + this.getDate().getYear());
        writer.writeStartElement("receipt");
        writer.writeAttribute("type", XML_RECEIPT_ATT_TYPE);
        if (this.isDeleted()) {
            writer.writeAttribute("deleted", "yes");
        }
        this.getDate().writeToXml(writer);
        XmlTools.writeXmlElement(writer, XML_RECEIPT_POOL_ACCOUNT, this.getAccount(), null);
        XmlTools.writeXmlElement(writer, "id", this.getId(), null);
        XmlTools.writeXmlElement(writer, "description", this.getReceiptDescription(), null);
        if (this.hasDepreciationStrategy()) {
            this.getDepreciationStrategy().writeToXml(writer);
        }
        writer.writeStartElement("receipts");
        for (Receipt receipt : this.getReceiptList()) {
            logger.fine("Calling write");
            receipt.writeToXML(writer);
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }

    public static OldDepreciationPool readFromXML(XMLStreamReader reader) throws XMLStreamException {
        Logger logger = Logger.getLogger("de.uwemock.eur.DepreciationPool");
        if (!XmlTools.isStartElement(reader, "receipt") || reader.getAttributeCount() == 0) {
            return null;
        }
        Map<String, String> atts = XmlTools.getAttributes(reader);
        String type = atts.get("type");
        if (type == null || !XML_RECEIPT_ATT_TYPE.equals(type)) {
            return null;
        }
        String deleted = atts.get("deleted");
        logger.finest("Depreciation pool receipt confirmed by attribute");
        Date poolDate = null;
        int poolAccount = 0;
        String poolId = null;
        DepreciationStrategy poolStrategy = null;
        LinkedList<AbstractReceipt> poolReceipts = null;
        boolean isDeleted = "yes".equals(deleted);
        while (reader.hasNext()) {
            String depreciationType;
            reader.next();
            if (XmlTools.isEndElement(reader, "receipt")) break;
            if (XmlTools.isStartElement(reader, "date")) {
                poolDate = Date.readFromXml(reader);
            }
            if (XmlTools.isStartElement(reader, XML_RECEIPT_POOL_ACCOUNT)) {
                poolAccount = Numbers.getIntFromString(reader.getElementText(), 0);
            }
            if (XmlTools.isStartElement(reader, "id")) {
                poolId = reader.getElementText();
            }
            if (XmlTools.isStartElement(reader, "depreciationplan") && (depreciationType = XmlTools.getOneSingleAttributeValue(reader, "type")) != null) {
                poolStrategy = DepreciationFactory.readFromXml(reader, depreciationType);
            }
            if (!XmlTools.isStartElement(reader, "receipts")) continue;
            poolReceipts = AbstractReceiptOwner.readFromXML(reader);
        }
        if (poolDate == null || poolId == null || poolStrategy == null || poolReceipts == null) {
            return null;
        }
        OldDepreciationPool newPool = new OldDepreciationPool(poolDate.getYear(), poolAccount, poolStrategy.getNumYears());
        newPool.setDepreciationStrategy(poolStrategy);
        newPool.setDeleted(isDeleted);
        newPool.receipts.addAll(poolReceipts);
        poolStrategy.setReceipt(newPool);
        return newPool;
    }

    private void calculateTotalAmount() {
        this.totalAmount = Constants.ZERO;
        this.totalTax = Constants.ZERO;
        for (AbstractReceipt r : this.receipts) {
            if (r.isDeleted() || !r.isPaid()) continue;
            this.totalAmount = this.totalAmount.add(r.amountTotalExcludingTax());
            this.totalTax = this.totalTax.add(r.amountTotalTax());
        }
    }

    public static boolean hasXmlTypeAttribute(String attribute) {
        return XML_RECEIPT_ATT_TYPE.equals(attribute);
    }

    @Override
    public void update(Observable o, Object arg) {
        this.calculateTotalAmount();
        this.setChanged();
        this.notifyObservers();
    }

    @Override
    public boolean isIncomingReceipt() {
        return false;
    }

    @Override
    public boolean isOutgoingReceipt() {
        return true;
    }
}

