/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.receipt;

import de.uwemock.datetools.Date;
import de.uwemock.eur.data.Constants;
import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.depreciation.DepreciationStrategy;
import de.uwemock.eur.depreciation.PoolDepreciationStrategy;
import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.eur.receipt.Payment;
import de.uwemock.eur.receipt.Receipt;
import de.uwemock.eur.receipt.ReceiptContainer;
import de.uwemock.eur.receipt.ReceiptGroup;
import de.uwemock.eur.receipt.ReceiptGroupListener;
import de.uwemock.xmltools.XmlTools;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class DepreciationPool
extends AbstractReceipt
implements ReceiptGroup,
ReceiptGroupListener {
    public static final String XML_POOL_POOL = "pool";
    private static final String XML_POOL_ACCOUNT = "account";
    private static final String XML_POOL_START_YEAR = "startyear";
    private static final String XML_POOL_NUM_YEARS = "numyears";
    private String name;
    private int account;
    private ReceiptContainer receipts;
    private BigDecimal totalAmount;
    private BigDecimal totalTax;

    public DepreciationPool(int startYear, int account, int numYears) {
        this(startYear, account);
        this.setDepreciationStrategy(new PoolDepreciationStrategy(startYear, numYears, this));
    }

    public DepreciationPool(int startYear, int account) {
        this.setDate(Date.getDate(startYear, 12, 31));
        this.account = account;
        this.receipts = new ReceiptContainer();
        this.receipts.addReceiptGroupListener(this);
        this.setDepreciationStrategy(new PoolDepreciationStrategy(startYear, this));
    }

    @Override
    public void setDisplayName(String name) {
        this.name = name;
    }

    @Override
    public void setReceiptDescription(String text) {
    }

    @Override
    public void add(AbstractReceipt r) {
        this.receipts.add(r);
    }

    @Override
    public void insert(AbstractReceipt r) {
        this.receipts.insert(r);
    }

    @Override
    public void remove(AbstractReceipt r) {
        this.receipts.remove(r);
    }

    @Override
    public boolean contains(Receipt r) {
        return this.receipts.contains(r);
    }

    @Override
    public int size() {
        return this.receipts.size();
    }

    @Override
    public AbstractReceipt get(int index) {
        return this.receipts.get(index);
    }

    @Override
    public AbstractReceipt getByNumber(int number) {
        return this.receipts.getByNumber(number);
    }

    @Override
    public void clear() {
        this.receipts.clear();
    }

    @Override
    public void addReceiptGroupListener(ReceiptGroupListener l) {
        this.receipts.addReceiptGroupListener(l);
    }

    @Override
    public void removeReceiptGroupListener(ReceiptGroupListener l) {
        this.receipts.removeReceiptGroupListener(l);
    }

    @Override
    public void setReceiptGroupListenerNotification(boolean notificationAllowed) {
        this.receipts.setReceiptGroupListenerNotification(notificationAllowed);
    }

    @Override
    public void writeGroupToXML(XMLStreamWriter writer, String groupName) throws XMLStreamException {
        this.receipts.writeGroupToXML(writer, groupName);
    }

    @Override
    public List<AbstractReceipt> getReceiptList() {
        return this.receipts.getReceiptList();
    }

    @Override
    public void setDeleted(boolean deleted) {
        this.totalAmount = null;
        this.totalTax = null;
        super.setDeleted(deleted);
    }

    @Override
    public Collection<Integer> accountNumbersAddedTo() {
        LinkedList<Integer> res = new LinkedList<Integer>();
        res.add(this.account);
        return res;
    }

    @Override
    public boolean addsToAccount(int account) {
        return this.account == account;
    }

    @Override
    public boolean addsToTax() {
        for (Receipt receipt : this.receipts.getReceiptList()) {
            if (!receipt.addsToTax()) continue;
            return true;
        }
        return false;
    }

    @Override
    public BigDecimal amountAddedToTaxKey(String taxKey) {
        BigDecimal res = Constants.ZERO;
        for (Receipt receipt : this.receipts.getReceiptList()) {
            if (receipt.isDeleted() || !receipt.isPaid()) continue;
            res = res.add(receipt.amountAddedToTaxKey(taxKey));
        }
        return res;
    }

    @Override
    public BigDecimal amountExcludingTaxAddedToAccount(int account) {
        if (this.account == account) {
            if (this.totalAmount == null) {
                this.calculateTotalAmount();
            }
            return this.totalAmount;
        }
        return Constants.ZERO;
    }

    @Override
    public BigDecimal amountTaxAddedToAccount(int account) {
        BigDecimal res = Constants.ZERO;
        for (Receipt receipt : this.receipts.getReceiptList()) {
            if (receipt.isDeleted() || !receipt.isPaid()) continue;
            res = res.add(receipt.amountTaxAddedToAccount(account));
        }
        return res;
    }

    @Override
    public BigDecimal amountTotalExcludingTax() {
        if (this.totalAmount == null) {
            this.calculateTotalAmount();
        }
        return this.totalAmount;
    }

    @Override
    public BigDecimal amountTotalTax() {
        if (this.totalTax == null) {
            this.calculateTotalAmount();
        }
        return this.totalTax;
    }

    @Override
    public int getNumber() {
        return this.getDepreciationStrategy().getStartYear() - DataCenter.getInstance().getBusinessYear();
    }

    @Override
    public String getReceiptDescription() {
        return "Abschreibungs-Pool " + this.getDate().getYear();
    }

    @Override
    public String getId() {
        return "";
    }

    @Override
    public Object getReceiptInfo(int item) {
        switch (item) {
            case 1: {
                return this.getNumber();
            }
            case 2: {
                return this.getDate();
            }
            case 3: {
                return this.getId();
            }
            case 4: {
                return this.account;
            }
            case 5: {
                if (this.totalAmount == null) {
                    this.calculateTotalAmount();
                }
                return this.totalAmount.add(this.totalTax);
            }
            case 6: {
                if (this.totalAmount == null) {
                    this.calculateTotalAmount();
                }
                return this.totalAmount;
            }
            case 7: {
                if (this.totalTax == null) {
                    this.calculateTotalAmount();
                }
                return this.totalTax;
            }
            case 12: {
                TreeSet taxkeys = new TreeSet();
                for (Receipt receipt : this.receipts.getReceiptList()) {
                    taxkeys.addAll((Collection)receipt.getReceiptInfo(12));
                }
                return taxkeys;
            }
            case 11: {
                TreeSet treeSet = new TreeSet();
                for (Receipt receipt : this.receipts.getReceiptList()) {
                    treeSet.addAll((Collection)receipt.getReceiptInfo(11));
                }
                return treeSet;
            }
            case 13: {
                return this.getReceiptDescription();
            }
            case 14: {
                return this.accountNumbersAddedTo();
            }
            case 15: {
                LinkedList linkedList = new LinkedList();
                for (Receipt receipt : this.receipts.getReceiptList()) {
                    linkedList.addAll((Collection)receipt.getReceiptInfo(15));
                }
                for (Payment payment : linkedList) {
                    payment.setAccount(this.account);
                }
                return linkedList;
            }
        }
        return null;
    }

    public int getAccount() {
        return this.account;
    }

    public void setAccount(int account) {
        this.account = account;
    }

    @Override
    public BigDecimal taxAddedToTaxKey(String taxKey) {
        BigDecimal res = Constants.ZERO;
        for (Receipt receipt : this.receipts.getReceiptList()) {
            res = res.add(receipt.taxAddedToTaxKey(taxKey));
        }
        return res;
    }

    @Override
    public Collection<String> taxKeysAddedTo() {
        TreeSet<String> res = new TreeSet<String>();
        for (Receipt receipt : this.receipts.getReceiptList()) {
            res.addAll(receipt.taxKeysAddedTo());
        }
        return res;
    }

    @Override
    public Collection<Payment> getAllPayments() {
        LinkedList<Payment> payments = new LinkedList<Payment>();
        for (Receipt receipt : this.receipts.getReceiptList()) {
            payments.addAll(receipt.getAllPayments());
        }
        for (Payment payment : payments) {
            payment.setAccount(this.account);
        }
        return super.getAllPayments(payments);
    }

    @Override
    public Set<Integer> getAllAccountNumbers() {
        TreeSet<Integer> accounts = new TreeSet<Integer>();
        accounts.add(this.account);
        return accounts;
    }

    @Override
    public void writeToXML(XMLStreamWriter writer) throws XMLStreamException {
        Logger logger = Logger.getLogger(this.getClass().getName());
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Writing depreciation pool  for year " + this.getDate().getYear());
        }
        writer.writeStartElement(XML_POOL_POOL);
        writer.writeAttribute(XML_POOL_ACCOUNT, Integer.toString(this.getAccount()));
        writer.writeAttribute(XML_POOL_START_YEAR, Integer.toString(this.getDepreciationStrategy().getStartYear()));
        writer.writeAttribute(XML_POOL_NUM_YEARS, Integer.toString(this.getDepreciationStrategy().getNumYears()));
        this.receipts.writeToXML(writer);
        this.getDepreciationStrategy().writeToXml(writer);
        writer.writeEndElement();
    }

    public static DepreciationPool readFromXML(XMLStreamReader reader) throws XMLStreamException {
        if (!XmlTools.isStartElement(reader, XML_POOL_POOL) || reader.getAttributeCount() < 3) {
            return null;
        }
        Map<String, String> atts = XmlTools.getAttributes(reader);
        int account = Integer.parseInt(atts.get(XML_POOL_ACCOUNT));
        int startYear = Integer.parseInt(atts.get(XML_POOL_START_YEAR));
        int numYears = Integer.parseInt(atts.get(XML_POOL_NUM_YEARS));
        DepreciationPool result = new DepreciationPool(startYear, account, numYears);
        while (reader.hasNext()) {
            DepreciationStrategy strategy;
            LinkedList<AbstractReceipt> group;
            reader.next();
            if (XmlTools.isEndElement(reader, XML_POOL_POOL)) break;
            if (XmlTools.isStartElement(reader, "receipts") && (group = ReceiptContainer.readFromXML(reader)) != null) {
                for (AbstractReceipt r : group) {
                    result.add(r);
                }
            }
            if (!XmlTools.isStartElement(reader, "depreciationplan") || (strategy = PoolDepreciationStrategy.readFromXML(reader)) == null) continue;
            result.setDepreciationStrategy(strategy);
        }
        return result;
    }

    private void calculateTotalAmount() {
        this.totalAmount = Constants.ZERO;
        this.totalTax = Constants.ZERO;
        for (AbstractReceipt r : this.receipts.getReceiptList()) {
            if (r.isDeleted() || !r.isPaid()) continue;
            this.totalAmount = this.totalAmount.add(r.amountTotalExcludingTax());
            this.totalTax = this.totalTax.add(r.amountTotalTax());
        }
    }

    @Override
    public boolean isIncomingReceipt() {
        return false;
    }

    @Override
    public boolean isOutgoingReceipt() {
        return true;
    }

    @Override
    public void receiptGroupChanged() {
        this.calculateTotalAmount();
        this.setChanged();
        this.notifyObservers();
    }

    @Override
    public void update(Observable arg0, Object arg1) {
        this.receiptGroupChanged();
    }

    public String toString() {
        return this.name;
    }

    @Override
    public Collection<Integer> getAllAccounts() {
        return this.getAllAccountNumbers();
    }
}

