/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.receipt;

import de.uwemock.datetools.Date;
import de.uwemock.eur.data.Attachment;
import de.uwemock.eur.data.AttachmentInZip;
import de.uwemock.eur.depreciation.DepreciationStrategy;
import de.uwemock.eur.gui.actions.attachment.AttachmentContainer;
import de.uwemock.eur.receipt.Payment;
import de.uwemock.eur.receipt.Receipt;
import de.uwemock.eur.receipt.ReceiptSupplement;
import de.uwemock.tools.Numbers;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public abstract class AbstractReceipt
extends Observable
implements Receipt,
AttachmentContainer {
    public static boolean showDepreciationStrategyInHtmlDescription = true;
    private int number;
    private Date date;
    private String id;
    private boolean deleted;
    private boolean paid = true;
    private DepreciationStrategy depreciationStrategy;
    private List<Attachment> attachments = new LinkedList<Attachment>();

    @Override
    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
        this.setChanged();
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
        this.setChanged();
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
        this.setChanged();
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
        this.setChanged();
    }

    @Override
    public boolean isPaid() {
        return this.paid;
    }

    @Override
    public void setPaid(boolean paid) {
        this.paid = paid;
        this.setChanged();
    }

    @Override
    public DepreciationStrategy getDepreciationStrategy() {
        return this.depreciationStrategy;
    }

    @Override
    public void setDepreciationStrategy(DepreciationStrategy depreciationStrategy) {
        if (this.depreciationStrategy != null) {
            this.deleteObserver(this.depreciationStrategy);
        }
        this.depreciationStrategy = depreciationStrategy;
        if (this.depreciationStrategy != null) {
            this.depreciationStrategy.setReceipt(this);
            this.addObserver(depreciationStrategy);
        }
        this.setChanged();
    }

    @Override
    public boolean hasDepreciationStrategy() {
        return this.depreciationStrategy != null;
    }

    @Override
    public boolean addsToAccount(int account) {
        return this.getAllAccountNumbers().contains(account);
    }

    @Override
    public Collection<Payment> getAllPayments() {
        LinkedList<Payment> payments = new LinkedList<Payment>();
        return this.getAllPayments(payments);
    }

    Collection<Payment> getAllPayments(Collection<Payment> payments) {
        if (this.hasDepreciationStrategy() && this.getDepreciationStrategy() instanceof ReceiptSupplement) {
            ReceiptSupplement supplement = (ReceiptSupplement)((Object)this.getDepreciationStrategy());
            supplement.addToPayments(payments);
        }
        return payments;
    }

    public Set<Integer> getAllAccountNumbers() {
        TreeSet<Integer> accountNumbers = new TreeSet<Integer>();
        if (this.hasDepreciationStrategy() && this.getDepreciationStrategy() instanceof ReceiptSupplement) {
            ReceiptSupplement supplement = (ReceiptSupplement)((Object)this.getDepreciationStrategy());
            supplement.addToAccountNumbers(accountNumbers);
        }
        return accountNumbers;
    }

    public static boolean doShowDepreciationStrategyInHtmlDescriptionSet() {
        return showDepreciationStrategyInHtmlDescription;
    }

    public static void setShowDepreciationStrategyInHtmlDescription(boolean showDepreciationStrategyInHtmlDescription) {
        AbstractReceipt.showDepreciationStrategyInHtmlDescription = showDepreciationStrategyInHtmlDescription;
    }

    @Override
    public void notifyObservers() {
        super.notifyObservers();
    }

    @Override
    public void setChanged() {
        super.setChanged();
    }

    @Override
    public List<Attachment> getAttachments() {
        return Collections.unmodifiableList(this.attachments);
    }

    @Override
    public void addAttachment(Attachment attachment) {
        this.attachments.add(attachment);
        this.setChanged();
        this.notifyObservers();
    }

    @Override
    public void deleteAttachment(Attachment attachment) {
        this.attachments.remove(attachment);
        this.setChanged();
        this.notifyObservers();
    }

    public void deleteAllAttachments() {
        this.attachments.clear();
        this.setChanged();
        this.notifyObservers();
    }

    public boolean hasAttachments() {
        return this.attachments.size() > 0;
    }

    protected void writeAttachmentsToXml(XMLStreamWriter writer) throws XMLStreamException {
        for (Attachment attachment : this.attachments) {
            attachment.writeToXML(writer);
        }
    }

    protected static Attachment readAttachmentFromXml(XMLStreamReader reader) throws XMLStreamException {
        AttachmentInZip attachment = AttachmentInZip.readFromXml(reader);
        return attachment;
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    public int hashCode() {
        return this.number;
    }

    protected BigDecimal getSliceIncludingTax() {
        Collection<Payment> payments = this.getAllPayments();
        BigDecimal result = Numbers.BIG_DECIMAL_ZERO;
        for (Payment p : payments) {
            result = result.add(p.getAmountIncludingTax());
        }
        return result;
    }

    protected BigDecimal getSliceExcludingTax() {
        Collection<Payment> payments = this.getAllPayments();
        BigDecimal result = Numbers.BIG_DECIMAL_ZERO;
        for (Payment p : payments) {
            result = result.add(p.getAmountExcludingTax());
        }
        return result;
    }

    protected BigDecimal getSliceTax() {
        Collection<Payment> payments = this.getAllPayments();
        BigDecimal result = Numbers.BIG_DECIMAL_ZERO;
        for (Payment p : payments) {
            result = result.add(p.getAmountTax());
        }
        return result;
    }
}

