/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.kernels;

import de.uwemock.csvtools.CsvTable;
import de.uwemock.eur.accounts.Account;
import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.kernels.HtmlContentsHelper;
import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.eur.receipt.PoolManager;
import de.uwemock.eur.receipt.Receipt;
import de.uwemock.eur.receipt.ReceiptGroupManager;
import de.uwemock.eur.receipt.builder.CsvReceiptListBuilder;
import de.uwemock.eur.receipt.builder.ReceiptTableBuilder;
import de.uwemock.eur.receipt.builder.ReceiptWalker;
import de.uwemock.eur.receipt.comparators.ReceiptComparator;
import de.uwemock.eur.receipt.filter.ReceiptListFilter;
import de.uwemock.htmltools.HtmlContainer;
import de.uwemock.htmltools.HtmlContext;
import de.uwemock.htmltools.HtmlLineBreak;
import de.uwemock.htmltools.HtmlLink;
import de.uwemock.htmltools.HtmlText;
import de.uwemock.kernel.AbstractKernel;
import de.uwemock.tools.LoggingManager;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class KernelReceiptList
extends AbstractKernel<StringBuffer> {
    public static final String RESULT_HTML_DATA = "";
    public static final String RESULT_CSV_DATA = "";
    private ReceiptGroupManager receiptGroupManager;
    private PoolManager poolManager;
    private int timeFrame;
    private String timeFrameText;
    private Account[] accFilter;
    private ReceiptComparator receiptComparator;
    private ReceiptListFilter receiptFilter;

    public KernelReceiptList(ReceiptGroupManager receiptGroupManager, PoolManager poolManager, int timeFrame, String timeFrameText, Account[] accFilter, ReceiptComparator receiptComparator, ReceiptListFilter receiptFilter) {
        this.receiptGroupManager = receiptGroupManager;
        this.poolManager = poolManager;
        this.timeFrame = timeFrame;
        this.timeFrameText = timeFrameText;
        this.accFilter = accFilter;
        this.receiptComparator = receiptComparator;
        this.receiptFilter = receiptFilter;
    }

    @Override
    public StringBuffer work() {
        String journalCss = "body { font-family:Verdana,Arial,Helvetia,sans-serif; }\nh1 { }\nh3 { }\ntd.general_label { font-weight:bold; font-size:80%; }\ntd.general_contents { font-size:80%; }\nth { background-color:#e0e0e0; font-size:80%; }\ntable.result tr:nth-child(even) { background-color:#f0f0f0; font-size:80%; }\ntable.result tr:nth-child(odd) { background-color:#ffffff; font-size:80%; }\n.deleted { text-decoration:line-through; }\n.totalPaid { display:none; }\n.totalUnpaid { display:none; }\n.minitable { font-size:90%; }\ntd.leftcell { border-right:solid 1px black; }\ntd.rightcell { }\ntd.midcell { border-right:solid 1px black; }\n.amount { font-family:monospace; white-space:nowrap; }";
        String journalCssPrint = ".noprint { display:none; }";
        HtmlContext html = new HtmlContext();
        html.setTitle(TextPool.getString("htmlTitleReceiptList"));
        html.addStyleSheet(null, journalCss);
        html.addStyleSheet("print", journalCssPrint);
        html.addElement("h1", null, null, null, TextPool.getString("htmlTitleReceiptList"));
        html.addElement("h3", null, null, null, String.valueOf(this.timeFrameText) + " " + DataCenter.getInstance().getBusinessYear());
        html.addElement(DataCenter.getInstance().createGeneralDataHtmlTable());
        html.addLineBreak();
        HtmlContentsHelper.addSwitchDeleted(html);
        HtmlContentsHelper.addSwitchUnpaid(html);
        if (this.accFilter == null) {
            this.addTableForAccount(html, null);
        } else {
            Account[] accountArray = this.accFilter;
            int n = this.accFilter.length;
            int n2 = 0;
            while (n2 < n) {
                Account account = accountArray[n2];
                this.addTableForAccount(html, account);
                ++n2;
            }
        }
        this.putData("", html);
        return html.toStringBuffer();
    }

    private void addTableForAccount(HtmlContext html, Account account) {
        block18: {
            Receipt r;
            Iterator<AbstractReceipt> i;
            int accountNumber = -1;
            if (account != null) {
                accountNumber = account.getAccountNumber();
            }
            List<AbstractReceipt> receiptsToProcess = this.receiptGroupManager.getReceiptCollectionByTimeFrame(this.timeFrame);
            receiptsToProcess.addAll(this.poolManager.getReceiptCollectionByTimeFrame(this.timeFrame));
            if (account != null && accountNumber >= 0) {
                i = receiptsToProcess.iterator();
                while (i.hasNext()) {
                    r = i.next();
                    if (r.addsToAccount(accountNumber)) continue;
                    i.remove();
                }
            }
            if (this.receiptFilter != null) {
                i = receiptsToProcess.iterator();
                while (i.hasNext()) {
                    r = i.next();
                    if (this.receiptFilter.acceptReceipt(r)) continue;
                    i.remove();
                }
            }
            if (this.receiptComparator != null) {
                Collections.sort(receiptsToProcess, this.receiptComparator);
            }
            html.addElement("h4", null, null, null, account == null ? TextPool.getString("htmlTextAccountFilterAllAccounts") : String.valueOf(TextPool.getString("htmlTextAccountFilterSingleAccount")) + account.toString());
            ReceiptWalker walker = new ReceiptWalker(receiptsToProcess);
            ReceiptTableBuilder htmlBuilder = new ReceiptTableBuilder(html, account);
            CsvReceiptListBuilder csvBuilderIncludingDeleted = new CsvReceiptListBuilder(account, true);
            CsvReceiptListBuilder csvBuilderExcludingDeleted = new CsvReceiptListBuilder(account, false);
            walker.addReceiptProcessor(htmlBuilder);
            walker.addReceiptProcessor(csvBuilderIncludingDeleted);
            walker.addReceiptProcessor(csvBuilderExcludingDeleted);
            walker.run();
            html.addElement(htmlBuilder.getResult());
            CsvTable csvTableIncludingDeleted = csvBuilderIncludingDeleted.getResult();
            CsvTable csvTableExcludingDeleted = csvBuilderExcludingDeleted.getResult();
            html.addElement(DataCenter.getInstance().createGeneralInfoHtml());
            Calendar c = Calendar.getInstance();
            OutputStreamWriter writer = null;
            try {
                try {
                    File file = File.createTempFile(String.valueOf(String.format("%4d-%02d-%02d", c.get(1), c.get(2) + 1, c.get(5))) + "_eur_receipts", ".csv");
                    file.deleteOnExit();
                    writer = new FileWriter(file);
                    writer.write(csvTableIncludingDeleted.toCsvString().toString());
                    writer.flush();
                    HtmlLink link = new HtmlLink(file.getName());
                    link.addHtmlElement(new HtmlText(TextPool.getString("htmlTextLinkToCsv")));
                    HtmlContainer linkContainer = new HtmlContainer("p");
                    linkContainer.addCssClass("noprint");
                    linkContainer.addHtmlElement(link);
                    linkContainer.addHtmlElement(HtmlLineBreak.getInstance());
                    file = File.createTempFile(String.valueOf(String.format("%4d-%02d-%02d", c.get(1), c.get(2) + 1, c.get(5))) + "_eur_receipts", ".csv");
                    file.deleteOnExit();
                    writer = new FileWriter(file);
                    writer.write(csvTableExcludingDeleted.toCsvString().toString());
                    writer.flush();
                    link = new HtmlLink(file.getName());
                    link.addHtmlElement(new HtmlText(TextPool.getString("htmlTextLinkToCsvExcludingDeleted")));
                    linkContainer.addHtmlElement(link);
                    html.addElement(linkContainer);
                }
                catch (IOException e1) {
                    LoggingManager.logException(this.getClass(), e1);
                    if (writer == null) break block18;
                    try {
                        writer.close();
                    }
                    catch (IOException e2) {
                        LoggingManager.logException(this.getClass(), e2);
                    }
                }
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e2) {
                        LoggingManager.logException(this.getClass(), e2);
                    }
                }
            }
        }
    }
}

