/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.kernels;

import de.uwemock.eur.accounts.AccountList;
import de.uwemock.eur.calculation.plugins.AbstractEurPlugin;
import de.uwemock.eur.data.FileContext;
import de.uwemock.eur.data.TaxList;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.gui.ThinkingComboBoxModel;
import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.eur.receipt.DepreciationPool;
import de.uwemock.eur.receipt.PaymentTemplate;
import de.uwemock.eur.receipt.ReceiptGroupManager;
import de.uwemock.kernel.AbstractKernel;
import de.uwemock.tools.Numbers;
import de.uwemock.xmltools.XmlTools;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JProgressBar;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class KernelReadEuxFile
extends AbstractKernel<Void> {
    public static final String KERNEL_FILENAME = "FILENAME";
    public static final String KERNEL_EDITABLE = "EDITABLE";
    public static final String KERNEL_ACCOUNT_LIST = "ACCOUNT_LIST";
    public static final String KERNEL_RECEIPTS_LIST = "RECEIPTS_LIST";
    public static final String KERNEL_RECEIPT_GROUPS = "RECEIPT_GROUPS";
    public static final String KERNEL_DEPRECIATION_POOLS = "DEPRECIATION_POOLS";
    public static final String KERNEL_TAX_LIST = "TAX_LIST";
    public static final String KERNEL_PLUGINS_LIST = "PLUGINS_LIST";
    public static final String KERNEL_RECEIPT_DESCRIPTIONS = "RECEIPT_DESCRIPTIONS";
    public static final String KERNEL_PAYMENT_TEMPLATES = "RECEIPT_TEMPLATES";
    public static final String KERNEL_OWNER_NAME = "OWNER_NAME";
    public static final String KERNEL_OWNER_COMPANY = "OWNER_COMPANY";
    public static final String KERNEL_OWNER_ADDRESS = "OWNER_ADDRESS";
    public static final String KERNEL_OWNER_TAX_ID = "OWNER_TAX_ID";
    public static final String KERNEL_BUSINESS_YEAR = "BUSINESS_YEAR";
    public static final String KERNEL_CURRENCY = "CURRENCY";
    public static final String KERNEL_MAX_DESCRIPTIONS = "MAX_DESCRIPTIONS";
    public static final String KERNEL_FILE_CONTEXT = "FILE_CONTEXT";
    public static final String KERNEL_ATTACHMENT_DB_ERROR = "ATTACHMENT_DB_ERROR";
    public static final String KERNEL_SETTINGS_CLUSTERS = "SETTINGS_CLUSTERS";
    private String filename;
    private JProgressBar progressBar;
    private boolean readAccounts = true;
    private boolean readReceipts = true;
    private boolean readTaxes = true;
    private boolean readPlugins = true;
    private boolean attachmentDBError = false;

    public KernelReadEuxFile(String filename) {
        this(filename, null);
    }

    public KernelReadEuxFile(String filename, JProgressBar progressBar) {
        this.filename = filename;
        this.progressBar = progressBar;
    }

    public KernelReadEuxFile(String filename, boolean readTaxes, boolean readAccounts, boolean readPlugins, boolean readReceipts) {
        this(filename, null);
        this.readTaxes = readTaxes;
        this.readAccounts = readAccounts;
        this.readPlugins = readPlugins;
        this.readReceipts = readReceipts;
    }

    @Override
    public Void work() throws Exception {
        Logger logger = Logger.getLogger(this.getClass().getName());
        boolean loggerIsLoggingFiner = logger.isLoggable(Level.FINER);
        boolean newEditableState = true;
        AccountList newAccountList = null;
        LinkedList<AbstractReceipt> newReceiptsList = null;
        Map<String, LinkedList<Integer>> newReceiptGroupsList = null;
        LinkedList<DepreciationPool> newPoolsList = null;
        TaxList newTaxList = null;
        ArrayList<AbstractEurPlugin> newPluginsList = null;
        ThinkingComboBoxModel receiptDescriptions = new ThinkingComboBoxModel();
        DefaultComboBoxModel<PaymentTemplate> receiptTemplates = new DefaultComboBoxModel<PaymentTemplate>();
        HashMap settingsClusters = new HashMap();
        String newOwnerName = null;
        String newOwnerCompany = null;
        String newOwnerAddress = null;
        String newOwnerTaxId = null;
        int newBusinessYear = 0;
        String newCurrency = null;
        int newMaxReceiptDescriptions = 5;
        XMLStreamReader reader = null;
        Reader xmlReaderFromFileContext = null;
        FileContext context = new FileContext(this.filename);
        try {
            try {
                boolean hasNext;
                XMLInputFactory inputFactory = XMLInputFactory.newInstance();
                xmlReaderFromFileContext = context.getXMLDataStream();
                if (this.progressBar != null) {
                    this.progressBar.setIndeterminate(true);
                }
                reader = inputFactory.createXMLStreamReader(xmlReaderFromFileContext);
                do {
                    String editableState;
                    if (XmlTools.isStartElement(reader, "eur") && (editableState = XmlTools.getOneSingleAttributeValue(reader, "editable")) != null) {
                        boolean bl = newEditableState = !"no".equals(editableState);
                    }
                    if (reader.hasName() && reader.isStartElement()) {
                        if (reader.getName().toString().equals("general")) {
                            logger.finer("Found general data");
                            while (reader.hasNext()) {
                                reader.next();
                                if (XmlTools.isEndElement(reader, "general")) break;
                                if (XmlTools.isStartElement(reader, "name")) {
                                    logger.finest("-> Found name");
                                    newOwnerName = reader.getElementText();
                                }
                                if (XmlTools.isStartElement(reader, "company")) {
                                    logger.finest("-> Found company");
                                    newOwnerCompany = reader.getElementText();
                                }
                                if (XmlTools.isStartElement(reader, "address")) {
                                    logger.finest("-> Found address");
                                    newOwnerAddress = reader.getElementText();
                                }
                                if (XmlTools.isStartElement(reader, "taxid")) {
                                    logger.finest("-> Found tax id");
                                    newOwnerTaxId = reader.getElementText();
                                }
                                if (XmlTools.isStartElement(reader, "businessyear")) {
                                    logger.finest("-> Found business year");
                                    newBusinessYear = Numbers.getIntFromString(reader.getElementText(), 0);
                                }
                                if (XmlTools.isStartElement(reader, "currency")) {
                                    logger.finest("-> Found currency");
                                    newCurrency = reader.getElementText();
                                }
                                if (XmlTools.isStartElement(reader, "maxreceiptdescriptions")) {
                                    logger.finest("-> Found max number of receipt descriptions");
                                    newMaxReceiptDescriptions = Numbers.getIntFromString(reader.getElementText(), 5);
                                }
                                if (XmlTools.isStartElement(reader, "receipttext")) {
                                    logger.finest("-> Found list of receipt descriptions");
                                    while (reader.hasNext()) {
                                        reader.next();
                                        if (XmlTools.isEndElement(reader, "receipttext")) break;
                                        if (!XmlTools.isStartElement(reader, "item")) continue;
                                        logger.finest("--> Item...");
                                        String fixedAttr = XmlTools.getOneSingleAttributeValue(reader, "fixed");
                                        boolean fixed = fixedAttr == null ? false : fixedAttr.equals("yes");
                                        receiptDescriptions.addToList(reader.getElementText(), fixed);
                                    }
                                }
                                if (XmlTools.isStartElement(reader, "receipttemplates")) {
                                    logger.finest("-> Found list of receipt templates");
                                    while (reader.hasNext()) {
                                        reader.next();
                                        if (XmlTools.isEndElement(reader, "receipttemplates")) break;
                                        if (!XmlTools.isStartElement(reader, "paymenttemplate")) continue;
                                        logger.finest("--> Template...");
                                        PaymentTemplate template = PaymentTemplate.readFromXML(reader);
                                        if (template == null) continue;
                                        receiptTemplates.addElement(template);
                                    }
                                }
                                if (!XmlTools.isStartElement(reader, "settingscluster")) continue;
                                logger.finer("Found settings for depreciation classes");
                                String className = XmlTools.getOneSingleAttributeValue(reader, "name");
                                if (loggerIsLoggingFiner) {
                                    logger.finer("Found settings cluster for class " + className);
                                }
                                HashMap<String, String> clusterValues = new HashMap<String, String>();
                                while (reader.hasNext()) {
                                    reader.next();
                                    if (XmlTools.isEndElement(reader, "settingscluster")) break;
                                    if (!reader.isStartElement()) continue;
                                    String settingName = XmlTools.getOneSingleAttributeValue(reader, "name");
                                    String settingValue = reader.getElementText();
                                    if (settingName == null) continue;
                                    clusterValues.put(settingName, settingValue);
                                }
                                settingsClusters.put(className, clusterValues);
                            }
                            if (loggerIsLoggingFiner) {
                                logger.finer("-> " + newOwnerName + ", " + newOwnerAddress + ", " + newOwnerCompany + ", " + newOwnerTaxId + ", " + newBusinessYear);
                            }
                        }
                        if (this.readAccounts && XmlTools.isStartElement(reader, "accounts")) {
                            logger.finer("Found accounts list");
                            newAccountList = AccountList.readFromXML(reader);
                        }
                        if (this.readTaxes && XmlTools.isStartElement(reader, "taxlist")) {
                            logger.finer("Found tax list");
                            newTaxList = TaxList.readFromXML(reader);
                        }
                        if (this.readPlugins && XmlTools.isStartElement(reader, "plugins")) {
                            logger.finer("Found plugins list");
                            newPluginsList = new ArrayList<AbstractEurPlugin>();
                            while (reader.hasNext()) {
                                reader.next();
                                if (XmlTools.isEndElement(reader, "plugins")) break;
                                if (!XmlTools.isStartElement(reader, "plugin")) continue;
                                logger.finer("Plugin...");
                                AbstractEurPlugin plugin = AbstractEurPlugin.readFromXML(reader, newAccountList, newTaxList);
                                if (plugin == null) continue;
                                newPluginsList.add(plugin);
                            }
                        }
                        if (this.readReceipts && XmlTools.isStartElement(reader, "receipts")) {
                            logger.finer("Found receipts list");
                            newReceiptsList = ReceiptGroupManager.readFromXML(reader);
                            if (loggerIsLoggingFiner) {
                                logger.finer("Found " + newReceiptsList.size() + " receipts");
                            }
                        }
                        if (this.readReceipts && XmlTools.isStartElement(reader, "receiptgroups")) {
                            logger.finer("Found receipt groups list");
                            newReceiptGroupsList = ReceiptGroupManager.readGroupsFromXML(reader);
                            if (loggerIsLoggingFiner) {
                                logger.finer("Found " + newReceiptGroupsList.size() + " groups");
                            }
                        }
                        if (this.readReceipts && XmlTools.isStartElement(reader, "depreciationpools")) {
                            logger.finer("Found depreciation pools");
                            newPoolsList = new LinkedList<DepreciationPool>();
                            while (reader.hasNext()) {
                                reader.next();
                                if (XmlTools.isEndElement(reader, "depreciationpools")) break;
                                if (!XmlTools.isStartElement(reader, "pool")) continue;
                                logger.finer("Pool...");
                                DepreciationPool pool = DepreciationPool.readFromXML(reader);
                                if (pool == null) continue;
                                newPoolsList.add(pool);
                            }
                            if (loggerIsLoggingFiner) {
                                logger.finer("Found " + newReceiptGroupsList.size() + " groups");
                            }
                        }
                    }
                    if (!(hasNext = reader.hasNext())) continue;
                    reader.next();
                } while (hasNext);
            }
            catch (FileNotFoundException e) {
                context.close();
                throw new FileNotFoundException(TextPool.getString("msgFileNotFound"));
            }
            catch (IOException e) {
                context.close();
                throw new IOException(TextPool.getString("msgReadError"));
            }
            catch (XMLStreamException e) {
                context.close();
                throw new XMLStreamException(TextPool.getString("msgReadError"));
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (XMLStreamException ex) {
                    ex.printStackTrace();
                }
            }
            if (xmlReaderFromFileContext != null) {
                try {
                    xmlReaderFromFileContext.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        if (this.filename != null) {
            this.putData(KERNEL_FILENAME, this.filename);
        }
        if (newAccountList != null) {
            this.putData(KERNEL_ACCOUNT_LIST, newAccountList);
        }
        if (newReceiptsList != null) {
            this.putData(KERNEL_RECEIPTS_LIST, newReceiptsList);
        }
        if (newReceiptGroupsList != null) {
            this.putData(KERNEL_RECEIPT_GROUPS, newReceiptGroupsList);
        }
        if (newPoolsList != null) {
            this.putData(KERNEL_DEPRECIATION_POOLS, newPoolsList);
        }
        if (newTaxList != null) {
            this.putData(KERNEL_TAX_LIST, newTaxList);
        }
        if (newPluginsList != null) {
            this.putData(KERNEL_PLUGINS_LIST, newPluginsList);
        }
        if (receiptDescriptions != null) {
            this.putData(KERNEL_RECEIPT_DESCRIPTIONS, receiptDescriptions);
        }
        if (receiptTemplates != null) {
            this.putData(KERNEL_PAYMENT_TEMPLATES, receiptTemplates);
        }
        if (newOwnerName != null) {
            this.putData(KERNEL_OWNER_NAME, newOwnerName);
        }
        if (newOwnerCompany != null) {
            this.putData(KERNEL_OWNER_COMPANY, newOwnerCompany);
        }
        if (newOwnerAddress != null) {
            this.putData(KERNEL_OWNER_ADDRESS, newOwnerAddress);
        }
        if (newOwnerTaxId != null) {
            this.putData(KERNEL_OWNER_TAX_ID, newOwnerTaxId);
        }
        if (newCurrency != null) {
            this.putData(KERNEL_CURRENCY, newCurrency);
        }
        if (newBusinessYear != 0) {
            this.putData(KERNEL_BUSINESS_YEAR, newBusinessYear);
        }
        if (newMaxReceiptDescriptions != 0) {
            this.putData(KERNEL_MAX_DESCRIPTIONS, newMaxReceiptDescriptions);
        }
        this.putData(KERNEL_FILE_CONTEXT, context);
        this.putData(KERNEL_ATTACHMENT_DB_ERROR, this.attachmentDBError);
        this.putData(KERNEL_SETTINGS_CLUSTERS, settingsClusters);
        this.putData(KERNEL_EDITABLE, newEditableState);
        return null;
    }
}

