/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.kernels;

import de.uwemock.csvtools.CsvTable;
import de.uwemock.eur.data.Constants;
import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.data.LocalizationManager;
import de.uwemock.eur.depreciation.DepreciationInfoRecord;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.kernels.HtmlContentsHelper;
import de.uwemock.eur.receipt.DepreciationPool;
import de.uwemock.eur.receipt.PoolManager;
import de.uwemock.eur.receipt.Receipt;
import de.uwemock.eur.receipt.builder.ReceiptTableBuilder;
import de.uwemock.eur.receipt.builder.ReceiptWalker;
import de.uwemock.htmltools.HtmlContainer;
import de.uwemock.htmltools.HtmlContext;
import de.uwemock.htmltools.HtmlLink;
import de.uwemock.htmltools.HtmlTable;
import de.uwemock.htmltools.HtmlText;
import de.uwemock.kernel.AbstractKernel;
import de.uwemock.tools.LoggingManager;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class KernelPoolList
extends AbstractKernel<StringBuffer> {
    public static final String RESULT_HTML_DATA = "";
    public static final String RESULT_CSV_DATA = "";
    public static final String RESULT_RESULT_MAP = "resultmap";
    private PoolManager poolManager;
    private int businessYear;
    private boolean createTestData;
    private boolean expandPools = true;
    private Map<Integer, DepreciationResult> resultMap;

    public KernelPoolList(PoolManager manager, int businessYear, boolean expandPools, boolean createTestData) {
        this.poolManager = manager;
        this.businessYear = businessYear;
        this.expandPools = expandPools;
        this.createTestData = createTestData;
        if (createTestData) {
            this.resultMap = new HashMap<Integer, DepreciationResult>();
            this.putData(RESULT_RESULT_MAP, this.resultMap);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public StringBuffer work() {
        CsvTable csvTable;
        HtmlContext html;
        block36: {
            void var15_18;
            ArrayList<DepreciationPool> receiptsToProcess = new ArrayList<DepreciationPool>();
            List<Integer> yearsWithNewPools = this.poolManager.getContainedYears();
            for (Integer year : yearsWithNewPools) {
                receiptsToProcess.add(this.poolManager.getDepreciationPoolForYear(year));
            }
            String poolCss = "body { font-family:Verdana,Arial,Helvetia,sans-serif; }\nh1 { }\nh3 { }\ntd.general_label { font-weight:bold; font-size:90%; }\ntd.general_contents { font-size:90%; }\nth { background-color:#e0e0e0; font-size:90%; }\ntr.row_even { background-color:#f0f0f0; font-size:90%; }\ntr.row_odd { background-color:#ffffff; font-size:90%; }\n.deleted { text-decoration:line-through; }\n.totalPaid { display:none; }\n.totalUnpaid { display:none; }\n.minitable { font-size:90%; }\ntd.leftcell { border-right:solid 1px black; }\ntd.rightcell { }\ntd.midcell { border-right:solid 1px black; }\ntd.total { font-weight:bold; font-size:90%; }\n.amount { font-family:monospace; white-space:nowrap; text-align:right; }";
            String poolCssPrint = ".noprint { display:none; }\n";
            String title = String.valueOf(TextPool.getString("htmlTitlePoolList")) + " " + this.businessYear;
            html = new HtmlContext();
            html.setTitle(title);
            html.addStyleSheet(null, poolCss);
            html.addStyleSheet("print", poolCssPrint);
            html.addElement("h1", null, null, null, title);
            html.addElement(DataCenter.getInstance().createGeneralDataHtmlTable());
            html.addLineBreak();
            HtmlContentsHelper.addSwitchDeleted(html);
            String[] COLUMNS_POOL_LIST = TextPool.getArray("COLUMNS_POOL_LIST");
            HtmlTable htmlTable = new HtmlTable(html);
            csvTable = new CsvTable();
            htmlTable.setBorder("1px solid black");
            htmlTable.setCellspacing("0px");
            htmlTable.setRowAsHeader(0, true);
            int i = 0;
            while (i < COLUMNS_POOL_LIST.length) {
                htmlTable.setContents(i, 0, COLUMNS_POOL_LIST[i]);
                htmlTable.setHeadline(i, 0, true);
                csvTable.setContents(i, 0, COLUMNS_POOL_LIST[i]);
                ++i;
            }
            int y = 1;
            BigDecimal totalAmountDepreciated = Constants.ZERO;
            BigDecimal totalValueAtStartOfYear = Constants.ZERO;
            BigDecimal totalAmountRemoved = Constants.ZERO;
            BigDecimal totalValueAtEndOfYear = Constants.ZERO;
            for (Receipt receipt : receiptsToProcess) {
                boolean isFinalDepreciationYear;
                DepreciationPool pool = (DepreciationPool)receipt;
                if (this.expandPools) {
                    html.addElement("h3", null, null, null, String.valueOf(TextPool.getString("htmlTextPoolFromYear")) + pool.getDate().getYear());
                    ReceiptWalker walker = new ReceiptWalker(pool.getReceiptList());
                    ReceiptTableBuilder builder = new ReceiptTableBuilder(html);
                    walker.addReceiptProcessor(builder);
                    walker.run();
                    html.addElement(builder.getResult());
                }
                if (y % 2 == 0) {
                    htmlTable.setRowCssClass(y, "row_even");
                } else {
                    htmlTable.setRowCssClass(y, "row_odd");
                }
                DepreciationInfoRecord info = receipt.getDepreciationStrategy().getInfoRecord(this.businessYear);
                BigDecimal valueAtStartOfYear = info.getAmountStartOfYear();
                BigDecimal valueDepreciatedThisYear = info.getDepreciation();
                BigDecimal valueAtEndOfYear = info.getAmountEndOfYear();
                if (this.createTestData) {
                    DepreciationResult dr = new DepreciationResult(valueAtStartOfYear, valueDepreciatedThisYear, valueAtEndOfYear);
                    this.resultMap.put(receipt.getNumber(), dr);
                }
                boolean bl = isFinalDepreciationYear = !receipt.getDepreciationStrategy().isDepreciatedInYear(this.businessYear + 1);
                if (isFinalDepreciationYear) {
                    totalAmountRemoved = totalAmountRemoved.add(valueDepreciatedThisYear);
                } else {
                    totalAmountDepreciated = totalAmountDepreciated.add(valueDepreciatedThisYear);
                }
                totalValueAtStartOfYear = totalValueAtStartOfYear.add(valueAtStartOfYear);
                totalValueAtEndOfYear = totalValueAtEndOfYear.add(valueAtEndOfYear);
                int x = 0;
                while (x < COLUMNS_POOL_LIST.length) {
                    String csvContents;
                    String htmlContents;
                    switch (x) {
                        case 0: {
                            csvContents = htmlContents = Integer.toString(receipt.getDate().getYear());
                            htmlTable.setAlign(x, y, "right");
                            break;
                        }
                        case 1: {
                            htmlContents = LocalizationManager.amountToCurrencyString((BigDecimal)receipt.getReceiptInfo(6));
                            csvContents = LocalizationManager.amountToPlainString((BigDecimal)receipt.getReceiptInfo(6));
                            htmlTable.setCssClass(x, y, "amount");
                            break;
                        }
                        case 2: {
                            htmlContents = LocalizationManager.amountToCurrencyString(valueAtStartOfYear);
                            csvContents = LocalizationManager.amountToPlainString(valueAtStartOfYear);
                            htmlTable.setCssClass(x, y, "amount");
                            break;
                        }
                        case 3: {
                            htmlContents = isFinalDepreciationYear ? "" : LocalizationManager.amountToCurrencyString(valueDepreciatedThisYear);
                            csvContents = isFinalDepreciationYear ? "" : LocalizationManager.amountToPlainString((BigDecimal)receipt.getReceiptInfo(7));
                            htmlTable.setCssClass(x, y, "amount");
                            break;
                        }
                        case 4: {
                            htmlContents = isFinalDepreciationYear ? LocalizationManager.amountToCurrencyString(valueDepreciatedThisYear) : "";
                            csvContents = isFinalDepreciationYear ? LocalizationManager.amountToPlainString((BigDecimal)receipt.getReceiptInfo(7)) : "";
                            htmlTable.setCssClass(x, y, "amount");
                            break;
                        }
                        case 5: {
                            htmlContents = LocalizationManager.amountToCurrencyString(valueAtEndOfYear);
                            csvContents = LocalizationManager.amountToPlainString(valueAtEndOfYear);
                            htmlTable.setCssClass(x, y, "amount");
                            break;
                        }
                        default: {
                            htmlContents = "";
                            csvContents = "";
                        }
                    }
                    if (receipt.isDeleted() && receipt.isPaid()) {
                        htmlContents = "<span class=\"deleted\">" + htmlContents + "</span>";
                    }
                    if (!receipt.isDeleted() && !receipt.isPaid()) {
                        htmlContents = "<span class=\"unpaid\">" + htmlContents + "</span>";
                    }
                    if (receipt.isDeleted() && !receipt.isPaid()) {
                        htmlContents = "<span class=\"deleted unpaid\">" + htmlContents + "</span>";
                    }
                    htmlTable.setContents(x, y, htmlContents);
                    htmlTable.setVAlign(x, y, "top");
                    csvTable.setContents(x, y, csvContents);
                    ++x;
                }
                ++y;
            }
            htmlTable.setContents(2, y, LocalizationManager.amountToCurrencyString(totalValueAtStartOfYear));
            htmlTable.setContents(3, y, LocalizationManager.amountToCurrencyString(totalAmountDepreciated));
            htmlTable.setContents(4, y, LocalizationManager.amountToCurrencyString(totalAmountRemoved));
            htmlTable.setContents(5, y, LocalizationManager.amountToCurrencyString(totalValueAtEndOfYear));
            int n = 2;
            while (var15_18 <= 5) {
                htmlTable.setAlign((int)var15_18, y, "right");
                htmlTable.setNoWrap((int)var15_18, y, true);
                htmlTable.setCssClass((int)var15_18, y, "total");
                htmlTable.addCssClass((int)var15_18, y, "amount");
                ++var15_18;
            }
            html.addElement("h3", null, null, null, TextPool.getString("htmlTextSummary"));
            html.addElement(htmlTable);
            html.addElement(DataCenter.getInstance().createGeneralInfoHtml());
            Calendar calendar = Calendar.getInstance();
            OutputStreamWriter writer = null;
            try {
                try {
                    File file = File.createTempFile(String.valueOf(String.format("%4d-%02d-%02d", calendar.get(1), calendar.get(2) + 1, calendar.get(5))) + "_eur_receipts", ".csv");
                    file.deleteOnExit();
                    writer = new FileWriter(file);
                    writer.write(csvTable.toCsvString().toString());
                    writer.flush();
                    HtmlLink link = new HtmlLink(file.getName());
                    link.addHtmlElement(new HtmlText(TextPool.getString("htmlTextLinkToCsv")));
                    HtmlContainer linkContainer = new HtmlContainer("p");
                    linkContainer.addCssClass("noprint");
                    linkContainer.addHtmlElement(link);
                    html.addElement(linkContainer);
                }
                catch (IOException e1) {
                    LoggingManager.logException(this.getClass(), e1);
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException e2) {
                            LoggingManager.logException(this.getClass(), e2);
                        }
                    }
                    break block36;
                }
            }
            catch (Throwable throwable) {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e2) {
                        LoggingManager.logException(this.getClass(), e2);
                    }
                }
                throw throwable;
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e2) {
                    LoggingManager.logException(this.getClass(), e2);
                }
            }
        }
        this.putData("", html.toStringBuffer());
        this.putData("", csvTable);
        return html.toStringBuffer();
    }

    public static class DepreciationResult {
        public BigDecimal valueAtStartOfYear;
        public BigDecimal valueDepreciatedThisYear;
        public BigDecimal valueAtEndOfYear;

        public DepreciationResult(BigDecimal valueAtStartOfYear, BigDecimal valueDepreciatedThisYear, BigDecimal valueAtEndOfYear) {
            this.valueAtStartOfYear = valueAtStartOfYear;
            this.valueDepreciatedThisYear = valueDepreciatedThisYear;
            this.valueAtEndOfYear = valueAtEndOfYear;
        }
    }
}

