/*
 * Decompiled with CFR 0.152.
 */
package de.uwemock.eur.kernels;

import de.uwemock.csvtools.CsvTable;
import de.uwemock.eur.accounts.Account;
import de.uwemock.eur.data.Constants;
import de.uwemock.eur.data.DataCenter;
import de.uwemock.eur.data.LocalizationManager;
import de.uwemock.eur.depreciation.DepreciationInfoRecord;
import de.uwemock.eur.gui.TextPool;
import de.uwemock.eur.receipt.AbstractReceipt;
import de.uwemock.eur.receipt.ReceiptGroupManager;
import de.uwemock.htmltools.HtmlContainer;
import de.uwemock.htmltools.HtmlContext;
import de.uwemock.htmltools.HtmlLink;
import de.uwemock.htmltools.HtmlTable;
import de.uwemock.htmltools.HtmlText;
import de.uwemock.kernel.AbstractKernel;
import de.uwemock.tools.LoggingManager;
import de.uwemock.tools.Numbers;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;

public class KernelMonthlySummary
extends AbstractKernel<StringBuffer> {
    private ReceiptGroupManager receiptGroupManager;
    private DataCenter dataCenter;
    private boolean calculateTaxAccounts;

    public KernelMonthlySummary(ReceiptGroupManager manager, DataCenter dataCenter, boolean calculateTaxAccounts) {
        this.receiptGroupManager = manager;
        this.dataCenter = dataCenter;
        this.calculateTaxAccounts = calculateTaxAccounts;
    }

    @Override
    public StringBuffer work() throws Exception {
        CsvTable csvTable;
        HtmlContext html;
        block42: {
            List<AbstractReceipt> receiptsToProcess = this.receiptGroupManager.getAllReceiptsGroup().getReceiptList();
            BigDecimal[] incomeExcludingTax = new BigDecimal[13];
            BigDecimal[] incomeIncludingTax = new BigDecimal[13];
            BigDecimal[] expensesExcludingTax = new BigDecimal[13];
            BigDecimal[] expensesIncludingTax = new BigDecimal[13];
            BigDecimal[] incomeVAT = new BigDecimal[13];
            BigDecimal[] expenseVAT = new BigDecimal[13];
            int i = 1;
            while (i <= 12) {
                incomeExcludingTax[i] = Constants.ZERO;
                incomeIncludingTax[i] = Constants.ZERO;
                expensesExcludingTax[i] = Constants.ZERO;
                expensesIncludingTax[i] = Constants.ZERO;
                incomeVAT[i] = Constants.ZERO;
                expenseVAT[i] = Constants.ZERO;
                ++i;
            }
            for (AbstractReceipt r : receiptsToProcess) {
                if (r.isDeleted() || !r.isPaid()) continue;
                int month = r.getDate().getMonth();
                Collection<Integer> accounts = r.accountNumbersAddedTo();
                for (Integer accountNumber : accounts) {
                    Account account = DataCenter.getInstance().getAccountList().getByAccountNumber(accountNumber);
                    if (account == null || !this.calculateTaxAccounts && account.isTaxAccount()) continue;
                    BigDecimal tax = Constants.ZERO;
                    if (!r.hasDepreciationStrategy() || r.hasDepreciationStrategy() && r.getDepreciationStrategy().getStartYear() == this.dataCenter.getBusinessYear()) {
                        tax = r.amountTaxAddedToAccount(accountNumber);
                    }
                    if (account.isIncomeAccount()) {
                        if (!account.isTaxAccount()) {
                            incomeExcludingTax[month] = incomeExcludingTax[month].add(r.amountExcludingTaxAddedToAccount(accountNumber));
                        }
                        incomeIncludingTax[month] = incomeIncludingTax[month].add(r.amountExcludingTaxAddedToAccount(accountNumber)).add(tax);
                        incomeVAT[month] = incomeVAT[month].add(tax);
                    }
                    if (!account.isSpendingsAccount()) continue;
                    BigDecimal amountExcludingTaxToAdd = null;
                    if (r.hasDepreciationStrategy()) {
                        DepreciationInfoRecord infoRecord = r.getDepreciationStrategy().getInfoRecord(this.dataCenter.getBusinessYear());
                        amountExcludingTaxToAdd = infoRecord.getDepreciation().add(infoRecord.getExtraDepreciation());
                    } else {
                        amountExcludingTaxToAdd = r.amountExcludingTaxAddedToAccount(accountNumber);
                    }
                    BigDecimal amountIncludingTaxToAdd = amountExcludingTaxToAdd.add(tax);
                    if (!account.isTaxAccount()) {
                        expensesExcludingTax[month] = expensesExcludingTax[month].add(amountExcludingTaxToAdd);
                    }
                    expensesIncludingTax[month] = expensesIncludingTax[month].add(amountIncludingTaxToAdd);
                    expenseVAT[month] = expenseVAT[month].add(tax);
                }
            }
            String summaryCss = "body { font-family:Verdana,Arial,Helvetia,sans-serif; }\nh1 { }\nh3 { }\ntd.general_label { font-weight:bold; }\ntd.general_amount { font-size:80%; text-align:right; }\nth { background-color:#e0e0e0; }\ntr.row_even { background-color:#ffffff; }\ntr.row_odd { background-color:#f0f0f0; }\n";
            String summaryCssPrint = ".noprint { display:none; }";
            html = new HtmlContext();
            html.setTitle(TextPool.getString("htmlTitleMonthlySummary"));
            html.addStyleSheet(null, summaryCss);
            html.addStyleSheet("print", summaryCssPrint);
            html.addElement("h1", null, null, null, TextPool.getString("htmlTitleMonthlySummary"));
            html.addElement(DataCenter.getInstance().createGeneralDataHtmlTable());
            html.addLineBreak();
            String[] COLUMNS_MONTHLY_SUMMARY = TextPool.getArray("COLUMNS_MONTHLY_SUMMARY");
            String[] COLUMNS_MONTHLY_SUMMARY_CSV = TextPool.getArray("COLUMNS_MONTHLY_SUMMARY_CSV");
            HtmlTable htmlTable = new HtmlTable(html, false);
            csvTable = new CsvTable();
            htmlTable.setBorder("1px solid black");
            htmlTable.setCellspacing("0px");
            htmlTable.setColspan(1, 0, 2);
            htmlTable.setContents(1, 0, TextPool.getString("labelInfoAmountIncludingTax"));
            htmlTable.setColspan(3, 0, 2);
            htmlTable.setContents(3, 0, TextPool.getString("labelInfoAmountExcludingTax"));
            int x = 0;
            while (x <= 5) {
                htmlTable.setHeadline(x, 0, true);
                ++x;
            }
            x = 0;
            while (x < COLUMNS_MONTHLY_SUMMARY.length) {
                htmlTable.setHeadline(x, 1, true);
                htmlTable.setContents(x, 1, COLUMNS_MONTHLY_SUMMARY[x]);
                csvTable.setContents(x, 0, COLUMNS_MONTHLY_SUMMARY_CSV[x]);
                ++x;
            }
            BigDecimal[] sums = new BigDecimal[8];
            int i2 = 0;
            while (i2 < 8) {
                sums[i2] = Constants.ZERO;
                ++i2;
            }
            int y = 2;
            int month = 1;
            while (month <= 12) {
                htmlTable.setRowCssClass(y, y % 2 == 0 ? "row_even" : "row_odd");
                int x2 = 0;
                while (x2 <= 7) {
                    BigDecimal value;
                    htmlTable.setCssClass(x2, y, "general_amount");
                    switch (x2) {
                        case 0: {
                            htmlTable.setContents(x2, y, TextPool.MONTHS[month - 1]);
                            htmlTable.setCssClass(x2, y, "general_label");
                            csvTable.setContents(x2, y, TextPool.MONTHS[month - 1]);
                            value = null;
                            break;
                        }
                        case 1: {
                            value = incomeIncludingTax[month];
                            break;
                        }
                        case 2: {
                            value = expensesIncludingTax[month].negate();
                            break;
                        }
                        case 3: {
                            value = incomeIncludingTax[month].subtract(expensesIncludingTax[month]);
                            break;
                        }
                        case 4: {
                            value = incomeExcludingTax[month];
                            break;
                        }
                        case 5: {
                            value = expensesExcludingTax[month].negate();
                            break;
                        }
                        case 6: {
                            value = incomeVAT[month];
                            break;
                        }
                        case 7: {
                            value = expenseVAT[month];
                            break;
                        }
                        default: {
                            value = null;
                        }
                    }
                    if (value != null) {
                        sums[x2] = sums[x2].add(value);
                        htmlTable.setContents(x2, y, LocalizationManager.amountToCurrencyString(value));
                        if (Numbers.isNegative(value)) {
                            htmlTable.setCssStyle(x2, y, "color:red;");
                        }
                        csvTable.setContents(x2, y - 1, LocalizationManager.amountToPlainString(value));
                    }
                    ++x2;
                }
                ++y;
                ++month;
            }
            htmlTable.setRowAsFooter(y, true);
            htmlTable.setContents(0, y, TextPool.getString("htmlTextSum"));
            htmlTable.setCssClass(0, y, "general_label");
            int x3 = 1;
            while (x3 <= 7) {
                htmlTable.setContents(x3, y, LocalizationManager.amountToCurrencyString(sums[x3]));
                htmlTable.setCssStyle(x3, y, "font-weight:bold;");
                if (Numbers.isNegative(sums[x3])) {
                    htmlTable.setCssStyle(x3, y, "font-weight:bold;color:red;");
                }
                ++x3;
            }
            html.addElement(htmlTable);
            html.addElement(DataCenter.getInstance().createGeneralInfoHtml());
            Calendar c = Calendar.getInstance();
            OutputStreamWriter writer = null;
            try {
                try {
                    File file = File.createTempFile(String.valueOf(String.format("%4d-%02d-%02d", c.get(1), c.get(2) + 1, c.get(5))) + "_eur_months", ".csv");
                    file.deleteOnExit();
                    writer = new FileWriter(file);
                    writer.write(csvTable.toCsvString().toString());
                    writer.flush();
                    HtmlLink link = new HtmlLink(file.getName());
                    link.addHtmlElement(new HtmlText(TextPool.getString("htmlTextLinkToCsv")));
                    HtmlContainer linkContainer = new HtmlContainer("p");
                    linkContainer.addCssClass("noprint");
                    linkContainer.addHtmlElement(link);
                    html.addElement(linkContainer);
                }
                catch (IOException e1) {
                    LoggingManager.logException(this.getClass(), e1);
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException e2) {
                            LoggingManager.logException(this.getClass(), e2);
                        }
                    }
                    break block42;
                }
            }
            catch (Throwable throwable) {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException e2) {
                        LoggingManager.logException(this.getClass(), e2);
                    }
                }
                throw throwable;
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e2) {
                    LoggingManager.logException(this.getClass(), e2);
                }
            }
        }
        this.putData("", html.toStringBuffer());
        this.putData("", csvTable);
        return html.toStringBuffer();
    }
}

